/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.opa.OpaBatchAccessControl;
import io.trino.plugin.opa.OpaConfig;
import io.trino.plugin.opa.OpaHighLevelClient;
import io.trino.plugin.opa.schema.OpaPluginContext;
import io.trino.plugin.opa.schema.OpaQueryContext;
import io.trino.plugin.opa.schema.OpaQueryInput;
import io.trino.plugin.opa.schema.OpaQueryInputAction;
import io.trino.plugin.opa.schema.OpaQueryInputResource;
import io.trino.plugin.opa.schema.OpaViewExpression;
import io.trino.plugin.opa.schema.TrinoCatalogSessionProperty;
import io.trino.plugin.opa.schema.TrinoFunction;
import io.trino.plugin.opa.schema.TrinoGrantPrincipal;
import io.trino.plugin.opa.schema.TrinoIdentity;
import io.trino.plugin.opa.schema.TrinoSchema;
import io.trino.plugin.opa.schema.TrinoTable;
import io.trino.plugin.opa.schema.TrinoUser;
import io.trino.spi.QueryId;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import java.security.Principal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public sealed class OpaAccessControl
implements SystemAccessControl
permits OpaBatchAccessControl {
    private final LifeCycleManager lifeCycleManager;
    private final OpaHighLevelClient opaHighLevelClient;
    private final boolean allowPermissionManagementOperations;
    private final OpaPluginContext pluginContext;

    @Inject
    public OpaAccessControl(LifeCycleManager lifeCycleManager, OpaHighLevelClient opaHighLevelClient, OpaConfig config, OpaPluginContext pluginContext) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.opaHighLevelClient = Objects.requireNonNull(opaHighLevelClient, "opaHighLevelClient is null");
        this.allowPermissionManagementOperations = config.getAllowPermissionManagementOperations();
        this.pluginContext = Objects.requireNonNull(pluginContext, "pluginContext is null");
    }

    public void checkCanImpersonateUser(Identity identity, String userName) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(identity), "ImpersonateUser", () -> AccessDeniedException.denyImpersonateUser((String)identity.getUser(), (String)userName), OpaQueryInputResource.builder().user(new TrinoUser(userName)).build());
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
    }

    public void checkCanExecuteQuery(Identity identity, QueryId queryId) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(identity), "ExecuteQuery", AccessDeniedException::denyExecuteQuery);
    }

    public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(identity), "ViewQueryOwnedBy", AccessDeniedException::denyViewQuery, OpaQueryInputResource.builder().user(new TrinoUser(queryOwner)).build());
    }

    public Collection<Identity> filterViewQueryOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        return this.opaHighLevelClient.parallelFilterFromOpa(queryOwners, queryOwner -> OpaHighLevelClient.buildQueryInputForSimpleResource(this.buildQueryContext(identity), "FilterViewQueryOwnedBy", OpaQueryInputResource.builder().user(new TrinoUser((Identity)queryOwner)).build()));
    }

    public void checkCanKillQueryOwnedBy(Identity identity, Identity queryOwner) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(identity), "KillQueryOwnedBy", AccessDeniedException::denyKillQuery, OpaQueryInputResource.builder().user(new TrinoUser(queryOwner)).build());
    }

    public void checkCanReadSystemInformation(Identity identity) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(identity), "ReadSystemInformation", AccessDeniedException::denyReadSystemInformationAccess);
    }

    public void checkCanWriteSystemInformation(Identity identity) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(identity), "WriteSystemInformation", AccessDeniedException::denyWriteSystemInformationAccess);
    }

    public void checkCanSetSystemSessionProperty(Identity identity, QueryId queryId, String propertyName) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(identity), "SetSystemSessionProperty", () -> AccessDeniedException.denySetSystemSessionProperty((String)propertyName), OpaQueryInputResource.builder().systemSessionProperty(propertyName).build());
    }

    public boolean canAccessCatalog(SystemSecurityContext context, String catalogName) {
        return this.opaHighLevelClient.queryOpaWithSimpleResource(this.buildQueryContext(context), "AccessCatalog", OpaQueryInputResource.builder().catalog(catalogName).build());
    }

    public void checkCanCreateCatalog(SystemSecurityContext context, String catalog) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), "CreateCatalog", () -> AccessDeniedException.denyCreateCatalog((String)catalog), OpaQueryInputResource.builder().catalog(catalog).build());
    }

    public void checkCanDropCatalog(SystemSecurityContext context, String catalog) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), "DropCatalog", () -> AccessDeniedException.denyDropCatalog((String)catalog), OpaQueryInputResource.builder().catalog(catalog).build());
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        return this.opaHighLevelClient.parallelFilterFromOpa(catalogs, catalog -> OpaHighLevelClient.buildQueryInputForSimpleResource(this.buildQueryContext(context), "FilterCatalogs", OpaQueryInputResource.builder().catalog((String)catalog).build()));
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema, Map<String, Object> properties) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), "CreateSchema", () -> AccessDeniedException.denyCreateSchema((String)schema.toString()), OpaQueryInputResource.builder().schema(new TrinoSchema(schema).withProperties(OpaAccessControl.convertProperties(properties))).build());
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), "DropSchema", () -> AccessDeniedException.denyDropSchema((String)schema.toString()), OpaQueryInputResource.builder().schema(new TrinoSchema(schema)).build());
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        OpaQueryInputResource resource = OpaQueryInputResource.builder().schema(new TrinoSchema(schema)).build();
        OpaQueryInputResource targetResource = OpaQueryInputResource.builder().schema(new TrinoSchema(schema.getCatalogName(), newSchemaName)).build();
        OpaQueryContext queryContext = this.buildQueryContext(context);
        if (!this.opaHighLevelClient.queryOpaWithSourceAndTargetResource(queryContext, "RenameSchema", resource, targetResource)) {
            AccessDeniedException.denyRenameSchema((String)schema.toString(), (String)newSchemaName);
        }
    }

    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, TrinoPrincipal principal) {
        OpaQueryInputResource resource = OpaQueryInputResource.builder().schema(new TrinoSchema(schema)).build();
        OpaQueryInputAction action = OpaQueryInputAction.builder().operation("SetSchemaAuthorization").resource(resource).grantee(TrinoGrantPrincipal.fromTrinoPrincipal(principal)).build();
        OpaQueryInput input = new OpaQueryInput(this.buildQueryContext(context), action);
        if (!this.opaHighLevelClient.queryOpa(input)) {
            AccessDeniedException.denySetSchemaAuthorization((String)schema.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), "ShowSchemas", AccessDeniedException::denyShowSchemas, OpaQueryInputResource.builder().catalog(catalogName).build());
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return this.opaHighLevelClient.parallelFilterFromOpa(schemaNames, schema -> OpaHighLevelClient.buildQueryInputForSimpleResource(this.buildQueryContext(context), "FilterSchemas", OpaQueryInputResource.builder().schema(new TrinoSchema(catalogName, (String)schema)).build()));
    }

    public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schemaName) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), "ShowCreateSchema", () -> AccessDeniedException.denyShowCreateSchema((String)schemaName.toString()), OpaQueryInputResource.builder().schema(new TrinoSchema(schemaName)).build());
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "ShowCreateTable", table, AccessDeniedException::denyShowCreateTable);
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Object> properties) {
        this.checkTableAndPropertiesOperation(context, "CreateTable", table, OpaAccessControl.convertProperties(properties), AccessDeniedException::denyCreateTable);
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "DropTable", table, AccessDeniedException::denyDropTable);
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        OpaQueryInputResource oldResource = OpaQueryInputResource.builder().table(new TrinoTable(table)).build();
        OpaQueryInputResource newResource = OpaQueryInputResource.builder().table(new TrinoTable(newTable)).build();
        OpaQueryContext queryContext = this.buildQueryContext(context);
        if (!this.opaHighLevelClient.queryOpaWithSourceAndTargetResource(queryContext, "RenameTable", oldResource, newResource)) {
            AccessDeniedException.denyRenameTable((String)table.toString(), (String)newTable.toString());
        }
    }

    public void checkCanSetTableProperties(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Optional<Object>> properties) {
        this.checkTableAndPropertiesOperation(context, "SetTableProperties", table, properties, AccessDeniedException::denySetTableProperties);
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "SetTableComment", table, AccessDeniedException::denyCommentTable);
    }

    public void checkCanSetViewComment(SystemSecurityContext context, CatalogSchemaTableName view) {
        this.checkTableOperation(context, "SetViewComment", view, AccessDeniedException::denyCommentView);
    }

    public void checkCanSetColumnComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "SetColumnComment", table, AccessDeniedException::denyCommentColumn);
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), "ShowTables", () -> AccessDeniedException.denyShowTables((String)schema.toString()), OpaQueryInputResource.builder().schema(new TrinoSchema(schema)).build());
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return this.opaHighLevelClient.parallelFilterFromOpa(tableNames, table -> OpaHighLevelClient.buildQueryInputForSimpleResource(this.buildQueryContext(context), "FilterTables", OpaQueryInputResource.builder().table(new TrinoTable(catalogName, table.getSchemaName(), table.getTableName())).build()));
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "ShowColumns", table, AccessDeniedException::denyShowColumns);
    }

    public Map<SchemaTableName, Set<String>> filterColumns(SystemSecurityContext context, String catalogName, Map<SchemaTableName, Set<String>> tableColumns) {
        ImmutableSet.Builder allColumnsBuilder = ImmutableSet.builder();
        for (Map.Entry<SchemaTableName, Set<String>> entry : tableColumns.entrySet()) {
            SchemaTableName schemaTableName = entry.getKey();
            TrinoTable trinoTable = new TrinoTable(catalogName, schemaTableName.getSchemaName(), schemaTableName.getTableName());
            for (String columnName : entry.getValue()) {
                allColumnsBuilder.add((Object)trinoTable.withColumns((Set<String>)ImmutableSet.of((Object)columnName)));
            }
        }
        Set<TrinoTable> filteredColumns = this.opaHighLevelClient.parallelFilterFromOpa(allColumnsBuilder.build(), tableColumn -> OpaHighLevelClient.buildQueryInputForSimpleResource(this.buildQueryContext(context), "FilterColumns", OpaQueryInputResource.builder().table((TrinoTable)tableColumn).build()));
        ImmutableSetMultimap.Builder results = ImmutableSetMultimap.builder();
        for (TrinoTable tableColumn2 : filteredColumns) {
            results.put((Object)new SchemaTableName(tableColumn2.schemaName(), tableColumn2.tableName()), (Object)((String)Iterables.getOnlyElement(tableColumn2.columns())));
        }
        return Multimaps.asMap((SetMultimap)results.build());
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "AddColumn", table, AccessDeniedException::denyAddColumn);
    }

    public void checkCanAlterColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "AlterColumn", table, AccessDeniedException::denyAlterColumn);
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "DropColumn", table, AccessDeniedException::denyDropColumn);
    }

    public void checkCanSetTableAuthorization(SystemSecurityContext context, CatalogSchemaTableName table, TrinoPrincipal principal) {
        OpaQueryInputResource resource = OpaQueryInputResource.builder().table(new TrinoTable(table)).build();
        OpaQueryInputAction action = OpaQueryInputAction.builder().operation("SetTableAuthorization").resource(resource).grantee(TrinoGrantPrincipal.fromTrinoPrincipal(principal)).build();
        OpaQueryInput input = new OpaQueryInput(this.buildQueryContext(context), action);
        if (!this.opaHighLevelClient.queryOpa(input)) {
            AccessDeniedException.denySetTableAuthorization((String)table.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "RenameColumn", table, AccessDeniedException::denyRenameColumn);
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.checkTableAndColumnsOperation(context, "SelectFromColumns", table, columns, AccessDeniedException::denySelectColumns);
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "InsertIntoTable", table, AccessDeniedException::denyInsertTable);
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "DeleteFromTable", table, AccessDeniedException::denyDeleteTable);
    }

    public void checkCanTruncateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        this.checkTableOperation(context, "TruncateTable", table, AccessDeniedException::denyTruncateTable);
    }

    public void checkCanUpdateTableColumns(SystemSecurityContext securityContext, CatalogSchemaTableName table, Set<String> updatedColumnNames) {
        this.checkTableAndColumnsOperation(securityContext, "UpdateTableColumns", table, updatedColumnNames, AccessDeniedException::denyUpdateTableColumns);
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        this.checkTableOperation(context, "CreateView", view, AccessDeniedException::denyCreateView);
    }

    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        OpaQueryInputResource oldResource = OpaQueryInputResource.builder().table(new TrinoTable(view)).build();
        OpaQueryInputResource newResource = OpaQueryInputResource.builder().table(new TrinoTable(newView)).build();
        OpaQueryContext queryContext = this.buildQueryContext(context);
        if (!this.opaHighLevelClient.queryOpaWithSourceAndTargetResource(queryContext, "RenameView", oldResource, newResource)) {
            AccessDeniedException.denyRenameView((String)view.toString(), (String)newView.toString());
        }
    }

    public void checkCanSetViewAuthorization(SystemSecurityContext context, CatalogSchemaTableName view, TrinoPrincipal principal) {
        OpaQueryInputResource resource = OpaQueryInputResource.builder().table(new TrinoTable(view)).build();
        OpaQueryInputAction action = OpaQueryInputAction.builder().operation("SetViewAuthorization").resource(resource).grantee(TrinoGrantPrincipal.fromTrinoPrincipal(principal)).build();
        OpaQueryInput input = new OpaQueryInput(this.buildQueryContext(context), action);
        if (!this.opaHighLevelClient.queryOpa(input)) {
            AccessDeniedException.denySetViewAuthorization((String)view.toString(), (TrinoPrincipal)principal);
        }
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        this.checkTableOperation(context, "DropView", view, AccessDeniedException::denyDropView);
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        this.checkTableAndColumnsOperation(context, "CreateViewWithSelectFromColumns", table, columns, (tableAsString, columnSet) -> AccessDeniedException.denyCreateViewWithSelect((String)tableAsString, (Identity)context.getIdentity()));
    }

    public void checkCanCreateMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Object> properties) {
        this.checkTableAndPropertiesOperation(context, "CreateMaterializedView", materializedView, OpaAccessControl.convertProperties(properties), AccessDeniedException::denyCreateMaterializedView);
    }

    public void checkCanRefreshMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        this.checkTableOperation(context, "RefreshMaterializedView", materializedView, AccessDeniedException::denyRefreshMaterializedView);
    }

    public void checkCanSetMaterializedViewProperties(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Optional<Object>> properties) {
        this.checkTableAndPropertiesOperation(context, "SetMaterializedViewProperties", materializedView, properties, AccessDeniedException::denySetMaterializedViewProperties);
    }

    public void checkCanDropMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView) {
        this.checkTableOperation(context, "DropMaterializedView", materializedView, AccessDeniedException::denyDropMaterializedView);
    }

    public void checkCanRenameMaterializedView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        OpaQueryInputResource oldResource = OpaQueryInputResource.builder().table(new TrinoTable(view)).build();
        OpaQueryInputResource newResource = OpaQueryInputResource.builder().table(new TrinoTable(newView)).build();
        OpaQueryContext queryContext = this.buildQueryContext(context);
        if (!this.opaHighLevelClient.queryOpaWithSourceAndTargetResource(queryContext, "RenameMaterializedView", oldResource, newResource)) {
            AccessDeniedException.denyRenameMaterializedView((String)view.toString(), (String)newView.toString());
        }
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), "SetCatalogSessionProperty", () -> AccessDeniedException.denySetCatalogSessionProperty((String)propertyName), OpaQueryInputResource.builder().catalogSessionProperty(new TrinoCatalogSessionProperty(catalogName, propertyName)).build());
    }

    public void checkCanGrantSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee, boolean grantOption) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyGrantSchemaPrivilege, privilege.toString(), schema.toString());
    }

    public void checkCanDenySchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal grantee) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyDenySchemaPrivilege, privilege.toString(), schema.toString());
    }

    public void checkCanRevokeSchemaPrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaName schema, TrinoPrincipal revokee, boolean grantOption) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyRevokeSchemaPrivilege, privilege.toString(), schema.toString());
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee, boolean grantOption) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyGrantTablePrivilege, privilege.toString(), table.toString());
    }

    public void checkCanDenyTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal grantee) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyDenyTablePrivilege, privilege.toString(), table.toString());
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, TrinoPrincipal revokee, boolean grantOption) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyRevokeTablePrivilege, privilege.toString(), table.toString());
    }

    public void checkCanCreateRole(SystemSecurityContext context, String role, Optional<TrinoPrincipal> grantor) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyCreateRole, role);
    }

    public void checkCanDropRole(SystemSecurityContext context, String role) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyDropRole, role);
    }

    public void checkCanGrantRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyGrantRoles, roles, grantees);
    }

    public void checkCanRevokeRoles(SystemSecurityContext context, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.enforcePermissionManagementOperation(AccessDeniedException::denyRevokeRoles, roles, grantees);
    }

    public void checkCanShowRoles(SystemSecurityContext context) {
    }

    public void checkCanShowCurrentRoles(SystemSecurityContext context) {
    }

    public void checkCanShowRoleGrants(SystemSecurityContext context) {
    }

    public void checkCanShowFunctions(SystemSecurityContext context, CatalogSchemaName schema) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), "ShowFunctions", () -> AccessDeniedException.denyShowFunctions((String)schema.toString()), OpaQueryInputResource.builder().schema(new TrinoSchema(schema)).build());
    }

    public Set<SchemaFunctionName> filterFunctions(SystemSecurityContext context, String catalogName, Set<SchemaFunctionName> functionNames) {
        return this.opaHighLevelClient.parallelFilterFromOpa(functionNames, function -> OpaHighLevelClient.buildQueryInputForSimpleResource(this.buildQueryContext(context), "FilterFunctions", OpaQueryInputResource.builder().function(new TrinoFunction(new TrinoSchema(catalogName, function.getSchemaName()), function.getFunctionName())).build()));
    }

    public void checkCanExecuteProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName procedure) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(systemSecurityContext), "ExecuteProcedure", () -> AccessDeniedException.denyExecuteProcedure((String)procedure.toString()), OpaQueryInputResource.builder().function(TrinoFunction.fromTrinoFunction(procedure)).build());
    }

    public boolean canExecuteFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        return this.opaHighLevelClient.queryOpaWithSimpleResource(this.buildQueryContext(systemSecurityContext), "ExecuteFunction", OpaQueryInputResource.builder().function(TrinoFunction.fromTrinoFunction(functionName)).build());
    }

    public boolean canCreateViewWithExecuteFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        return this.opaHighLevelClient.queryOpaWithSimpleResource(this.buildQueryContext(systemSecurityContext), "CreateViewWithExecuteFunction", OpaQueryInputResource.builder().function(TrinoFunction.fromTrinoFunction(functionName)).build());
    }

    public void checkCanExecuteTableProcedure(SystemSecurityContext systemSecurityContext, CatalogSchemaTableName table, String procedure) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(systemSecurityContext), "ExecuteTableProcedure", () -> AccessDeniedException.denyExecuteTableProcedure((String)table.toString(), (String)procedure), OpaQueryInputResource.builder().table(new TrinoTable(table)).function(procedure).build());
    }

    public void checkCanCreateFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(systemSecurityContext), "CreateFunction", () -> AccessDeniedException.denyCreateFunction((String)functionName.toString()), OpaQueryInputResource.builder().function(TrinoFunction.fromTrinoFunction(functionName)).build());
    }

    public void checkCanDropFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(systemSecurityContext), "DropFunction", () -> AccessDeniedException.denyDropFunction((String)functionName.toString()), OpaQueryInputResource.builder().function(TrinoFunction.fromTrinoFunction(functionName)).build());
    }

    public void checkCanShowCreateFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(systemSecurityContext), "ShowCreateFunction", () -> AccessDeniedException.denyShowFunctions((String)functionName.toString()), OpaQueryInputResource.builder().function(TrinoFunction.fromTrinoFunction(functionName)).build());
    }

    public List<ViewExpression> getRowFilters(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        List<OpaViewExpression> rowFilterExpressions = this.opaHighLevelClient.getRowFilterExpressionsFromOpa(this.buildQueryContext(context), tableName);
        return (List)rowFilterExpressions.stream().map(expression -> expression.toTrinoViewExpression(tableName.getCatalogName(), tableName.getSchemaTableName().getSchemaName())).collect(ImmutableList.toImmutableList());
    }

    public Map<ColumnSchema, ViewExpression> getColumnMasks(SystemSecurityContext context, CatalogSchemaTableName tableName, List<ColumnSchema> columns) {
        return (Map)this.opaHighLevelClient.getColumnMasksFromOpa(this.buildQueryContext(context), tableName, columns).entrySet().stream().map(entry -> Map.entry((ColumnSchema)entry.getKey(), ((OpaViewExpression)entry.getValue()).toTrinoViewExpression(tableName.getCatalogName(), tableName.getSchemaTableName().getSchemaName()))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void shutdown() {
        this.lifeCycleManager.stop();
    }

    private void checkTableOperation(SystemSecurityContext context, String actionName, CatalogSchemaTableName table, Consumer<String> deny) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), actionName, () -> deny.accept(table.toString()), OpaQueryInputResource.builder().table(new TrinoTable(table)).build());
    }

    private void checkTableAndPropertiesOperation(SystemSecurityContext context, String actionName, CatalogSchemaTableName table, Map<String, Optional<Object>> properties, Consumer<String> deny) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), actionName, () -> deny.accept(table.toString()), OpaQueryInputResource.builder().table(new TrinoTable(table).withProperties(properties)).build());
    }

    private void checkTableAndColumnsOperation(SystemSecurityContext context, String actionName, CatalogSchemaTableName table, Set<String> columns, BiConsumer<String, Set<String>> deny) {
        this.opaHighLevelClient.queryAndEnforce(this.buildQueryContext(context), actionName, () -> deny.accept(table.toString(), columns), OpaQueryInputResource.builder().table(new TrinoTable(table).withColumns(columns)).build());
    }

    private <T> void enforcePermissionManagementOperation(Consumer<T> deny, T arg) {
        if (!this.allowPermissionManagementOperations) {
            deny.accept(arg);
        }
    }

    private <T, U> void enforcePermissionManagementOperation(BiConsumer<T, U> deny, T arg1, U arg2) {
        if (!this.allowPermissionManagementOperations) {
            deny.accept(arg1, arg2);
        }
    }

    private static Map<String, Optional<Object>> convertProperties(Map<String, Object> properties) {
        return (Map)properties.entrySet().stream().map(propertiesEntry -> Map.entry((String)propertiesEntry.getKey(), Optional.ofNullable(propertiesEntry.getValue()))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    OpaQueryContext buildQueryContext(Identity trinoIdentity) {
        return new OpaQueryContext(TrinoIdentity.fromTrinoIdentity(trinoIdentity), this.pluginContext);
    }

    OpaQueryContext buildQueryContext(SystemSecurityContext securityContext) {
        return new OpaQueryContext(TrinoIdentity.fromTrinoIdentity(securityContext.getIdentity()), this.pluginContext);
    }
}

