/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.json.JsonCodec;
import io.trino.plugin.opa.OpaAccessControl;
import io.trino.plugin.opa.OpaConfig;
import io.trino.plugin.opa.OpaHighLevelClient;
import io.trino.plugin.opa.OpaHttpClient;
import io.trino.plugin.opa.schema.OpaBatchQueryResult;
import io.trino.plugin.opa.schema.OpaPluginContext;
import io.trino.plugin.opa.schema.OpaQueryContext;
import io.trino.plugin.opa.schema.OpaQueryInput;
import io.trino.plugin.opa.schema.OpaQueryInputAction;
import io.trino.plugin.opa.schema.OpaQueryInputResource;
import io.trino.plugin.opa.schema.TrinoFunction;
import io.trino.plugin.opa.schema.TrinoSchema;
import io.trino.plugin.opa.schema.TrinoTable;
import io.trino.plugin.opa.schema.TrinoUser;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SystemSecurityContext;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class OpaBatchAccessControl
extends OpaAccessControl {
    private final JsonCodec<OpaBatchQueryResult> batchResultCodec;
    private final URI opaBatchedPolicyUri;
    private final OpaHttpClient opaHttpClient;

    @Inject
    public OpaBatchAccessControl(LifeCycleManager lifeCycleManager, OpaHighLevelClient opaHighLevelClient, JsonCodec<OpaBatchQueryResult> batchResultCodec, OpaHttpClient opaHttpClient, OpaConfig config, OpaPluginContext pluginContext) {
        super(lifeCycleManager, opaHighLevelClient, config, pluginContext);
        this.opaBatchedPolicyUri = config.getOpaBatchUri().orElseThrow();
        this.batchResultCodec = Objects.requireNonNull(batchResultCodec, "batchResultCodec is null");
        this.opaHttpClient = Objects.requireNonNull(opaHttpClient, "opaHttpClient is null");
    }

    @Override
    public Collection<Identity> filterViewQueryOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        return this.batchFilterFromOpa(this.buildQueryContext(identity), "FilterViewQueryOwnedBy", queryOwners, queryOwner -> OpaQueryInputResource.builder().user(new TrinoUser((Identity)queryOwner)).build());
    }

    @Override
    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        return this.batchFilterFromOpa(this.buildQueryContext(context), "FilterCatalogs", catalogs, catalog -> OpaQueryInputResource.builder().catalog((String)catalog).build());
    }

    @Override
    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return this.batchFilterFromOpa(this.buildQueryContext(context), "FilterSchemas", schemaNames, schema -> OpaQueryInputResource.builder().schema(new TrinoSchema(catalogName, (String)schema)).build());
    }

    @Override
    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return this.batchFilterFromOpa(this.buildQueryContext(context), "FilterTables", tableNames, table -> OpaQueryInputResource.builder().table(new TrinoTable(catalogName, table.getSchemaName(), table.getTableName())).build());
    }

    @Override
    public Map<SchemaTableName, Set<String>> filterColumns(SystemSecurityContext context, String catalogName, Map<SchemaTableName, Set<String>> tableColumns) {
        BiFunction requestBuilder = OpaBatchAccessControl.batchRequestBuilder(this.buildQueryContext(context), "FilterColumns", (K schemaTableName, List<V> columns) -> OpaQueryInputResource.builder().table(new TrinoTable(catalogName, schemaTableName.getSchemaName(), schemaTableName.getTableName()).withColumns((Set<String>)ImmutableSet.copyOf((Collection)columns))).build());
        return this.opaHttpClient.parallelBatchFilterFromOpa(tableColumns, requestBuilder, this.opaBatchedPolicyUri, this.batchResultCodec);
    }

    @Override
    public Set<SchemaFunctionName> filterFunctions(SystemSecurityContext context, String catalogName, Set<SchemaFunctionName> functionNames) {
        return this.batchFilterFromOpa(this.buildQueryContext(context), "FilterFunctions", functionNames, function -> OpaQueryInputResource.builder().function(new TrinoFunction(new TrinoSchema(catalogName, function.getSchemaName()), function.getFunctionName())).build());
    }

    private <T> Set<T> batchFilterFromOpa(OpaQueryContext context, String operation, Collection<T> items, Function<T, OpaQueryInputResource> converter) {
        return this.opaHttpClient.batchFilterFromOpa(items, OpaBatchAccessControl.batchRequestBuilder(context, operation, converter), this.opaBatchedPolicyUri, this.batchResultCodec);
    }

    private static <V> Function<List<V>, OpaQueryInput> batchRequestBuilder(OpaQueryContext context, String operation, Function<V, OpaQueryInputResource> resourceMapper) {
        return items -> new OpaQueryInput(context, OpaQueryInputAction.builder().operation(operation).filterResources((Collection)items.stream().map(resourceMapper).collect(ImmutableList.toImmutableList())).build());
    }

    private static <K, V> BiFunction<K, List<V>, OpaQueryInput> batchRequestBuilder(OpaQueryContext context, String operation, BiFunction<K, List<V>, OpaQueryInputResource> resourceMapper) {
        return (resourcesKey, resourcesList) -> new OpaQueryInput(context, OpaQueryInputAction.builder().operation(operation).filterResources((Collection<OpaQueryInputResource>)ImmutableList.of((Object)((OpaQueryInputResource)resourceMapper.apply((Object)resourcesKey, (List)resourcesList)))).build());
    }
}

