/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.trino.plugin.opa.OpaConfig;
import io.trino.plugin.opa.OpaHttpClient;
import io.trino.plugin.opa.schema.OpaBatchColumnMaskQueryResult;
import io.trino.plugin.opa.schema.OpaColumnMaskQueryResult;
import io.trino.plugin.opa.schema.OpaQueryContext;
import io.trino.plugin.opa.schema.OpaQueryInput;
import io.trino.plugin.opa.schema.OpaQueryInputAction;
import io.trino.plugin.opa.schema.OpaQueryInputResource;
import io.trino.plugin.opa.schema.OpaQueryResult;
import io.trino.plugin.opa.schema.OpaRowFiltersQueryResult;
import io.trino.plugin.opa.schema.OpaViewExpression;
import io.trino.plugin.opa.schema.TrinoColumn;
import io.trino.plugin.opa.schema.TrinoTable;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.security.AccessDeniedException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class OpaHighLevelClient {
    private final JsonCodec<OpaQueryResult> queryResultCodec;
    private final JsonCodec<OpaRowFiltersQueryResult> rowFiltersQueryResultCodec;
    private final JsonCodec<OpaColumnMaskQueryResult> columnMaskQueryResultCodec;
    private final JsonCodec<OpaBatchColumnMaskQueryResult> batchColumnMaskQueryResultCodec;
    private final OpaHttpClient opaHttpClient;
    private final URI opaPolicyUri;
    private final Optional<URI> opaRowFiltersUri;
    private final Optional<URI> opaColumnMaskingUri;
    private final Optional<URI> opaBatchColumnMaskingUri;

    @Inject
    public OpaHighLevelClient(JsonCodec<OpaQueryResult> queryResultCodec, JsonCodec<OpaRowFiltersQueryResult> rowFiltersQueryResultCodec, JsonCodec<OpaColumnMaskQueryResult> columnMaskQueryResultCodec, JsonCodec<OpaBatchColumnMaskQueryResult> batchColumnMaskQueryResultCodec, OpaHttpClient opaHttpClient, OpaConfig config) {
        this.queryResultCodec = Objects.requireNonNull(queryResultCodec, "queryResultCodec is null");
        this.rowFiltersQueryResultCodec = Objects.requireNonNull(rowFiltersQueryResultCodec, "rowFiltersQueryResultCodec is null");
        this.columnMaskQueryResultCodec = Objects.requireNonNull(columnMaskQueryResultCodec, "columnMaskQueryResultCodec is null");
        this.batchColumnMaskQueryResultCodec = Objects.requireNonNull(batchColumnMaskQueryResultCodec, "batchColumnMaskQueryResultCodec is null");
        this.opaHttpClient = Objects.requireNonNull(opaHttpClient, "opaHttpClient is null");
        this.opaPolicyUri = config.getOpaUri();
        this.opaRowFiltersUri = config.getOpaRowFiltersUri();
        this.opaColumnMaskingUri = config.getOpaColumnMaskingUri();
        this.opaBatchColumnMaskingUri = config.getOpaBatchColumnMaskingUri();
    }

    public boolean queryOpa(OpaQueryInput input) {
        return this.opaHttpClient.consumeOpaResponse(this.opaHttpClient.submitOpaRequest(input, this.opaPolicyUri, this.queryResultCodec)).result();
    }

    private boolean queryOpaWithSimpleAction(OpaQueryContext context, String operation) {
        return this.queryOpa(OpaHighLevelClient.buildQueryInputForSimpleAction(context, operation));
    }

    public boolean queryOpaWithSimpleResource(OpaQueryContext context, String operation, OpaQueryInputResource resource) {
        return this.queryOpa(OpaHighLevelClient.buildQueryInputForSimpleResource(context, operation, resource));
    }

    public boolean queryOpaWithSourceAndTargetResource(OpaQueryContext context, String operation, OpaQueryInputResource resource, OpaQueryInputResource targetResource) {
        return this.queryOpa(new OpaQueryInput(context, OpaQueryInputAction.builder().operation(operation).resource(resource).targetResource(targetResource).build()));
    }

    public void queryAndEnforce(OpaQueryContext context, String actionName, Runnable deny, OpaQueryInputResource resource) {
        if (!this.queryOpaWithSimpleResource(context, actionName, resource)) {
            deny.run();
            throw new AccessDeniedException("Access denied for action %s and resource %s".formatted(actionName, resource));
        }
    }

    public void queryAndEnforce(OpaQueryContext context, String actionName, Runnable deny) {
        if (!this.queryOpaWithSimpleAction(context, actionName)) {
            deny.run();
            throw new AccessDeniedException("Access denied for action %s".formatted(actionName));
        }
    }

    public <T> Set<T> parallelFilterFromOpa(Collection<T> items, Function<T, OpaQueryInput> requestBuilder) {
        return this.opaHttpClient.parallelFilterFromOpa(items, requestBuilder, this.opaPolicyUri, this.queryResultCodec);
    }

    public List<OpaViewExpression> getRowFilterExpressionsFromOpa(OpaQueryContext context, CatalogSchemaTableName table) {
        OpaQueryInput queryInput = new OpaQueryInput(context, OpaQueryInputAction.builder().operation("GetRowFilters").resource(OpaQueryInputResource.builder().table(new TrinoTable(table)).build()).build());
        return this.opaRowFiltersUri.map(uri -> this.opaHttpClient.consumeOpaResponse(this.opaHttpClient.submitOpaRequest(queryInput, (URI)uri, this.rowFiltersQueryResultCodec)).result()).orElse((List)ImmutableList.of());
    }

    public Map<ColumnSchema, OpaViewExpression> getColumnMasksFromOpa(OpaQueryContext context, CatalogSchemaTableName table, List<ColumnSchema> columns) {
        return this.opaBatchColumnMaskingUri.map(batchUri -> this.getBatchColumnMasksFromOpa((URI)batchUri, context, table, columns)).or(() -> this.opaColumnMaskingUri.map(maskUri -> this.getParallelColumnMasksFromOpa((URI)maskUri, context, table, columns))).orElse((Map)ImmutableMap.of());
    }

    public static OpaQueryInput buildQueryInputForSimpleResource(OpaQueryContext context, String operation, OpaQueryInputResource resource) {
        return new OpaQueryInput(context, OpaQueryInputAction.builder().operation(operation).resource(resource).build());
    }

    private Map<ColumnSchema, OpaViewExpression> getBatchColumnMasksFromOpa(URI uri, OpaQueryContext context, CatalogSchemaTableName table, List<ColumnSchema> columns) {
        OpaQueryInput input = new OpaQueryInput(context, OpaQueryInputAction.builder().operation("GetColumnMask").filterResources((Collection)columns.stream().map(column -> OpaQueryInputResource.builder().column(new TrinoColumn(table, column.getName(), column.getType())).build()).collect(ImmutableList.toImmutableList())).build());
        OpaBatchColumnMaskQueryResult result = this.opaHttpClient.consumeOpaResponse(this.opaHttpClient.submitOpaRequest(input, uri, this.batchColumnMaskQueryResultCodec));
        return (Map)result.result().stream().collect(ImmutableMap.toImmutableMap(item -> (ColumnSchema)columns.get(item.index()), OpaBatchColumnMaskQueryResult.OpaBatchColumnMaskQueryResultItem::viewExpression));
    }

    private Map<ColumnSchema, OpaViewExpression> getParallelColumnMasksFromOpa(URI uri, OpaQueryContext context, CatalogSchemaTableName table, List<ColumnSchema> columns) {
        return this.opaHttpClient.parallelColumnMasksFromOpa(columns, column -> new OpaQueryInput(context, OpaQueryInputAction.builder().operation("GetColumnMask").resource(OpaQueryInputResource.builder().column(new TrinoColumn(table, column.getName(), column.getType())).build()).build()), uri, this.columnMaskQueryResultCodec);
    }

    private static OpaQueryInput buildQueryInputForSimpleAction(OpaQueryContext context, String operation) {
        return new OpaQueryInput(context, OpaQueryInputAction.builder().operation(operation).build());
    }
}

