/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa.schema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.connector.CatalogSchemaName;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record TrinoSchema(String catalogName, String schemaName, Map<String, Optional<Object>> properties) {
    public TrinoSchema {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        if (properties != null) {
            properties = ImmutableMap.copyOf(properties);
        }
    }

    public TrinoSchema(CatalogSchemaName schema) {
        this(schema.getCatalogName(), schema.getSchemaName());
    }

    public TrinoSchema(String catalogName, String schemaName) {
        this(catalogName, schemaName, null);
    }

    public TrinoSchema withProperties(Map<String, Optional<Object>> newProperties) {
        return new TrinoSchema(this.catalogName, this.schemaName, newProperties);
    }
}

