/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opa.schema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.CatalogSchemaTableName;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public record TrinoTable(String catalogName, String schemaName, String tableName, Set<String> columns, Map<String, Optional<Object>> properties) {
    public TrinoTable {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        if (columns != null) {
            columns = ImmutableSet.copyOf(columns);
        }
        if (properties != null) {
            properties = ImmutableMap.copyOf(properties);
        }
    }

    public TrinoTable(CatalogSchemaTableName table) {
        this(table.getCatalogName(), table.getSchemaTableName().getSchemaName(), table.getSchemaTableName().getTableName());
    }

    public TrinoTable(String catalogName, String schemaName, String tableName) {
        this(catalogName, schemaName, tableName, null, null);
    }

    public TrinoTable withColumns(Set<String> newColumns) {
        return new TrinoTable(this.catalogName, this.schemaName, this.tableName, newColumns, this.properties);
    }

    public TrinoTable withProperties(Map<String, Optional<Object>> newProperties) {
        return new TrinoTable(this.catalogName, this.schemaName, this.tableName, this.columns, newProperties);
    }
}

