/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.auth;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.pinot.common.auth.AuthConfig;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.spi.auth.AuthProvider;

public class UrlAuthProvider
implements AuthProvider {
    public static final String HEADER = "header";
    public static final String PREFIX = "prefix";
    public static final String URL = "url";
    protected final String _header;
    protected final String _prefix;
    protected final URL _url;

    public UrlAuthProvider(String url) {
        try {
            this._header = "Authorization";
            this._prefix = "Bearer";
            this._url = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public UrlAuthProvider(AuthConfig authConfig) {
        try {
            this._header = AuthProviderUtils.getOrDefault(authConfig, HEADER, "Authorization");
            this._prefix = AuthProviderUtils.getOrDefault(authConfig, PREFIX, "Bearer");
            this._url = new URL(authConfig.getProperties().get(URL).toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Map<String, Object> getRequestHeaders() {
        return Collections.singletonMap(this._header, this.makeToken());
    }

    public String getTaskToken() {
        return this.makeToken();
    }

    private String makeToken() {
        try {
            String token = IOUtils.toString((URL)this._url, (Charset)StandardCharsets.UTF_8);
            if (token.startsWith(this._prefix)) {
                return token;
            }
            return this._prefix + " " + token;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not resolve auth url " + this._url, e);
        }
    }
}

