/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.pinot.common.datablock.BaseDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.DataBlockUtils;
import org.apache.pinot.common.utils.DataSchema;

public class ColumnarDataBlock
extends BaseDataBlock {
    private static final int VERSION = 2;
    protected int[] _cumulativeColumnOffsetSizeInBytes;
    protected int[] _columnSizeInBytes;

    public ColumnarDataBlock() {
    }

    public ColumnarDataBlock(int numRows, DataSchema dataSchema, String[] stringDictionary, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        super(numRows, dataSchema, stringDictionary, fixedSizeDataBytes, variableSizeDataBytes);
        this.computeBlockObjectConstants();
    }

    public ColumnarDataBlock(ByteBuffer byteBuffer) throws IOException {
        super(byteBuffer);
        this.computeBlockObjectConstants();
    }

    protected void computeBlockObjectConstants() {
        this._fixDataSize = 0;
        if (this._dataSchema != null) {
            this._cumulativeColumnOffsetSizeInBytes = new int[this._numColumns];
            this._columnSizeInBytes = new int[this._numColumns];
            DataBlockUtils.computeColumnSizeInBytes(this._dataSchema, this._columnSizeInBytes);
            int cumulativeColumnOffset = 0;
            for (int i = 0; i < this._numColumns; ++i) {
                this._cumulativeColumnOffsetSizeInBytes[i] = cumulativeColumnOffset;
                cumulativeColumnOffset += this._columnSizeInBytes[i] * this._numRows;
            }
            this._fixDataSize = cumulativeColumnOffset;
        }
    }

    @Override
    protected int getDataBlockVersionType() {
        return 2 + (DataBlock.Type.COLUMNAR.ordinal() << 5);
    }

    @Override
    protected int getOffsetInFixedBuffer(int rowId, int colId) {
        return this._cumulativeColumnOffsetSizeInBytes[colId] + this._columnSizeInBytes[colId] * rowId;
    }

    @Override
    protected int positionOffsetInVariableBufferAndGetLength(int rowId, int colId) {
        int offset = this.getOffsetInFixedBuffer(rowId, colId);
        this._variableSizeData.position(this._fixedSizeData.getInt(offset));
        return this._fixedSizeData.getInt(offset + 4);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnarDataBlock)) {
            return false;
        }
        ColumnarDataBlock that = (ColumnarDataBlock)o;
        return Objects.deepEquals(this._cumulativeColumnOffsetSizeInBytes, that._cumulativeColumnOffsetSizeInBytes) && Objects.deepEquals(this._columnSizeInBytes, that._columnSizeInBytes);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this._cumulativeColumnOffsetSizeInBytes), Arrays.hashCode(this._columnSizeInBytes));
    }
}

