/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datatable;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.CustomObject;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableUtils;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.spi.trace.Tracing;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.roaringbitmap.RoaringBitmap;

public abstract class BaseDataTable
implements DataTable {
    protected int _numRows;
    protected int _numColumns;
    protected DataSchema _dataSchema;
    protected int[] _columnOffsets;
    protected int _rowSizeInBytes;
    protected Map<String, Map<Integer, String>> _dictionaryMap;
    protected byte[] _fixedSizeDataBytes;
    protected ByteBuffer _fixedSizeData;
    protected byte[] _variableSizeDataBytes;
    protected ByteBuffer _variableSizeData;
    protected Map<String, String> _metadata;

    public BaseDataTable(int numRows, DataSchema dataSchema, Map<String, Map<Integer, String>> dictionaryMap, byte[] fixedSizeDataBytes, byte[] variableSizeDataBytes) {
        this._numRows = numRows;
        this._numColumns = dataSchema.size();
        this._dataSchema = dataSchema;
        this._columnOffsets = new int[this._numColumns];
        this._rowSizeInBytes = DataTableUtils.computeColumnOffsets(dataSchema, this._columnOffsets, this.getVersion());
        this._dictionaryMap = dictionaryMap;
        this._fixedSizeDataBytes = fixedSizeDataBytes;
        this._fixedSizeData = ByteBuffer.wrap(fixedSizeDataBytes);
        this._variableSizeDataBytes = variableSizeDataBytes;
        this._variableSizeData = ByteBuffer.wrap(variableSizeDataBytes);
        this._metadata = new HashMap<String, String>();
    }

    public BaseDataTable() {
        this._numRows = 0;
        this._numColumns = 0;
        this._dataSchema = null;
        this._columnOffsets = null;
        this._rowSizeInBytes = 0;
        this._dictionaryMap = null;
        this._fixedSizeDataBytes = null;
        this._fixedSizeData = null;
        this._variableSizeDataBytes = null;
        this._variableSizeData = null;
        this._metadata = new HashMap<String, String>();
    }

    protected byte[] serializeDictionaryMap() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeInt(this._dictionaryMap.size());
        int numEntriesAdded = 0;
        for (Map.Entry<String, Map<Integer, String>> dictionaryMapEntry : this._dictionaryMap.entrySet()) {
            Tracing.ThreadAccountantOps.sampleAndCheckInterruptionPeriodically((int)numEntriesAdded);
            String columnName = dictionaryMapEntry.getKey();
            Map<Integer, String> dictionary = dictionaryMapEntry.getValue();
            byte[] bytes = columnName.getBytes(StandardCharsets.UTF_8);
            dataOutputStream.writeInt(bytes.length);
            dataOutputStream.write(bytes);
            dataOutputStream.writeInt(dictionary.size());
            for (Map.Entry<Integer, String> dictionaryEntry : dictionary.entrySet()) {
                dataOutputStream.writeInt(dictionaryEntry.getKey());
                byte[] valueBytes = dictionaryEntry.getValue().getBytes(StandardCharsets.UTF_8);
                dataOutputStream.writeInt(valueBytes.length);
                dataOutputStream.write(valueBytes);
            }
            ++numEntriesAdded;
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected Map<String, Map<Integer, String>> deserializeDictionaryMap(ByteBuffer buffer) throws IOException {
        int numDictionaries = buffer.getInt();
        HashMap<String, Map<Integer, String>> dictionaryMap = new HashMap<String, Map<Integer, String>>(HashUtil.getHashMapCapacity(numDictionaries));
        for (int i = 0; i < numDictionaries; ++i) {
            String column = DataTableUtils.decodeString(buffer);
            int dictionarySize = buffer.getInt();
            HashMap<Integer, String> dictionary = new HashMap<Integer, String>(HashUtil.getHashMapCapacity(dictionarySize));
            for (int j = 0; j < dictionarySize; ++j) {
                int key = buffer.getInt();
                String value = DataTableUtils.decodeString(buffer);
                dictionary.put(key, value);
            }
            dictionaryMap.put(column, dictionary);
        }
        return dictionaryMap;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this._metadata;
    }

    @Override
    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    @Override
    public int getNumberOfRows() {
        return this._numRows;
    }

    @Override
    public int getInt(int rowId, int colId) {
        return this._fixedSizeData.getInt(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
    }

    @Override
    public long getLong(int rowId, int colId) {
        return this._fixedSizeData.getLong(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
    }

    @Override
    public float getFloat(int rowId, int colId) {
        return this._fixedSizeData.getFloat(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
    }

    @Override
    public double getDouble(int rowId, int colId) {
        return this._fixedSizeData.getDouble(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
    }

    @Override
    public BigDecimal getBigDecimal(int rowId, int colId) {
        int size = this.positionCursorInVariableBuffer(rowId, colId);
        ByteBuffer byteBuffer = this._variableSizeData.slice();
        byteBuffer.limit(size);
        return BigDecimalUtils.deserialize((ByteBuffer)byteBuffer);
    }

    @Override
    public String getString(int rowId, int colId) {
        int dictId = this._fixedSizeData.getInt(rowId * this._rowSizeInBytes + this._columnOffsets[colId]);
        return this._dictionaryMap.get(this._dataSchema.getColumnName(colId)).get(dictId);
    }

    @Override
    public ByteArray getBytes(int rowId, int colId) {
        return BytesUtils.toByteArray((String)this.getString(rowId, colId));
    }

    @Override
    public int[] getIntArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this._variableSizeData.getInt();
        }
        return ints;
    }

    @Override
    public long[] getLongArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this._variableSizeData.getLong();
        }
        return longs;
    }

    @Override
    public float[] getFloatArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this._variableSizeData.getFloat();
        }
        return floats;
    }

    @Override
    public double[] getDoubleArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this._variableSizeData.getDouble();
        }
        return doubles;
    }

    @Override
    public String[] getStringArray(int rowId, int colId) {
        int length = this.positionCursorInVariableBuffer(rowId, colId);
        String[] strings = new String[length];
        Map<Integer, String> dictionary = this._dictionaryMap.get(this._dataSchema.getColumnName(colId));
        for (int i = 0; i < length; ++i) {
            strings[i] = dictionary.get(this._variableSizeData.getInt());
        }
        return strings;
    }

    @Override
    @Nullable
    public CustomObject getCustomObject(int rowId, int colId) {
        int size = this.positionCursorInVariableBuffer(rowId, colId);
        int type = this._variableSizeData.getInt();
        if (size == 0) {
            assert (type == 100);
            return null;
        }
        ByteBuffer buffer = this._variableSizeData.slice();
        buffer.limit(size);
        return new CustomObject(type, buffer);
    }

    @Override
    @Nullable
    public RoaringBitmap getNullRowIds(int colId) {
        return null;
    }

    private int positionCursorInVariableBuffer(int rowId, int colId) {
        int offset = rowId * this._rowSizeInBytes + this._columnOffsets[colId];
        this._variableSizeData.position(this._fixedSizeData.getInt(offset));
        return this._fixedSizeData.getInt(offset + 4);
    }

    public String toString() {
        if (this._dataSchema == null) {
            return this._metadata.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("resultSchema:").append('\n');
        stringBuilder.append(this._dataSchema).append('\n');
        stringBuilder.append("numRows: ").append(this._numRows).append('\n');
        stringBuilder.append("metadata: ").append(this._metadata.toString()).append('\n');
        return stringBuilder.toString();
    }
}

