/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datatable;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.pinot.common.utils.DataSchema;

public class DataTableUtils {
    private DataTableUtils() {
    }

    public static int computeColumnOffsets(DataSchema dataSchema, int[] columnOffsets, int dataTableVersion) {
        int numColumns = columnOffsets.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int rowSizeInBytes = 0;
        block7: for (int i = 0; i < numColumns; ++i) {
            columnOffsets[i] = rowSizeInBytes;
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case LONG: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case FLOAT: {
                    if (dataTableVersion >= 4) {
                        rowSizeInBytes += 4;
                        continue block7;
                    }
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case DOUBLE: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case STRING: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                default: {
                    rowSizeInBytes += 8;
                }
            }
        }
        return rowSizeInBytes;
    }

    public static String decodeString(ByteBuffer buffer) throws IOException {
        int length = buffer.getInt();
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

