/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datatable;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.pinot.spi.utils.JsonUtils;

public class StatMap<K extends Enum<K>> {
    private final Class<K> _keyClass;
    private final Map<K, Object> _map;
    private static final ConcurrentHashMap<Class<?>, Object[]> KEYS_BY_CLASS = new ConcurrentHashMap();

    public StatMap(Class<K> keyClass) {
        this._keyClass = keyClass;
        this._map = Collections.synchronizedMap(new EnumMap(keyClass));
    }

    public int getInt(K key) {
        Preconditions.checkArgument((((Key)key).getType() == Type.INT ? 1 : 0) != 0, (String)"Key %s is of type %s, not INT", key, (Object)((Object)((Key)key).getType()));
        Object o = this._map.get(key);
        return o == null ? 0 : (Integer)o;
    }

    public StatMap<K> merge(K key, int value) {
        if (((Key)key).getType() == Type.LONG) {
            this.merge(key, (long)value);
            return this;
        }
        int oldValue = this.getInt(key);
        int newValue = ((Key)key).merge(oldValue, value);
        if (newValue == 0) {
            this._map.remove(key);
        } else {
            this._map.put(key, newValue);
        }
        return this;
    }

    public long getLong(K key) {
        if (((Key)key).getType() == Type.INT) {
            return this.getInt(key);
        }
        Preconditions.checkArgument((((Key)key).getType() == Type.LONG ? 1 : 0) != 0, (String)"Key %s is of type %s, not LONG", key, (Object)((Object)((Key)key).getType()));
        Object o = this._map.get(key);
        return o == null ? 0L : (Long)o;
    }

    public StatMap<K> merge(K key, long value) {
        Preconditions.checkArgument((((Key)key).getType() == Type.LONG ? 1 : 0) != 0, (String)"Key %s is of type %s, not LONG", key, (Object)((Object)((Key)key).getType()));
        long oldValue = this.getLong(key);
        long newValue = ((Key)key).merge(oldValue, value);
        if (newValue == 0L) {
            this._map.remove(key);
        } else {
            this._map.put(key, newValue);
        }
        return this;
    }

    public boolean getBoolean(K key) {
        Preconditions.checkArgument((((Key)key).getType() == Type.BOOLEAN ? 1 : 0) != 0, (String)"Key %s is of type %s, not BOOLEAN", key, (Object)((Object)((Key)key).getType()));
        Object o = this._map.get(key);
        return o != null && (Boolean)o != false;
    }

    public StatMap<K> merge(K key, boolean value) {
        boolean oldValue = this.getBoolean(key);
        boolean newValue = ((Key)key).merge(oldValue, value);
        if (!newValue) {
            this._map.remove(key);
        } else {
            this._map.put(key, Boolean.TRUE);
        }
        return this;
    }

    public String getString(K key) {
        Preconditions.checkArgument((((Key)key).getType() == Type.STRING ? 1 : 0) != 0, (String)"Key %s is of type %s, not STRING", key, (Object)((Object)((Key)key).getType()));
        Object o = this._map.get(key);
        return o == null ? null : (String)o;
    }

    public StatMap<K> merge(K key, String value) {
        String oldValue = this.getString(key);
        String newValue = ((Key)key).merge(oldValue, value);
        if (newValue == null) {
            this._map.remove(key);
        } else {
            this._map.put(key, newValue);
        }
        return this;
    }

    public Object getAny(K key) {
        switch (((Key)key).getType()) {
            case BOOLEAN: {
                return this.getBoolean(key);
            }
            case INT: {
                return this.getInt(key);
            }
            case LONG: {
                return this.getLong(key);
            }
            case STRING: {
                return this.getString(key);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + ((Key)key).getType());
    }

    public StatMap<K> merge(StatMap<K> other) {
        Preconditions.checkState((boolean)this._keyClass.equals(other._keyClass), (String)"Different key classes %s and %s", this._keyClass, other._keyClass);
        block6: for (Map.Entry<K, Object> entry : other._map.entrySet()) {
            Enum key = (Enum)entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            switch (((Key)((Object)key)).getType()) {
                case BOOLEAN: {
                    this.merge(key, (Boolean)value);
                    continue block6;
                }
                case INT: {
                    this.merge((K)key, (Integer)value);
                    continue block6;
                }
                case LONG: {
                    this.merge(key, (Long)value);
                    continue block6;
                }
                case STRING: {
                    this.merge(key, (String)value);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + ((Key)((Object)key)).getType());
        }
        return this;
    }

    public StatMap<K> merge(DataInput input) throws IOException {
        byte serializedKeys = input.readByte();
        Enum[] keys = (Enum[])KEYS_BY_CLASS.computeIfAbsent(this._keyClass, k -> k.getEnumConstants());
        block6: for (byte i = 0; i < serializedKeys; i = (byte)(i + 1)) {
            byte ordinal = input.readByte();
            Enum key = keys[ordinal];
            switch (((Key)((Object)key)).getType()) {
                case BOOLEAN: {
                    this.merge(key, true);
                    continue block6;
                }
                case INT: {
                    this.merge((K)key, input.readInt());
                    continue block6;
                }
                case LONG: {
                    this.merge(key, input.readLong());
                    continue block6;
                }
                case STRING: {
                    this.merge(key, input.readUTF());
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + ((Key)((Object)key)).getType());
                }
            }
        }
        return this;
    }

    public ObjectNode asJson() {
        ObjectNode node = JsonUtils.newObjectNode();
        block6: for (Map.Entry<K, Object> entry : this._map.entrySet()) {
            Enum key = (Enum)entry.getKey();
            Object value = entry.getValue();
            switch (((Key)((Object)key)).getType()) {
                case BOOLEAN: {
                    if (value == null) {
                        if (!((Key)((Object)key)).includeDefaultInJson()) continue block6;
                        node.put(((Key)((Object)key)).getStatName(), false);
                        continue block6;
                    }
                    node.put(((Key)((Object)key)).getStatName(), ((Boolean)value).booleanValue());
                    continue block6;
                }
                case INT: {
                    if (value == null) {
                        if (!((Key)((Object)key)).includeDefaultInJson()) continue block6;
                        node.put(((Key)((Object)key)).getStatName(), 0);
                        continue block6;
                    }
                    node.put(((Key)((Object)key)).getStatName(), ((Integer)value).intValue());
                    continue block6;
                }
                case LONG: {
                    if (value == null) {
                        if (!((Key)((Object)key)).includeDefaultInJson()) continue block6;
                        node.put(((Key)((Object)key)).getStatName(), 0L);
                        continue block6;
                    }
                    node.put(((Key)((Object)key)).getStatName(), ((Long)value).longValue());
                    continue block6;
                }
                case STRING: {
                    if (value == null) {
                        if (!((Key)((Object)key)).includeDefaultInJson()) continue block6;
                        node.put(((Key)((Object)key)).getStatName(), "");
                        continue block6;
                    }
                    node.put(((Key)((Object)key)).getStatName(), (String)value);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + ((Key)((Object)key)).getType());
        }
        return node;
    }

    public void serialize(DataOutput output) throws IOException {
        assert (this.checkContainsNoDefault()) : "No default value should be stored in the map";
        output.writeByte(this._map.size());
        int writtenKeys = 0;
        Enum[] keys = (Enum[])KEYS_BY_CLASS.computeIfAbsent(this._keyClass, k -> k.getEnumConstants());
        block6: for (int ordinal = 0; ordinal < keys.length; ++ordinal) {
            Enum key = keys[ordinal];
            switch (((Key)((Object)key)).getType()) {
                case BOOLEAN: {
                    if (!this.getBoolean(key)) continue block6;
                    ++writtenKeys;
                    output.writeByte(ordinal);
                    continue block6;
                }
                case INT: {
                    int value = this.getInt(key);
                    if (value == 0) continue block6;
                    ++writtenKeys;
                    output.writeByte(ordinal);
                    output.writeInt(value);
                    continue block6;
                }
                case LONG: {
                    long value = this.getLong(key);
                    if (value == 0L) continue block6;
                    ++writtenKeys;
                    output.writeByte(ordinal);
                    output.writeLong(value);
                    continue block6;
                }
                case STRING: {
                    String value = this.getString(key);
                    if (value == null) continue block6;
                    ++writtenKeys;
                    output.writeByte(ordinal);
                    output.writeUTF(value);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + ((Key)((Object)key)).getType());
                }
            }
        }
        assert (writtenKeys == this._map.size()) : "Written keys " + writtenKeys + " but map size " + this._map.size();
    }

    private boolean checkContainsNoDefault() {
        block6: for (Map.Entry<K, Object> entry : this._map.entrySet()) {
            Enum key = (Enum)entry.getKey();
            Object value = entry.getValue();
            switch (((Key)((Object)key)).getType()) {
                case BOOLEAN: {
                    if (value != null && ((Boolean)value).booleanValue()) continue block6;
                    throw new IllegalStateException("Boolean value must be true but " + value + " is stored for key " + key);
                }
                case INT: {
                    if (value != null && (Integer)value != 0) continue block6;
                    throw new IllegalStateException("Int value must be non-zero but " + value + " is stored for key " + key);
                }
                case LONG: {
                    if (value != null && (Long)value != 0L) continue block6;
                    throw new IllegalStateException("Long value must be non-zero but " + value + " is stored for key " + key);
                }
                case STRING: {
                    if (value != null) continue block6;
                    throw new IllegalStateException("String value must be non-null but null is stored for key " + key);
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + ((Key)((Object)key)).getType());
        }
        return true;
    }

    public static String getDefaultStatName(Key key) {
        String name = key.name();
        StringBuilder result = new StringBuilder();
        boolean capitalizeNext = false;
        for (char c : name.toCharArray()) {
            if (c == '_') {
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                result.append(c);
                capitalizeNext = false;
                continue;
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static <K extends Enum<K>> StatMap<K> deserialize(DataInput input, Class<K> keyClass) throws IOException {
        StatMap<K> result = new StatMap<K>(keyClass);
        result.merge(input);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatMap statMap = (StatMap)o;
        return Objects.equals(this._map, statMap._map);
    }

    public int hashCode() {
        return Objects.hash(this._map);
    }

    public String toString() {
        return this.asJson().toString();
    }

    public Class<K> getKeyClass() {
        return this._keyClass;
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public Iterable<K> keySet() {
        return this._map.keySet();
    }

    public static enum Type {
        BOOLEAN,
        INT,
        LONG,
        STRING;

    }

    public static interface Key {
        public String name();

        default public String getStatName() {
            return StatMap.getDefaultStatName(this);
        }

        default public int merge(int value1, int value2) {
            return value1 + value2;
        }

        default public long merge(long value1, long value2) {
            return value1 + value2;
        }

        default public boolean merge(boolean value1, boolean value2) {
            return value1 || value2;
        }

        default public String merge(@Nullable String value1, @Nullable String value2) {
            return value2 != null ? value2 : value1;
        }

        public Type getType();

        default public boolean includeDefaultInJson() {
            return false;
        }

        public static int minPositive(int value1, int value2) {
            if (value1 == 0 && value2 >= 0) {
                return value2;
            }
            if (value2 == 0 && value1 >= 0) {
                return value1;
            }
            return Math.min(value1, value2);
        }

        public static long minPositive(long value1, long value2) {
            if (value1 == 0L && value2 >= 0L) {
                return value2;
            }
            if (value2 == 0L && value1 >= 0L) {
                return value1;
            }
            return Math.min(value1, value2);
        }

        public static int eqNotZero(int value1, int value2) {
            if (value1 != value2) {
                if (value1 == 0) {
                    return value2;
                }
                if (value2 == 0) {
                    return value1;
                }
                throw new IllegalStateException("Cannot merge non-zero values: " + value1 + " and " + value2);
            }
            return value1;
        }
    }
}

