/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimePatternHandler {
    private DateTimePatternHandler() {
    }

    public static long parseDateTimeStringToEpochMillis(String dateTimeString, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimePatternHandler.getDateTimeFormatter(pattern);
        return dateTimeFormatter.parseMillis(dateTimeString);
    }

    public static long parseDateTimeStringToEpochMillis(String dateTimeString, String pattern, String timezoneId) {
        DateTimeFormatter dateTimeFormatter = DateTimePatternHandler.getDateTimeFormatter(pattern, timezoneId);
        return dateTimeFormatter.parseMillis(dateTimeString);
    }

    public static long parseDateTimeStringToEpochMillis(String dateTimeString, String pattern, String timezoneId, long defaultVal) {
        try {
            DateTimeFormatter dateTimeFormatter = DateTimePatternHandler.getDateTimeFormatter(pattern, timezoneId);
            return dateTimeFormatter.parseMillis(dateTimeString);
        }
        catch (Exception e) {
            return defaultVal;
        }
    }

    public static String parseEpochMillisToDateTimeString(long millis, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimePatternHandler.getDateTimeFormatter(pattern);
        return dateTimeFormatter.print(millis);
    }

    public static String parseEpochMillisToDateTimeString(long millis, String pattern, String timezoneId) {
        DateTimeFormatter dateTimeFormatter = DateTimePatternHandler.getDateTimeFormatter(pattern, timezoneId);
        return dateTimeFormatter.print(millis);
    }

    private static DateTimeFormatter getDateTimeFormatter(String pattern, String timezoneId) {
        return DateTimeFormat.forPattern((String)pattern).withZone(DateTimeZone.forID((String)timezoneId));
    }

    private static DateTimeFormatter getDateTimeFormatter(String pattern) {
        return DateTimePatternHandler.getDateTimeFormatter(pattern, DateTimeZone.UTC.getID());
    }
}

