/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;

public enum TransformFunctionType {
    ADD("add", "plus"),
    SUB("sub", "minus"),
    MULT("mult", "times"),
    DIV("div", "divide"),
    MOD("mod", new String[0]),
    ABS("abs", new String[0]),
    CEIL("ceil", "ceiling"),
    EXP("exp", new String[0]),
    FLOOR("floor", new String[0]),
    LOG("log", "ln"),
    LOG2("log2", new String[0]),
    LOG10("log10", new String[0]),
    SIGN("sign", new String[0]),
    ROUND_DECIMAL("roundDecimal", new String[0]),
    TRUNCATE("truncate", new String[0]),
    POWER("power", "pow"),
    SQRT("sqrt", new String[0]),
    LEAST("least", new String[0]),
    GREATEST("greatest", new String[0]),
    EQUALS("equals", new String[0]),
    NOT_EQUALS("not_equals", new String[0]),
    GREATER_THAN("greater_than", new String[0]),
    GREATER_THAN_OR_EQUAL("greater_than_or_equal", new String[0]),
    LESS_THAN("less_than", new String[0]),
    LESS_THAN_OR_EQUAL("less_than_or_equal", new String[0]),
    IN("in", new String[0]),
    NOT_IN("not_in", new String[0]),
    IS_TRUE("is_true", new String[0]),
    IS_NOT_TRUE("is_not_true", new String[0]),
    IS_FALSE("is_false", new String[0]),
    IS_NOT_FALSE("is_not_false", new String[0]),
    IS_NULL("is_null", new String[0]),
    IS_NOT_NULL("is_not_null", new String[0]),
    IS_DISTINCT_FROM("is_distinct_from", new String[0]),
    IS_NOT_DISTINCT_FROM("is_not_distinct_from", new String[0]),
    COALESCE("coalesce", new String[0]),
    AND("and", new String[0]),
    OR("or", new String[0]),
    NOT("not", new String[0]),
    CASE("case", new String[0]),
    CAST("cast", new String[0]),
    ARRAY_TO_MV("arrayToMV", (SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> TransformFunctionType.positionalComponentReturnType(opBinding, 0), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE}), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), "array_to_mv"),
    JSON_EXTRACT_SCALAR("jsonExtractScalar", (SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> TransformFunctionType.positionalReturnTypeInferenceFromStringLiteral(opBinding, 2, SqlTypeName.VARCHAR), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE}), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 2), "json_extract_scalar"),
    JSON_EXTRACT_INDEX("jsonExtractIndex", (SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> TransformFunctionType.positionalReturnTypeInferenceFromStringLiteral(opBinding, 2, SqlTypeName.VARCHAR), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE}), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 2), "json_extract_index"),
    JSON_EXTRACT_KEY("jsonExtractKey", ReturnTypes.TO_ARRAY, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER)), "json_extract_key"),
    TIME_CONVERT("timeConvert", ReturnTypes.BIGINT_FORCE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER)), "time_convert"),
    DATE_TIME_CONVERT("dateTimeConvert", (SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> TransformFunctionType.dateTimeConverterReturnTypeInference(opBinding), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE}), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER)), "date_time_convert"),
    DATE_TIME_CONVERT_WINDOW_HOP("dateTimeConvertWindowHop", ReturnTypes.TO_ARRAY, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER)), "date_time_convert_window_hop"),
    DATE_TRUNC("dateTrunc", ReturnTypes.BIGINT_FORCE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 1), "date_trunc"),
    FROM_DATE_TIME("fromDateTime", ReturnTypes.TIMESTAMP_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 1), "from_date_time"),
    TO_DATE_TIME("toDateTime", ReturnTypes.VARCHAR_2000_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 1), "to_date_time"),
    TIMESTAMP_ADD("timestampAdd", ReturnTypes.TIMESTAMP_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.ANY)), "timestamp_add", "dateAdd", "date_add"),
    TIMESTAMP_DIFF("timestampDiff", ReturnTypes.BIGINT_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.ANY)), "timestamp_diff", "dateDiff", "date_diff"),
    YEAR("year", new String[0]),
    YEAR_OF_WEEK("yearOfWeek", "year_of_week", "yow"),
    QUARTER("quarter", new String[0]),
    MONTH_OF_YEAR("monthOfYear", "month_of_year", "month"),
    WEEK_OF_YEAR("weekOfYear", "week_of_year", "week"),
    DAY_OF_YEAR("dayOfYear", "day_of_year", "doy"),
    DAY_OF_MONTH("dayOfMonth", "day_of_month", "day"),
    DAY_OF_WEEK("dayOfWeek", "day_of_week", "dow"),
    HOUR("hour", new String[0]),
    MINUTE("minute", new String[0]),
    SECOND("second", new String[0]),
    MILLISECOND("millisecond", new String[0]),
    EXTRACT("extract", new String[0]),
    SPLIT("split", ReturnTypes.TO_ARRAY, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.INTEGER), ordinal -> ordinal > 1), "split", "string_to_array"),
    ARRAY_LENGTH("arrayLength", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), "array_length", "cardinality"),
    ARRAY_AVERAGE("arrayAverage", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), "array_average"),
    ARRAY_MIN("arrayMin", (SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> TransformFunctionType.positionalComponentReturnType(opBinding, 0), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE}), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), "array_min"),
    ARRAY_MAX("arrayMax", (SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> TransformFunctionType.positionalComponentReturnType(opBinding, 0), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE}), (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), "array_max"),
    ARRAY_SUM("arraySum", ReturnTypes.DOUBLE, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), "array_sum"),
    ARRAY_SUM_INT("arraySumInt", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), "array_sum_int"),
    ARRAY_SUM_LONG("arraySumLong", ReturnTypes.BIGINT, (SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY}), "array_sum_long"),
    VALUE_IN("valueIn", ReturnTypes.ARG0_FORCE_NULLABLE, OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)2)), "value_in"),
    MAP_VALUE("mapValue", (SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> opBinding.getOperandType(2).getComponentType(), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE}), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.ANY)), "map_value"),
    IN_ID_SET("inIdSet", "in_id_set"),
    LOOKUP("lookUp", new String[0]),
    GROOVY("groovy", new String[0]),
    CLP_DECODE("clpDecode", ReturnTypes.VARCHAR_2000_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 2), "clp_decode"),
    CLP_ENCODED_VARS_MATCH("clpEncodedVarsMatch", ReturnTypes.BOOLEAN_NOT_NULL, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 2), "clp_encoded_vars_match"),
    REGEXP_EXTRACT("regexpExtract", "regexp_extract"),
    REGEXP_REPLACE("regexpReplace", ReturnTypes.VARCHAR_2000_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.CHARACTER, (Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.INTEGER, (Object)SqlTypeFamily.CHARACTER), ordinal -> ordinal > 2), "regexp_replace"),
    SCALAR("scalar", new String[0]),
    ST_GEOG_FROM_TEXT("ST_GeogFromText", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlOperandTypeChecker)OperandTypes.STRING, new String[0]),
    ST_GEOM_FROM_TEXT("ST_GeomFromText", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlOperandTypeChecker)OperandTypes.STRING, new String[0]),
    ST_GEOG_FROM_WKB("ST_GeogFromWKB", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlOperandTypeChecker)OperandTypes.BINARY, new String[0]),
    ST_GEOM_FROM_WKB("ST_GeomFromWKB", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlOperandTypeChecker)OperandTypes.BINARY, new String[0]),
    ST_POINT("ST_Point", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.ANY), ordinal -> ordinal > 1 && ordinal < 4), "stPoint"),
    ST_POLYGON("ST_Polygon", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlOperandTypeChecker)OperandTypes.STRING, "stPolygon"),
    ST_AREA("ST_Area", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.BINARY, "stArea"),
    ST_DISTANCE("ST_Distance", ReturnTypes.DOUBLE_NULLABLE, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.BINARY, (Object)SqlTypeFamily.BINARY)), "stDistance"),
    ST_GEOMETRY_TYPE("ST_GeometryType", ReturnTypes.VARCHAR_2000_NULLABLE, (SqlOperandTypeChecker)OperandTypes.BINARY, "stGeometryType"),
    ST_AS_BINARY("ST_AsBinary", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.VARBINARY), (SqlOperandTypeChecker)OperandTypes.BINARY, "stAsBinary"),
    ST_AS_TEXT("ST_AsText", ReturnTypes.VARCHAR_2000_NULLABLE, (SqlOperandTypeChecker)OperandTypes.BINARY, "stAsText"),
    ST_CONTAINS("ST_Contains", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.BINARY, (Object)SqlTypeFamily.BINARY)), "stContains"),
    ST_EQUALS("ST_Equals", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.BINARY, (Object)SqlTypeFamily.BINARY)), "stEquals"),
    ST_WITHIN("ST_Within", ReturnTypes.INTEGER, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.BINARY, (Object)SqlTypeFamily.BINARY)), "stWithin"),
    GEO_TO_H3("geoToH3", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.BIGINT), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.NUMERIC, (Object)SqlTypeFamily.NUMERIC), ordinal -> ordinal > 1 && ordinal < 4), "geo_to_h3"),
    COSINE_DISTANCE("cosineDistance", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.NUMERIC), ordinal -> ordinal > 1 && ordinal < 4), "cosine_distance"),
    INNER_PRODUCT("innerProduct", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.ARRAY)), "inner_product"),
    L1_DISTANCE("l1Distance", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.ARRAY)), "l1_distance"),
    L2_DISTANCE("l2Distance", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.ARRAY)), "l2_distance"),
    VECTOR_DIMS("vectorDims", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.INTEGER), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY)), "vector_dims"),
    VECTOR_NORM("vectorNorm", (SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)SqlTypeName.DOUBLE), (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY)), "vector_norm"),
    VECTOR_SIMILARITY("vectorSimilarity", ReturnTypes.BOOLEAN_NOT_NULL, (SqlOperandTypeChecker)OperandTypes.family((List)ImmutableList.of((Object)SqlTypeFamily.ARRAY, (Object)SqlTypeFamily.ANY, (Object)SqlTypeFamily.NUMERIC), ordinal -> ordinal > 1 && ordinal < 4), "vector_similarity"),
    ARRAY_VALUE_CONSTRUCTOR("arrayValueConstructor", "array_value_constructor"),
    SIN("sin", new String[0]),
    COS("cos", new String[0]),
    TAN("tan", new String[0]),
    COT("cot", new String[0]),
    ASIN("asin", new String[0]),
    ACOS("acos", new String[0]),
    ATAN("atan", new String[0]),
    ATAN2("atan2", new String[0]),
    SINH("sinh", new String[0]),
    COSH("cosh", new String[0]),
    TANH("tanh", new String[0]),
    DEGREES("degrees", new String[0]),
    RADIANS("radians", new String[0]);

    private final String _name;
    private final List<String> _alternativeNames;
    private final SqlKind _sqlKind;
    private final SqlReturnTypeInference _returnTypeInference;
    private final SqlOperandTypeChecker _operandTypeChecker;
    private final SqlFunctionCategory _sqlFunctionCategory;

    private TransformFunctionType(String name, String ... alternativeNames) {
        this(name, (SqlKind)null, (SqlReturnTypeInference)null, (SqlOperandTypeChecker)null, (SqlFunctionCategory)null, alternativeNames);
    }

    private TransformFunctionType(String name, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, String ... alternativeNames) {
        this(name, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION, alternativeNames);
    }

    private TransformFunctionType(String name, SqlKind sqlKind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory sqlFunctionCategory, String ... alternativeNames) {
        this._name = name;
        ArrayList<String> all = new ArrayList<String>(alternativeNames.length + 2);
        all.add(name);
        all.add(this.name());
        all.addAll(Arrays.asList(alternativeNames));
        this._alternativeNames = Collections.unmodifiableList(all);
        this._sqlKind = sqlKind;
        this._returnTypeInference = returnTypeInference;
        this._operandTypeChecker = operandTypeChecker;
        this._sqlFunctionCategory = sqlFunctionCategory;
    }

    public String getName() {
        return this._name;
    }

    public List<String> getAlternativeNames() {
        return this._alternativeNames;
    }

    public SqlKind getSqlKind() {
        return this._sqlKind;
    }

    public SqlReturnTypeInference getReturnTypeInference() {
        return this._returnTypeInference;
    }

    public SqlOperandTypeChecker getOperandTypeChecker() {
        return this._operandTypeChecker;
    }

    public SqlFunctionCategory getSqlFunctionCategory() {
        return this._sqlFunctionCategory;
    }

    private static RelDataType positionalReturnTypeInferenceFromStringLiteral(SqlOperatorBinding opBinding, int pos) {
        return TransformFunctionType.positionalReturnTypeInferenceFromStringLiteral(opBinding, pos, SqlTypeName.ANY);
    }

    private static RelDataType positionalReturnTypeInferenceFromStringLiteral(SqlOperatorBinding opBinding, int pos, SqlTypeName defaultSqlType) {
        if (opBinding.getOperandCount() > pos && opBinding.isOperandLiteral(pos, false)) {
            String operandType = ((String)opBinding.getOperandLiteralValue(pos, String.class)).toUpperCase();
            return TransformFunctionType.inferTypeFromStringLiteral(operandType, opBinding.getTypeFactory());
        }
        return opBinding.getTypeFactory().createSqlType(defaultSqlType);
    }

    private static RelDataType positionalComponentReturnType(SqlOperatorBinding opBinding, int pos) {
        if (opBinding.getOperandCount() > pos) {
            return opBinding.getOperandType(pos).getComponentType();
        }
        throw new IllegalArgumentException("Invalid number of arguments for function " + opBinding.getOperator().getName());
    }

    private static RelDataType dateTimeConverterReturnTypeInference(SqlOperatorBinding opBinding) {
        String outputFormatStr;
        DateTimeFormatSpec dateTimeFormatSpec;
        int outputFormatPos = 2;
        if (opBinding.getOperandCount() > outputFormatPos && opBinding.isOperandLiteral(outputFormatPos, false) && ((dateTimeFormatSpec = new DateTimeFormatSpec(outputFormatStr = (String)opBinding.getOperandLiteralValue(outputFormatPos, String.class))).getTimeFormat() == DateTimeFieldSpec.TimeFormat.EPOCH || dateTimeFormatSpec.getTimeFormat() == DateTimeFieldSpec.TimeFormat.TIMESTAMP)) {
            return opBinding.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
        }
        return opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
    }

    private static RelDataType inferTypeFromStringLiteral(String operandTypeStr, RelDataTypeFactory typeFactory) {
        switch (operandTypeStr) {
            case "INT": {
                return typeFactory.createSqlType(SqlTypeName.INTEGER);
            }
            case "LONG": {
                return typeFactory.createSqlType(SqlTypeName.BIGINT);
            }
            case "STRING": {
                return typeFactory.createSqlType(SqlTypeName.VARCHAR);
            }
            case "BYTES": {
                return typeFactory.createSqlType(SqlTypeName.VARBINARY);
            }
        }
        SqlTypeName sqlTypeName = SqlTypeName.get((String)operandTypeStr);
        if (sqlTypeName == null) {
            throw new IllegalArgumentException("Invalid type: " + operandTypeStr);
        }
        return typeFactory.createSqlType(sqlTypeName);
    }
}

