/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import org.apache.pinot.spi.annotations.ScalarFunction;

public class GeohashFunctions {
    private static final String BASE32 = "0123456789bcdefghjkmnpqrstuvwxyz";
    private static final int[] BITS = new int[]{16, 8, 4, 2, 1};

    private GeohashFunctions() {
    }

    public static long encode(double latitude, double longitude, int length) {
        if (length < 1 || length > 12) {
            throw new IllegalArgumentException("length must be between 1 and 12");
        }
        boolean isEven = true;
        double minLat = -90.0;
        double maxLat = 90.0;
        double minLon = -180.0;
        double maxLon = 180.0;
        long bit = Long.MIN_VALUE;
        long geohash = 0L;
        for (long i = 0L; i < (long)(5 * length); ++i) {
            double mid;
            if (isEven) {
                mid = (minLon + maxLon) / 2.0;
                if (longitude >= mid) {
                    geohash |= bit;
                    minLon = mid;
                } else {
                    maxLon = mid;
                }
            } else {
                mid = (minLat + maxLat) / 2.0;
                if (latitude >= mid) {
                    geohash |= bit;
                    minLat = mid;
                } else {
                    maxLat = mid;
                }
            }
            isEven = !isEven;
            bit >>>= 1;
        }
        return geohash | (long)length;
    }

    private static String longHashToStringGeohash(long hash) {
        int length = (int)(hash & 0xFL);
        if (length < 1 || length > 12) {
            throw new IllegalArgumentException("Invalid geohash length: " + length);
        }
        char[] geohash = new char[length];
        for (int i = 0; i < length; ++i) {
            geohash[i] = BASE32.charAt((int)(hash >>> 59 & 0x1FL));
            hash <<= 5;
        }
        return new String(geohash);
    }

    public static double[] decode(String geohash) {
        double[] lat = new double[]{-90.0, 90.0};
        double[] lon = new double[]{-180.0, 180.0};
        boolean isEven = true;
        for (int i = 0; i < geohash.length(); ++i) {
            int cd = BASE32.indexOf(geohash.charAt(i));
            for (int j = 0; j < 5; ++j) {
                int mask = BITS[j];
                if (isEven) {
                    GeohashFunctions.refineInterval(lon, cd, mask);
                } else {
                    GeohashFunctions.refineInterval(lat, cd, mask);
                }
                isEven = !isEven;
            }
        }
        return new double[]{(lat[0] + lat[1]) / 2.0, (lon[0] + lon[1]) / 2.0};
    }

    private static void refineInterval(double[] interval, int cd, int mask) {
        if ((cd & mask) != 0) {
            interval[0] = (interval[0] + interval[1]) / 2.0;
        } else {
            interval[1] = (interval[0] + interval[1]) / 2.0;
        }
    }

    @ScalarFunction(names={"encodeGeoHash", "encode_geohash"})
    public static String encodeGeoHash(double latitude, double longitude, int precision) {
        return GeohashFunctions.longHashToStringGeohash(GeohashFunctions.encode(latitude, longitude, precision));
    }

    @ScalarFunction(names={"decodeGeoHash", "decode_geohash"})
    public static double[] decodeGeoHash(String geohash) {
        return GeohashFunctions.decode(geohash);
    }

    @ScalarFunction(names={"decodeGeoHashLatitude", "decode_geohash_latitude", "decode_geohash_lat"})
    public static double decodeGeoHashLatitude(String geohash) {
        double[] latLon = GeohashFunctions.decode(geohash);
        return latLon[0];
    }

    @ScalarFunction(names={"decodeGeoHashLongitude", "decode_geohash_longitude", "decode_geohash_lon"})
    public static double decodeGeoHashLongitude(String geohash) {
        double[] latLon = GeohashFunctions.decode(geohash);
        return latLon[1];
    }
}

