/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.lineage;

import java.util.Set;
import java.util.UUID;
import org.apache.pinot.common.lineage.LineageEntry;
import org.apache.pinot.common.lineage.LineageEntryState;
import org.apache.pinot.common.lineage.SegmentLineage;

public class SegmentLineageUtils {
    private SegmentLineageUtils() {
    }

    public static String generateLineageEntryId() {
        return UUID.randomUUID().toString();
    }

    public static void filterSegmentsBasedOnLineageInPlace(Set<String> segments, SegmentLineage segmentLineage) {
        if (segmentLineage != null) {
            for (LineageEntry lineageEntry : segmentLineage.getLineageEntries().values()) {
                if (lineageEntry.getState() == LineageEntryState.COMPLETED) {
                    lineageEntry.getSegmentsFrom().forEach(segments::remove);
                    continue;
                }
                lineageEntry.getSegmentsTo().forEach(segments::remove);
            }
        }
    }
}

