/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum MinionMeter implements AbstractMetrics.Meter
{
    HEALTH_CHECK_GOOD_CALLS("healthChecks", true),
    HEALTH_CHECK_BAD_CALLS("healthChecks", true),
    NUMBER_TASKS("tasks", false),
    NUMBER_TASKS_EXECUTED("tasks", false),
    NUMBER_TASKS_COMPLETED("tasks", false),
    NUMBER_TASKS_CANCELLED("tasks", false),
    NUMBER_TASKS_FAILED("tasks", false),
    NUMBER_TASKS_FATAL_FAILED("tasks", false),
    SEGMENT_UPLOAD_FAIL_COUNT("segments", false),
    SEGMENT_DOWNLOAD_FAIL_COUNT("segments", false),
    SEGMENT_DOWNLOAD_COUNT("segments", false),
    SEGMENT_UPLOAD_COUNT("segments", false),
    SEGMENT_BYTES_DOWNLOADED("bytes", false),
    SEGMENT_BYTES_UPLOADED("bytes", false),
    RECORDS_PROCESSED_COUNT("rows", false),
    RECORDS_PURGED_COUNT("rows", false);

    private final String _meterName = Utils.toCamelCase(this.name().toLowerCase());
    private final String _unit;
    private final boolean _global;

    private MinionMeter(String unit, boolean global) {
        this._unit = unit;
        this._global = global;
    }

    @Override
    public String getMeterName() {
        return this._meterName;
    }

    @Override
    public String getUnit() {
        return this._unit;
    }

    @Override
    public boolean isGlobal() {
        return this._global;
    }
}

