/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.MinionGauge;
import org.apache.pinot.common.metrics.MinionMeter;
import org.apache.pinot.common.metrics.MinionQueryPhase;
import org.apache.pinot.common.metrics.MinionTimer;
import org.apache.pinot.spi.metrics.NoopPinotMetricsRegistry;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;

public class MinionMetrics
extends AbstractMetrics<MinionQueryPhase, MinionMeter, MinionGauge, MinionTimer> {
    private static final MinionMetrics NOOP = new MinionMetrics((PinotMetricsRegistry)new NoopPinotMetricsRegistry());
    private static final AtomicReference<MinionMetrics> MINION_METRICS_INSTANCE = new AtomicReference<MinionMetrics>(NOOP);

    public static boolean register(MinionMetrics minionMetrics) {
        return MINION_METRICS_INSTANCE.compareAndSet(NOOP, minionMetrics);
    }

    public static MinionMetrics get() {
        return MINION_METRICS_INSTANCE.get();
    }

    public MinionMetrics(PinotMetricsRegistry metricsRegistry) {
        this("pinot.minion.", metricsRegistry);
    }

    public MinionMetrics(String prefix, PinotMetricsRegistry metricsRegistry) {
        super(prefix, metricsRegistry, MinionMetrics.class);
    }

    protected MinionQueryPhase[] getQueryPhases() {
        return MinionQueryPhase.values();
    }

    protected MinionMeter[] getMeters() {
        return MinionMeter.values();
    }

    protected MinionGauge[] getGauges() {
        return MinionGauge.values();
    }
}

