/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.metrics;

import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metrics.AbstractMetrics;

public enum ServerTimer implements AbstractMetrics.Timer
{
    FRESHNESS_LAG_MS("freshnessLagMs", false, "Tracks the freshness lag for consuming segments. Computed as the time-period between when the data was last updated in the table and the current time."),
    NETTY_CONNECTION_SEND_RESPONSE_LATENCY("nettyConnection", false, "Latency of sending the response from server to broker. Computed as the time spent in sending response to brokers after the results are available."),
    EXECUTION_THREAD_CPU_TIME_NS("nanoseconds", false, "Query cost (execution thread cpu time) for query processing on server. Computed as time spent by all threads processing query and results (doesn't includes time spent in system activities)"),
    SYSTEM_ACTIVITIES_CPU_TIME_NS("nanoseconds", false, "Query cost (system activities cpu time) for query processing on server. Computed as the time spent in processing query on the servers (only counts system acitivities such as GC, OS paging etc.)"),
    RESPONSE_SER_CPU_TIME_NS("nanoseconds", false, "Query cost (response serialization cpu time) for query processing on server. Computed as the time spent in serializing query response on servers"),
    SEGMENT_UPLOAD_TIME_MS("milliseconds", false),
    TOTAL_CPU_TIME_NS("nanoseconds", false, "Total query cost (thread cpu time + system activities cpu time + response serialization cpu time) for query processing on server."),
    UPSERT_PRELOAD_TIME_MS("milliseconds", false, "Total time taken to preload a table partition of an upsert table with upsert snapshot"),
    UPSERT_REMOVE_EXPIRED_PRIMARY_KEYS_TIME_MS("milliseconds", false, "Total time taken to delete expired primary keys based on metadataTTL or deletedKeysTTL"),
    GRPC_QUERY_EXECUTION_MS("milliseconds", false, "Total execution time of a successful query over gRPC"),
    UPSERT_SNAPSHOT_TIME_MS("milliseconds", false, "Total time taken to take upsert table snapshot"),
    HASH_JOIN_BUILD_TABLE_CPU_TIME_MS("millis", true),
    MULTI_STAGE_SERIALIZATION_CPU_TIME_MS("millis", true),
    MULTI_STAGE_DESERIALIZATION_CPU_TIME_MS("millis", true),
    RECEIVE_DOWNSTREAM_WAIT_CPU_TIME_MS("millis", true),
    RECEIVE_UPSTREAM_WAIT_CPU_TIME_MS("millis", true);

    private final String _timerName;
    private final boolean _global;
    private final String _description;

    private ServerTimer(String unit, boolean global) {
        this(unit, global, "");
    }

    private ServerTimer(String unit, boolean global, String description) {
        this._global = global;
        this._timerName = Utils.toCamelCase(this.name().toLowerCase());
        this._description = description;
    }

    @Override
    public String getTimerName() {
        return this._timerName;
    }

    @Override
    public boolean isGlobal() {
        return this._global;
    }

    @Override
    public String getDescription() {
        return this._description;
    }
}

