/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.LiteralContext;
import org.apache.pinot.spi.data.FieldSpec;

public class ExpressionContext {
    private final Type _type;
    private final String _identifier;
    private final FunctionContext _function;
    private final LiteralContext _literal;

    public static ExpressionContext forLiteral(LiteralContext literal) {
        return new ExpressionContext(Type.LITERAL, null, null, literal);
    }

    public static ExpressionContext forLiteral(Literal literal) {
        return ExpressionContext.forLiteral(new LiteralContext(literal));
    }

    @VisibleForTesting
    public static ExpressionContext forLiteral(FieldSpec.DataType type, @Nullable Object value) {
        return ExpressionContext.forLiteral(new LiteralContext(type, value));
    }

    public static ExpressionContext forIdentifier(String identifier) {
        return new ExpressionContext(Type.IDENTIFIER, identifier, null, null);
    }

    public static ExpressionContext forFunction(FunctionContext function) {
        return new ExpressionContext(Type.FUNCTION, null, function, null);
    }

    private ExpressionContext(Type type, String identifier, FunctionContext function, LiteralContext literal) {
        this._type = type;
        this._identifier = identifier;
        this._function = function;
        this._literal = literal;
    }

    public Type getType() {
        return this._type;
    }

    public LiteralContext getLiteral() {
        return this._literal;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public FunctionContext getFunction() {
        return this._function;
    }

    public void getColumns(Set<String> columns) {
        if (this._type == Type.IDENTIFIER) {
            if (!this._identifier.equals("*")) {
                columns.add(this._identifier);
            }
        } else if (this._type == Type.FUNCTION) {
            this._function.getColumns(columns);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpressionContext)) {
            return false;
        }
        ExpressionContext that = (ExpressionContext)o;
        return this._type == that._type && Objects.equals(this._identifier, that._identifier) && Objects.equals(this._function, that._function) && Objects.equals(this._literal, that._literal);
    }

    public int hashCode() {
        int hash = 961 * this._type.hashCode();
        switch (this._type) {
            case LITERAL: {
                return hash + this._literal.hashCode();
            }
            case IDENTIFIER: {
                return hash + this._identifier.hashCode();
            }
            case FUNCTION: {
                return hash + this._function.hashCode();
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        switch (this._type) {
            case LITERAL: {
                return this._literal.toString();
            }
            case IDENTIFIER: {
                return this._identifier;
            }
            case FUNCTION: {
                return this._function.toString();
            }
        }
        throw new IllegalStateException();
    }

    public static enum Type {
        LITERAL,
        IDENTIFIER,
        FUNCTION;

    }
}

