/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.LiteralContext;
import org.apache.pinot.common.request.context.predicate.EqPredicate;
import org.apache.pinot.common.request.context.predicate.InPredicate;
import org.apache.pinot.common.request.context.predicate.IsNotNullPredicate;
import org.apache.pinot.common.request.context.predicate.IsNullPredicate;
import org.apache.pinot.common.request.context.predicate.JsonMatchPredicate;
import org.apache.pinot.common.request.context.predicate.NotEqPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.RangePredicate;
import org.apache.pinot.common.request.context.predicate.RegexpLikePredicate;
import org.apache.pinot.common.request.context.predicate.TextContainsPredicate;
import org.apache.pinot.common.request.context.predicate.TextMatchPredicate;
import org.apache.pinot.common.request.context.predicate.VectorSimilarityPredicate;
import org.apache.pinot.common.utils.RegexpPatternConverterUtils;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.exception.BadQueryRequestException;
import org.apache.pinot.sql.FilterKind;
import org.apache.pinot.sql.parsers.CalciteSqlParser;

public class RequestContextUtils {
    private RequestContextUtils() {
    }

    public static ExpressionContext getExpression(String expression) {
        if (expression.equals("*")) {
            return ExpressionContext.forIdentifier("*");
        }
        return RequestContextUtils.getExpression(CalciteSqlParser.compileToExpression(expression));
    }

    public static ExpressionContext getExpression(Expression thriftExpression) {
        switch (thriftExpression.getType()) {
            case LITERAL: {
                return ExpressionContext.forLiteral(thriftExpression.getLiteral());
            }
            case IDENTIFIER: {
                return ExpressionContext.forIdentifier(thriftExpression.getIdentifier().getName());
            }
            case FUNCTION: {
                return ExpressionContext.forFunction(RequestContextUtils.getFunction(thriftExpression.getFunctionCall()));
            }
        }
        throw new IllegalStateException();
    }

    public static FunctionContext getFunction(Function thriftFunction) {
        String functionName = thriftFunction.getOperator();
        FunctionContext.Type functionType = AggregationFunctionType.isAggregationFunction((String)functionName) ? FunctionContext.Type.AGGREGATION : FunctionContext.Type.TRANSFORM;
        List<Expression> operands = thriftFunction.getOperands();
        if (operands != null) {
            ArrayList<ExpressionContext> arguments = new ArrayList<ExpressionContext>(operands.size());
            for (Expression operand : operands) {
                arguments.add(RequestContextUtils.getExpression(operand));
            }
            return new FunctionContext(functionType, functionName, arguments);
        }
        return new FunctionContext(functionType, functionName, Collections.emptyList());
    }

    public static FilterContext getFilter(Expression thriftExpression) {
        ExpressionType type = thriftExpression.getType();
        switch (type) {
            case FUNCTION: {
                Function thriftFunction = thriftExpression.getFunctionCall();
                return RequestContextUtils.getFilter(thriftFunction);
            }
            case IDENTIFIER: {
                return FilterContext.forPredicate(new EqPredicate(RequestContextUtils.getExpression(thriftExpression), "true"));
            }
            case LITERAL: {
                return FilterContext.forConstant(new LiteralContext(thriftExpression.getLiteral()).getBooleanValue());
            }
        }
        throw new IllegalStateException();
    }

    public static FilterContext getFilter(Function thriftFunction) {
        String functionOperator = thriftFunction.getOperator();
        if (!EnumUtils.isValidEnum(FilterKind.class, (String)functionOperator)) {
            return FilterContext.forPredicate(new EqPredicate(ExpressionContext.forFunction(RequestContextUtils.getFunction(thriftFunction)), "true"));
        }
        FilterKind filterKind = FilterKind.valueOf(thriftFunction.getOperator().toUpperCase());
        List<Expression> operands = thriftFunction.getOperands();
        int numOperands = operands.size();
        switch (filterKind) {
            case AND: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (Expression operand : operands) {
                    FilterContext filter = RequestContextUtils.getFilter(operand);
                    if (!filter.isConstant()) {
                        children.add(filter);
                        continue;
                    }
                    if (!filter.isConstantFalse()) continue;
                    return FilterContext.CONSTANT_FALSE;
                }
                int numChildren = children.size();
                if (numChildren == 0) {
                    return FilterContext.CONSTANT_TRUE;
                }
                if (numChildren == 1) {
                    return (FilterContext)children.get(0);
                }
                return FilterContext.forAnd(children);
            }
            case OR: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (Expression operand : operands) {
                    FilterContext filter = RequestContextUtils.getFilter(operand);
                    if (!filter.isConstant()) {
                        children.add(filter);
                        continue;
                    }
                    if (!filter.isConstantTrue()) continue;
                    return FilterContext.CONSTANT_TRUE;
                }
                int numChildren = children.size();
                if (numChildren == 0) {
                    return FilterContext.CONSTANT_FALSE;
                }
                if (numChildren == 1) {
                    return (FilterContext)children.get(0);
                }
                return FilterContext.forOr(children);
            }
            case NOT: {
                assert (numOperands == 1);
                FilterContext filter = RequestContextUtils.getFilter(operands.get(0));
                if (!filter.isConstant()) {
                    return FilterContext.forNot(filter);
                }
                return filter.isConstantTrue() ? FilterContext.CONSTANT_FALSE : FilterContext.CONSTANT_TRUE;
            }
            case EQUALS: {
                return FilterContext.forPredicate(new EqPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case NOT_EQUALS: {
                return FilterContext.forPredicate(new NotEqPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return FilterContext.forPredicate(new InPredicate(RequestContextUtils.getExpression(operands.get(0)), values));
            }
            case NOT_IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return FilterContext.forPredicate(new NotInPredicate(RequestContextUtils.getExpression(operands.get(0)), values));
            }
            case GREATER_THAN: {
                return FilterContext.forPredicate(new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), false, RequestContextUtils.getStringValue(operands.get(1)), false, "*", new LiteralContext(operands.get(1).getLiteral()).getType()));
            }
            case GREATER_THAN_OR_EQUAL: {
                return FilterContext.forPredicate(new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), true, RequestContextUtils.getStringValue(operands.get(1)), false, "*", new LiteralContext(operands.get(1).getLiteral()).getType()));
            }
            case LESS_THAN: {
                return FilterContext.forPredicate(new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), false, "*", false, RequestContextUtils.getStringValue(operands.get(1)), new LiteralContext(operands.get(1).getLiteral()).getType()));
            }
            case LESS_THAN_OR_EQUAL: {
                return FilterContext.forPredicate(new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), false, "*", true, RequestContextUtils.getStringValue(operands.get(1)), new LiteralContext(operands.get(1).getLiteral()).getType()));
            }
            case BETWEEN: {
                return FilterContext.forPredicate(new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), true, RequestContextUtils.getStringValue(operands.get(1)), true, RequestContextUtils.getStringValue(operands.get(2)), new LiteralContext(operands.get(1).getLiteral()).getType()));
            }
            case RANGE: {
                return FilterContext.forPredicate(new RangePredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case REGEXP_LIKE: {
                return FilterContext.forPredicate(new RegexpLikePredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LIKE: {
                return FilterContext.forPredicate(new RegexpLikePredicate(RequestContextUtils.getExpression(operands.get(0)), RegexpPatternConverterUtils.likeToRegexpLike(RequestContextUtils.getStringValue(operands.get(1)))));
            }
            case TEXT_CONTAINS: {
                return FilterContext.forPredicate(new TextContainsPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case TEXT_MATCH: {
                return FilterContext.forPredicate(new TextMatchPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case JSON_MATCH: {
                return FilterContext.forPredicate(new JsonMatchPredicate(RequestContextUtils.getExpression(operands.get(0)), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case VECTOR_SIMILARITY: {
                ExpressionContext lhs = RequestContextUtils.getExpression(operands.get(0));
                float[] vectorValue = RequestContextUtils.getVectorValue(operands.get(1));
                int topK = 10;
                if (operands.size() == 3) {
                    topK = operands.get(2).getLiteral().getIntValue();
                }
                return FilterContext.forPredicate(new VectorSimilarityPredicate(lhs, vectorValue, topK));
            }
            case IS_NULL: {
                return FilterContext.forPredicate(new IsNullPredicate(RequestContextUtils.getExpression(operands.get(0))));
            }
            case IS_NOT_NULL: {
                return FilterContext.forPredicate(new IsNotNullPredicate(RequestContextUtils.getExpression(operands.get(0))));
            }
        }
        throw new IllegalStateException();
    }

    public static String getStringValue(Expression thriftExpression) {
        Literal literal = thriftExpression.getLiteral();
        if (literal == null) {
            throw new BadQueryRequestException("Pinot does not support column or function on the right-hand side of the predicate");
        }
        return RequestUtils.getLiteralString(literal);
    }

    public static FilterContext getFilter(ExpressionContext filterExpression) {
        ExpressionContext.Type type = filterExpression.getType();
        switch (type) {
            case FUNCTION: {
                FunctionContext filterFunction = filterExpression.getFunction();
                return RequestContextUtils.getFilter(filterFunction);
            }
            case IDENTIFIER: {
                return FilterContext.forPredicate(new EqPredicate(filterExpression, RequestContextUtils.getStringValue(RequestUtils.getLiteralExpression(true))));
            }
            case LITERAL: {
                return FilterContext.forConstant(filterExpression.getLiteral().getBooleanValue());
            }
        }
        throw new IllegalStateException();
    }

    public static FilterContext getFilter(FunctionContext filterFunction) {
        String functionOperator = filterFunction.getFunctionName().toUpperCase();
        if (!EnumUtils.isValidEnum(FilterKind.class, (String)functionOperator)) {
            return FilterContext.forPredicate(new EqPredicate(ExpressionContext.forFunction(filterFunction), "true"));
        }
        FilterKind filterKind = FilterKind.valueOf(filterFunction.getFunctionName().toUpperCase());
        List<ExpressionContext> operands = filterFunction.getArguments();
        int numOperands = operands.size();
        switch (filterKind) {
            case AND: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (ExpressionContext operand : operands) {
                    FilterContext filter = RequestContextUtils.getFilter(operand);
                    if (!filter.isConstant()) {
                        children.add(filter);
                        continue;
                    }
                    if (!filter.isConstantFalse()) continue;
                    return FilterContext.CONSTANT_FALSE;
                }
                int numChildren = children.size();
                if (numChildren == 0) {
                    return FilterContext.CONSTANT_TRUE;
                }
                if (numChildren == 1) {
                    return (FilterContext)children.get(0);
                }
                return FilterContext.forAnd(children);
            }
            case OR: {
                ArrayList<FilterContext> children = new ArrayList<FilterContext>(numOperands);
                for (ExpressionContext operand : operands) {
                    FilterContext filter = RequestContextUtils.getFilter(operand);
                    if (!filter.isConstant()) {
                        children.add(filter);
                        continue;
                    }
                    if (!filter.isConstantTrue()) continue;
                    return FilterContext.CONSTANT_TRUE;
                }
                int numChildren = children.size();
                if (numChildren == 0) {
                    return FilterContext.CONSTANT_FALSE;
                }
                if (numChildren == 1) {
                    return (FilterContext)children.get(0);
                }
                return FilterContext.forOr(children);
            }
            case NOT: {
                assert (numOperands == 1);
                FilterContext filter = RequestContextUtils.getFilter(operands.get(0));
                if (!filter.isConstant()) {
                    return FilterContext.forNot(filter);
                }
                return filter.isConstantTrue() ? FilterContext.CONSTANT_FALSE : FilterContext.CONSTANT_TRUE;
            }
            case EQUALS: {
                return FilterContext.forPredicate(new EqPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case NOT_EQUALS: {
                return FilterContext.forPredicate(new NotEqPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return FilterContext.forPredicate(new InPredicate(operands.get(0), values));
            }
            case NOT_IN: {
                ArrayList<String> values = new ArrayList<String>(numOperands - 1);
                for (int i = 1; i < numOperands; ++i) {
                    values.add(RequestContextUtils.getStringValue(operands.get(i)));
                }
                return FilterContext.forPredicate(new NotInPredicate(operands.get(0), values));
            }
            case GREATER_THAN: {
                return FilterContext.forPredicate(new RangePredicate(operands.get(0), false, RequestContextUtils.getStringValue(operands.get(1)), false, "*", operands.get(1).getLiteral().getType()));
            }
            case GREATER_THAN_OR_EQUAL: {
                return FilterContext.forPredicate(new RangePredicate(operands.get(0), true, RequestContextUtils.getStringValue(operands.get(1)), false, "*", operands.get(1).getLiteral().getType()));
            }
            case LESS_THAN: {
                return FilterContext.forPredicate(new RangePredicate(operands.get(0), false, "*", false, RequestContextUtils.getStringValue(operands.get(1)), operands.get(1).getLiteral().getType()));
            }
            case LESS_THAN_OR_EQUAL: {
                return FilterContext.forPredicate(new RangePredicate(operands.get(0), false, "*", true, RequestContextUtils.getStringValue(operands.get(1)), operands.get(1).getLiteral().getType()));
            }
            case BETWEEN: {
                return FilterContext.forPredicate(new RangePredicate(operands.get(0), true, RequestContextUtils.getStringValue(operands.get(1)), true, RequestContextUtils.getStringValue(operands.get(2)), operands.get(1).getLiteral().getType()));
            }
            case RANGE: {
                return FilterContext.forPredicate(new RangePredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case REGEXP_LIKE: {
                return FilterContext.forPredicate(new RegexpLikePredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case LIKE: {
                return FilterContext.forPredicate(new RegexpLikePredicate(operands.get(0), RegexpPatternConverterUtils.likeToRegexpLike(RequestContextUtils.getStringValue(operands.get(1)))));
            }
            case TEXT_CONTAINS: {
                return FilterContext.forPredicate(new TextContainsPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case TEXT_MATCH: {
                return FilterContext.forPredicate(new TextMatchPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case JSON_MATCH: {
                return FilterContext.forPredicate(new JsonMatchPredicate(operands.get(0), RequestContextUtils.getStringValue(operands.get(1))));
            }
            case VECTOR_SIMILARITY: {
                int topK = 10;
                if (operands.size() == 3) {
                    topK = (int)operands.get(2).getLiteral().getLongValue();
                }
                return FilterContext.forPredicate(new VectorSimilarityPredicate(operands.get(0), RequestContextUtils.getVectorValue(operands.get(1)), topK));
            }
            case IS_NULL: {
                return FilterContext.forPredicate(new IsNullPredicate(operands.get(0)));
            }
            case IS_NOT_NULL: {
                return FilterContext.forPredicate(new IsNotNullPredicate(operands.get(0)));
            }
        }
        throw new IllegalStateException();
    }

    private static String getStringValue(ExpressionContext expressionContext) {
        if (expressionContext.getType() != ExpressionContext.Type.LITERAL) {
            throw new BadQueryRequestException("Pinot does not support column or function on the right-hand side of the predicate");
        }
        return expressionContext.getLiteral().getStringValue();
    }

    private static float[] getVectorValue(ExpressionContext expressionContext) {
        if (expressionContext.getType() != ExpressionContext.Type.FUNCTION) {
            throw new BadQueryRequestException("Pinot does not support column or function on the right-hand side of the predicate");
        }
        float[] vector = new float[expressionContext.getFunction().getArguments().size()];
        for (int i = 0; i < expressionContext.getFunction().getArguments().size(); ++i) {
            vector[i] = Float.parseFloat(expressionContext.getFunction().getArguments().get(i).getLiteral().getValue().toString());
        }
        return vector;
    }

    private static float[] getVectorValue(Expression thriftExpression) {
        Literal literal = thriftExpression.getLiteral();
        if (literal != null) {
            Literal._Fields type = (Literal._Fields)literal.getSetField();
            switch (type) {
                case INT_ARRAY_VALUE: {
                    List<Integer> values = literal.getIntArrayValue();
                    int numValues = values.size();
                    float[] vector = new float[numValues];
                    for (int i = 0; i < numValues; ++i) {
                        vector[i] = values.get(i).intValue();
                    }
                    return vector;
                }
                case LONG_ARRAY_VALUE: {
                    List<Long> values = literal.getLongArrayValue();
                    int numValues = values.size();
                    float[] vector = new float[numValues];
                    for (int i = 0; i < numValues; ++i) {
                        vector[i] = values.get(i).longValue();
                    }
                    return vector;
                }
                case FLOAT_ARRAY_VALUE: {
                    List<Integer> values = literal.getFloatArrayValue();
                    int numValues = values.size();
                    float[] vector = new float[numValues];
                    for (int i = 0; i < numValues; ++i) {
                        vector[i] = Float.intBitsToFloat(values.get(i));
                    }
                    return vector;
                }
                case DOUBLE_ARRAY_VALUE: {
                    List<Double> values = literal.getDoubleArrayValue();
                    int numValues = values.size();
                    float[] vector = new float[numValues];
                    for (int i = 0; i < numValues; ++i) {
                        vector[i] = values.get(i).floatValue();
                    }
                    return vector;
                }
            }
            throw new IllegalStateException("Unsupported literal type: " + type);
        }
        Function function = thriftExpression.getFunctionCall();
        Preconditions.checkState((function != null ? 1 : 0) != 0, (String)"Unsupported right-hand side expression for vector similarity predicate: %s", (Object)thriftExpression);
        List<Expression> operands = function.getOperands();
        int numOperands = operands.size();
        float[] vector = new float[numOperands];
        for (int i = 0; i < numOperands; ++i) {
            vector[i] = RequestContextUtils.getFloatValue(operands.get(i));
        }
        return vector;
    }

    private static float getFloatValue(Expression thriftExpression) {
        Literal literal = thriftExpression.getLiteral();
        Preconditions.checkState((literal != null ? 1 : 0) != 0, (String)"Expecting literal expression, got: %s", (Object)thriftExpression);
        Literal._Fields type = (Literal._Fields)literal.getSetField();
        switch (type) {
            case INT_VALUE: {
                return literal.getIntValue();
            }
            case LONG_VALUE: {
                return literal.getLongValue();
            }
            case FLOAT_VALUE: {
                return Float.intBitsToFloat(literal.getFloatValue());
            }
            case DOUBLE_VALUE: {
                return (float)literal.getDoubleValue();
            }
        }
        throw new IllegalStateException("Unsupported literal type: " + type);
    }
}

