/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.request.context.predicate;

import java.util.Objects;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.predicate.BasePredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.utils.regex.Pattern;
import org.apache.pinot.common.utils.regex.PatternFactory;

public class RegexpLikePredicate
extends BasePredicate {
    private final String _value;
    private Pattern _pattern = null;

    public RegexpLikePredicate(ExpressionContext lhs, String value) {
        super(lhs);
        this._value = value;
    }

    @Override
    public Predicate.Type getType() {
        return Predicate.Type.REGEXP_LIKE;
    }

    public String getValue() {
        return this._value;
    }

    public Pattern getPattern() {
        if (this._pattern == null) {
            this._pattern = PatternFactory.compile(this._value);
        }
        return this._pattern;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegexpLikePredicate)) {
            return false;
        }
        RegexpLikePredicate that = (RegexpLikePredicate)o;
        return Objects.equals(this._lhs, that._lhs) && Objects.equals(this._value, that._value);
    }

    public int hashCode() {
        return Objects.hash(this._lhs, this._value);
    }

    public String toString() {
        return "regexp_like(" + this._lhs + ",'" + this._value + "')";
    }
}

