/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.response.broker.QueryProcessingException;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.spi.utils.JsonUtils;

public interface BrokerResponse {
    default public String toJsonString() throws IOException {
        return JsonUtils.objectToString((Object)this);
    }

    default public void toOutputStream(OutputStream outputStream) throws IOException {
        JsonUtils.objectToOutputStream((Object)this, (OutputStream)outputStream);
    }

    @Nullable
    public ResultTable getResultTable();

    public void setResultTable(@Nullable ResultTable var1);

    public int getNumRowsResultSet();

    public boolean isPartialResult();

    public List<QueryProcessingException> getExceptions();

    @Deprecated
    @JsonIgnore
    default public List<QueryProcessingException> getProcessingExceptions() {
        return this.getExceptions();
    }

    @JsonIgnore
    default public int getExceptionsSize() {
        return this.getExceptions().size();
    }

    public boolean isNumGroupsLimitReached();

    public boolean isMaxRowsInJoinReached();

    public boolean isMaxRowsInWindowReached();

    public long getTimeUsedMs();

    public String getRequestId();

    public void setRequestId(String var1);

    public String getBrokerId();

    public void setBrokerId(String var1);

    public long getNumDocsScanned();

    public long getTotalDocs();

    public long getNumEntriesScannedInFilter();

    public long getNumEntriesScannedPostFilter();

    public int getNumServersQueried();

    public int getNumServersResponded();

    public long getNumSegmentsQueried();

    public long getNumSegmentsProcessed();

    public long getNumSegmentsMatched();

    public long getNumConsumingSegmentsQueried();

    public long getNumConsumingSegmentsProcessed();

    public long getNumConsumingSegmentsMatched();

    public long getMinConsumingFreshnessTimeMs();

    public long getNumSegmentsPrunedByBroker();

    public long getNumSegmentsPrunedByServer();

    public long getNumSegmentsPrunedInvalid();

    public long getNumSegmentsPrunedByLimit();

    public long getNumSegmentsPrunedByValue();

    public long getBrokerReduceTimeMs();

    public long getOfflineThreadCpuTimeNs();

    public long getRealtimeThreadCpuTimeNs();

    public long getOfflineSystemActivitiesCpuTimeNs();

    public long getRealtimeSystemActivitiesCpuTimeNs();

    public long getOfflineResponseSerializationCpuTimeNs();

    public long getRealtimeResponseSerializationCpuTimeNs();

    default public long getOfflineTotalCpuTimeNs() {
        return this.getOfflineThreadCpuTimeNs() + this.getOfflineSystemActivitiesCpuTimeNs() + this.getOfflineResponseSerializationCpuTimeNs();
    }

    default public long getRealtimeTotalCpuTimeNs() {
        return this.getRealtimeThreadCpuTimeNs() + this.getRealtimeSystemActivitiesCpuTimeNs() + this.getRealtimeResponseSerializationCpuTimeNs();
    }

    public long getExplainPlanNumEmptyFilterSegments();

    public long getExplainPlanNumMatchAllFilterSegments();

    public Map<String, String> getTraceInfo();
}

