/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.exception.DatabaseConflictException;

public class DatabaseUtils {
    private DatabaseUtils() {
    }

    public static String translateTableName(String tableName, @Nullable String databaseName, boolean ignoreCase) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)tableName), (Object)"'tableName' cannot be null or empty");
        String[] tableSplit = StringUtils.split((String)tableName, (char)'.');
        switch (tableSplit.length) {
            case 1: {
                if (StringUtils.isNotEmpty((CharSequence)databaseName) && !databaseName.equalsIgnoreCase("default")) {
                    return databaseName + "." + tableName;
                }
                return tableName;
            }
            case 2: {
                Preconditions.checkArgument((!tableSplit[1].isEmpty() ? 1 : 0) != 0, (String)"Invalid table name '%s'", (Object)tableName);
                String databasePrefix = tableSplit[0];
                if (!(StringUtils.isEmpty((CharSequence)databaseName) || !ignoreCase && databaseName.equals(databasePrefix) || ignoreCase && databaseName.equalsIgnoreCase(databasePrefix))) {
                    throw new DatabaseConflictException("Database name '" + databasePrefix + "' from table prefix does not match database name '" + databaseName + "' from header");
                }
                return databasePrefix.equalsIgnoreCase("default") ? tableSplit[1] : tableName;
            }
        }
        throw new IllegalArgumentException("Table name: '" + tableName + "' containing more than one '.' is not allowed");
    }

    public static String translateTableName(String tableName, @Nullable String databaseName) {
        return DatabaseUtils.translateTableName(tableName, databaseName, false);
    }

    public static String translateTableName(String tableName, @Nullable HttpHeaders headers, boolean ignoreCase) {
        String database = headers != null ? headers.getHeaderString("database") : null;
        return DatabaseUtils.translateTableName(tableName, database, ignoreCase);
    }

    public static String translateTableName(String tableName, @Nullable HttpHeaders headers) {
        return DatabaseUtils.translateTableName(tableName, headers, false);
    }

    public static boolean isPartOfDatabase(String tableName, @Nullable String databaseName) {
        if (StringUtils.isEmpty((CharSequence)databaseName) || databaseName.equalsIgnoreCase("default")) {
            return !tableName.contains(".");
        }
        return tableName.startsWith(databaseName + ".");
    }

    public static String extractDatabaseFromQueryRequest(@Nullable Map<String, String> queryOptions, @Nullable HttpHeaders headers) {
        String databaseFromHeaders;
        String databaseFromOptions = queryOptions == null ? null : queryOptions.get("database");
        String string = databaseFromHeaders = headers == null ? null : headers.getHeaderString("database");
        if (databaseFromHeaders != null && databaseFromOptions != null && !databaseFromOptions.equals(databaseFromHeaders)) {
            throw new DatabaseConflictException("Database context mismatch : from headers '" + databaseFromHeaders + "', from query options '" + databaseFromOptions + "'");
        }
        String database = databaseFromHeaders != null ? databaseFromHeaders : databaseFromOptions;
        return Objects.requireNonNullElse(database, "default");
    }
}

