/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LLCSegmentName
implements Comparable<LLCSegmentName> {
    private static final String SEPARATOR = "__";
    private static final String DATE_FORMAT = "yyyyMMdd'T'HHmm'Z'";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd'T'HHmm'Z'").withZoneUTC();
    private final String _tableName;
    private final int _partitionGroupId;
    private final int _sequenceNumber;
    private final String _creationTime;
    private final String _segmentName;

    public LLCSegmentName(String segmentName) {
        String[] parts = StringUtils.splitByWholeSeparator((String)segmentName, (String)SEPARATOR);
        Preconditions.checkArgument((parts.length == 4 ? 1 : 0) != 0, (String)"Invalid LLC segment name: %s", (Object)segmentName);
        this._tableName = parts[0];
        this._partitionGroupId = Integer.parseInt(parts[1]);
        this._sequenceNumber = Integer.parseInt(parts[2]);
        this._creationTime = parts[3];
        this._segmentName = segmentName;
    }

    public LLCSegmentName(String tableName, int partitionGroupId, int sequenceNumber, long msSinceEpoch) {
        Preconditions.checkArgument((!tableName.contains(SEPARATOR) ? 1 : 0) != 0, (String)"Illegal table name: %s", (Object)tableName);
        this._tableName = tableName;
        this._partitionGroupId = partitionGroupId;
        this._sequenceNumber = sequenceNumber;
        this._creationTime = DATE_FORMATTER.print(msSinceEpoch);
        this._segmentName = tableName + SEPARATOR + partitionGroupId + SEPARATOR + sequenceNumber + SEPARATOR + this._creationTime;
    }

    private LLCSegmentName(String tableName, int partitionGroupId, int sequenceNumber, String creationTime, String segmentName) {
        this._tableName = tableName;
        this._partitionGroupId = partitionGroupId;
        this._sequenceNumber = sequenceNumber;
        this._creationTime = creationTime;
        this._segmentName = segmentName;
    }

    @Nullable
    public static LLCSegmentName of(String segmentName) {
        String[] parts = StringUtils.splitByWholeSeparator((String)segmentName, (String)SEPARATOR);
        if (parts.length != 4) {
            return null;
        }
        return new LLCSegmentName(parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2]), parts[3], segmentName);
    }

    public static boolean isLLCSegment(String segmentName) {
        int numSeparators = 0;
        int index = 0;
        while ((index = segmentName.indexOf(SEPARATOR, index)) != -1) {
            ++numSeparators;
            index += 2;
        }
        return numSeparators == 3;
    }

    @Deprecated
    public static boolean isLowLevelConsumerSegmentName(String segmentName) {
        return LLCSegmentName.isLLCSegment(segmentName);
    }

    public static int getSequenceNumber(String segmentName) {
        return Integer.parseInt(StringUtils.splitByWholeSeparator((String)segmentName, (String)SEPARATOR)[2]);
    }

    public String getTableName() {
        return this._tableName;
    }

    public int getPartitionGroupId() {
        return this._partitionGroupId;
    }

    public int getSequenceNumber() {
        return this._sequenceNumber;
    }

    public String getCreationTime() {
        return this._creationTime;
    }

    public long getCreationTimeMs() {
        DateTime dateTime = DATE_FORMATTER.parseDateTime(this._creationTime);
        return dateTime.getMillis();
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    @Override
    public int compareTo(LLCSegmentName other) {
        Preconditions.checkArgument((boolean)this._tableName.equals(other._tableName), (String)"Cannot compare segment names from different table: %s, %s", (Object)this._segmentName, (Object)other.getSegmentName());
        if (this._partitionGroupId != other._partitionGroupId) {
            return Integer.compare(this._partitionGroupId, other._partitionGroupId);
        }
        return Integer.compare(this._sequenceNumber, other._sequenceNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LLCSegmentName)) {
            return false;
        }
        LLCSegmentName that = (LLCSegmentName)o;
        return this._segmentName.equals(that._segmentName);
    }

    public int hashCode() {
        return Objects.hash(this._segmentName);
    }

    public String toString() {
        return this._segmentName;
    }
}

