/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.helix.zookeeper.datamodel.serializer.ZNRecordSerializer;
import org.apache.helix.zookeeper.impl.client.ZkClient;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.services.ServiceRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceStartableUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceStartableUtils.class);
    private static final String CLUSTER_CONFIG_ZK_PATH_TEMPLATE = "/%s/CONFIGS/CLUSTER/%s";
    private static final String PINOT_ALL_CONFIG_KEY_PREFIX = "pinot.all.";
    private static final String PINOT_INSTANCE_CONFIG_KEY_PREFIX_TEMPLATE = "pinot.%s.";
    protected static String _timeZone;

    private ServiceStartableUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyClusterConfig(PinotConfiguration instanceConfig, String zkAddress, String clusterName, ServiceRole serviceRole) {
        int zkClientSessionConfig = instanceConfig.getProperty("zk.client.session.timeout.ms", 30000);
        int zkClientConnectionTimeoutMs = instanceConfig.getProperty("zk.client.connection.timeout.ms", 60000);
        ZkClient zkClient = new ZkClient.Builder().setZkSerializer((ZkSerializer)new ZNRecordSerializer()).setZkServer(zkAddress).setConnectionTimeout(Integer.valueOf(zkClientConnectionTimeoutMs)).setSessionTimeout(Integer.valueOf(zkClientSessionConfig)).build();
        zkClient.waitUntilConnected((long)zkClientConnectionTimeoutMs, TimeUnit.MILLISECONDS);
        try {
            ZNRecord clusterConfigZNRecord = (ZNRecord)zkClient.readData(String.format(CLUSTER_CONFIG_ZK_PATH_TEMPLATE, clusterName, clusterName), true);
            if (clusterConfigZNRecord == null) {
                LOGGER.warn("Failed to find cluster config for cluster: {}, skipping applying cluster config", (Object)clusterName);
                ServiceStartableUtils.setupTimezone(instanceConfig);
                return;
            }
            Map clusterConfigs = clusterConfigZNRecord.getSimpleFields();
            String instanceConfigKeyPrefix = String.format(PINOT_INSTANCE_CONFIG_KEY_PREFIX_TEMPLATE, serviceRole.name().toLowerCase());
            for (Map.Entry entry : clusterConfigs.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (key.startsWith(PINOT_ALL_CONFIG_KEY_PREFIX)) {
                    String instanceConfigKey = instanceConfigKeyPrefix + key.substring(PINOT_ALL_CONFIG_KEY_PREFIX.length());
                    ServiceStartableUtils.addConfigIfNotExists(instanceConfig, instanceConfigKey, value);
                    continue;
                }
                ServiceStartableUtils.addConfigIfNotExists(instanceConfig, key, value);
            }
        }
        finally {
            zkClient.close();
        }
        ServiceStartableUtils.setupTimezone(instanceConfig);
    }

    private static void addConfigIfNotExists(PinotConfiguration instanceConfig, String key, String value) {
        if (!instanceConfig.containsKey(key)) {
            instanceConfig.setProperty(key, (Object)value);
        }
    }

    private static void setupTimezone(PinotConfiguration instanceConfig) {
        TimeZone localTimezone = TimeZone.getDefault();
        _timeZone = instanceConfig.getProperty("pinot.timezone", localTimezone.getID());
        System.setProperty("user.timezone", _timeZone);
        LOGGER.info("Timezone: {}", (Object)_timeZone);
    }
}

