/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class UploadedRealtimeSegmentName
implements Comparable<UploadedRealtimeSegmentName> {
    private static final String SEPARATOR = "__";
    private static final String DATE_FORMAT = "yyyyMMdd'T'HHmm'Z'";
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMdd'T'HHmm'Z'").withZoneUTC();
    private final String _prefix;
    private final String _tableName;
    private final int _partitionId;
    private final String _creationTime;
    private final String _segmentName;
    private final String _suffix;

    public UploadedRealtimeSegmentName(String segmentName) {
        try {
            String[] parts = StringUtils.splitByWholeSeparator((String)segmentName, (String)SEPARATOR);
            Preconditions.checkState((parts.length == 5 ? 1 : 0) != 0, (Object)"Uploaded segment name must be of the format {prefix}__{tableName}__{partitionId}__{creationTime}__{suffix}");
            this._prefix = parts[0];
            this._tableName = parts[1];
            this._partitionId = Integer.parseInt(parts[2]);
            this._creationTime = parts[3];
            this._suffix = parts[4];
            this._segmentName = segmentName;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid segment name: " + segmentName, e);
        }
    }

    public UploadedRealtimeSegmentName(String tableName, int partitionId, long msSinceEpoch, String prefix, String suffix) {
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)tableName) && !tableName.contains(SEPARATOR) && StringUtils.isNotBlank((CharSequence)prefix) && !prefix.contains(SEPARATOR) && StringUtils.isNotBlank((CharSequence)suffix) && !suffix.contains(SEPARATOR) ? 1 : 0) != 0, (Object)"tableName, prefix and suffix must be non-null, non-empty and not contain '__'");
        this._tableName = tableName;
        this._partitionId = partitionId;
        this._creationTime = DATE_FORMATTER.print(msSinceEpoch);
        this._prefix = prefix;
        this._suffix = suffix;
        this._segmentName = Joiner.on((String)SEPARATOR).join((Object)prefix, (Object)tableName, new Object[]{partitionId, this._creationTime, suffix});
    }

    public static boolean isUploadedRealtimeSegmentName(String segmentName) {
        int numSeparators = 0;
        int index = 0;
        while ((index = segmentName.indexOf(SEPARATOR, index)) != -1) {
            ++numSeparators;
            index += 2;
        }
        return numSeparators == 4;
    }

    @Nullable
    public static UploadedRealtimeSegmentName of(String segmentName) {
        try {
            return new UploadedRealtimeSegmentName(segmentName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTableName() {
        return this._tableName;
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public String getCreationTime() {
        return this._creationTime;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getSuffix() {
        return this._suffix;
    }

    @Override
    public int compareTo(UploadedRealtimeSegmentName other) {
        Preconditions.checkState((boolean)this._tableName.equals(other._tableName), (String)"Cannot compare segment names from different table: %s, %s", (Object)this._segmentName, (Object)other.getSegmentName());
        return this._segmentName.compareTo(other._segmentName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadedRealtimeSegmentName)) {
            return false;
        }
        UploadedRealtimeSegmentName that = (UploadedRealtimeSegmentName)o;
        return this._segmentName.equals(that._segmentName);
    }

    public int hashCode() {
        return Objects.hash(this._segmentName);
    }

    public String toString() {
        return this._segmentName;
    }
}

