/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.fetcher;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.pinot.common.auth.AuthConfig;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.utils.fetcher.HttpSegmentFetcher;
import org.apache.pinot.common.utils.fetcher.HttpsSegmentFetcher;
import org.apache.pinot.common.utils.fetcher.PinotFSSegmentFetcher;
import org.apache.pinot.common.utils.fetcher.SegmentFetcher;
import org.apache.pinot.spi.crypt.PinotCrypter;
import org.apache.pinot.spi.crypt.PinotCrypterFactory;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentFetcherFactory {
    public static final String SEGMENT_FETCHER_CLASS_KEY_SUFFIX = ".class";
    public static final String PROTOCOLS_KEY = "protocols";
    public static final String ENCODED_SUFFIX = ".enc";
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentFetcherFactory.class);
    private static final Map<String, SegmentFetcher> SEGMENT_FETCHER_MAP = new HashMap<String, SegmentFetcher>();
    private static final SegmentFetcher HTTP_SEGMENT_FETCHER = new HttpSegmentFetcher();
    private static final SegmentFetcher PINOT_FS_SEGMENT_FETCHER = new PinotFSSegmentFetcher();

    private SegmentFetcherFactory() {
    }

    public static void init(PinotConfiguration config) throws Exception {
        HTTP_SEGMENT_FETCHER.init(config);
        PINOT_FS_SEGMENT_FETCHER.init(config);
        List protocols = config.getProperty(PROTOCOLS_KEY, Collections.emptyList());
        for (String protocol : protocols) {
            SegmentFetcher segmentFetcher;
            String segmentFetcherClassName = config.getProperty(protocol + SEGMENT_FETCHER_CLASS_KEY_SUFFIX);
            if (segmentFetcherClassName == null) {
                LOGGER.info("Segment fetcher class is not configured for protocol: {}, using default", (Object)protocol);
                switch (protocol) {
                    case "http": {
                        segmentFetcher = new HttpSegmentFetcher();
                        break;
                    }
                    case "https": {
                        segmentFetcher = new HttpsSegmentFetcher();
                        break;
                    }
                    default: {
                        segmentFetcher = new PinotFSSegmentFetcher();
                        break;
                    }
                }
            } else {
                LOGGER.info("Creating segment fetcher for protocol: {} with class: {}", (Object)protocol, (Object)segmentFetcherClassName);
                segmentFetcher = (SegmentFetcher)Class.forName(segmentFetcherClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            PinotConfiguration subConfig = config.subset(protocol);
            Map subConfigMap = subConfig.toMap();
            AuthConfig authConfig = AuthProviderUtils.extractAuthConfig(config, "auth");
            AuthConfig subAuthConfig = AuthProviderUtils.extractAuthConfig(subConfig, "auth");
            if (subAuthConfig.getProperties().isEmpty() && !authConfig.getProperties().isEmpty()) {
                authConfig.getProperties().forEach((key, value) -> subConfigMap.put("auth." + key, value));
            }
            segmentFetcher.init(new PinotConfiguration(subConfigMap));
            SEGMENT_FETCHER_MAP.put(protocol, segmentFetcher);
        }
    }

    public static SegmentFetcher getSegmentFetcher(String protocol) {
        SegmentFetcher segmentFetcher = SEGMENT_FETCHER_MAP.get(protocol);
        if (segmentFetcher != null) {
            return segmentFetcher;
        }
        LOGGER.info("Segment fetcher is not configured for protocol: {}, using default", (Object)protocol);
        switch (protocol) {
            case "http": 
            case "https": {
                return HTTP_SEGMENT_FETCHER;
            }
        }
        return PINOT_FS_SEGMENT_FETCHER;
    }

    public static void fetchSegmentToLocal(URI uri, File dest) throws Exception {
        SegmentFetcherFactory.getSegmentFetcher(uri.getScheme()).fetchSegmentToLocal(uri, dest);
    }

    public static void fetchSegmentToLocal(String uri, File dest) throws Exception {
        SegmentFetcherFactory.fetchSegmentToLocal(new URI(uri), dest);
    }

    public static File fetchAndStreamUntarToLocal(URI uri, File tempRootDir, long maxStreamRateInByte, AtomicInteger attempts) throws Exception {
        return SegmentFetcherFactory.getSegmentFetcher(uri.getScheme()).fetchUntarSegmentToLocalStreamed(uri, tempRootDir, maxStreamRateInByte, attempts);
    }

    public static File fetchAndStreamUntarToLocal(String uri, File tempRootDir, long maxStreamRateInByte, AtomicInteger attempts) throws Exception {
        return SegmentFetcherFactory.fetchAndStreamUntarToLocal(new URI(uri), tempRootDir, maxStreamRateInByte, attempts);
    }

    public static void fetchAndDecryptSegmentToLocal(String uri, File dest, @Nullable String crypterName) throws Exception {
        if (crypterName == null) {
            SegmentFetcherFactory.fetchSegmentToLocal(uri, dest);
        } else {
            File tempDownloadedFile = new File(dest.getPath() + ENCODED_SUFFIX);
            SegmentFetcherFactory.fetchSegmentToLocal(uri, tempDownloadedFile);
            PinotCrypter crypter = PinotCrypterFactory.create((String)crypterName);
            crypter.decrypt(tempDownloadedFile, dest);
        }
    }

    public static void fetchAndDecryptSegmentToLocal(String segmentName, String scheme, Supplier<List<URI>> uriSupplier, File dest, @Nullable String crypterName) throws Exception {
        SegmentFetcher segmentFetcher = SegmentFetcherFactory.getSegmentFetcher(scheme);
        if (crypterName == null) {
            segmentFetcher.fetchSegmentToLocal(segmentName, uriSupplier, dest);
        } else {
            File tempDownloadedFile = new File(dest.getPath() + ENCODED_SUFFIX);
            segmentFetcher.fetchSegmentToLocal(segmentName, uriSupplier, tempDownloadedFile);
            PinotCrypter crypter = PinotCrypterFactory.create((String)crypterName);
            crypter.decrypt(tempDownloadedFile, dest);
        }
    }
}

