/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.http;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.pinot.common.auth.AuthProviderUtils;
import org.apache.pinot.common.exception.HttpErrorStatusException;
import org.apache.pinot.common.utils.SimpleHttpErrorInfo;
import org.apache.pinot.common.utils.SimpleHttpResponse;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.common.utils.http.HttpClientConfig;
import org.apache.pinot.common.utils.tls.TlsUtils;
import org.apache.pinot.spi.auth.AuthProvider;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClient.class);
    public static final int DEFAULT_SOCKET_TIMEOUT_MS = 600000;
    public static final int GET_REQUEST_SOCKET_TIMEOUT_MS = 5000;
    public static final int DELETE_REQUEST_SOCKET_TIMEOUT_MS = 10000;
    public static final String AUTH_HTTP_HEADER = "Authorization";
    public static final String JSON_CONTENT_TYPE = "application/json";
    private final CloseableHttpClient _httpClient;

    public HttpClient() {
        this(HttpClientConfig.DEFAULT_HTTP_CLIENT_CONFIG, null);
    }

    public HttpClient(@Nullable SSLContext sslContext) {
        this(HttpClientConfig.DEFAULT_HTTP_CLIENT_CONFIG, sslContext);
    }

    public HttpClient(HttpClientConfig httpClientConfig, @Nullable SSLContext sslContext) {
        SSLContext context = sslContext != null ? sslContext : TlsUtils.getSslContext();
        SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(context, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        this._httpClient = HttpClient.buildCloseableHttpClient(httpClientConfig, csf);
    }

    public static HttpClient getInstance() {
        return HttpClientHolder.HTTP_CLIENT;
    }

    public SimpleHttpResponse sendGetRequest(URI uri) throws IOException {
        return this.sendGetRequest(uri, null, null);
    }

    public SimpleHttpResponse sendGetRequest(URI uri, @Nullable Map<String, String> headers) throws IOException {
        return this.sendGetRequest(uri, headers, null);
    }

    public SimpleHttpResponse sendGetRequest(URI uri, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        RequestBuilder requestBuilder = RequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((RequestBuilder)requestBuilder).addHeader(arg_0));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        HttpClient.setTimeout(requestBuilder, 5000);
        return this.sendRequest(requestBuilder.build());
    }

    public SimpleHttpResponse sendDeleteRequest(URI uri) throws IOException {
        return this.sendDeleteRequest(uri, Collections.emptyMap());
    }

    public SimpleHttpResponse sendDeleteRequest(URI uri, @Nullable Map<String, String> headers) throws IOException {
        return this.sendDeleteRequest(uri, headers, null);
    }

    public SimpleHttpResponse sendDeleteRequest(URI uri, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        RequestBuilder requestBuilder = RequestBuilder.delete((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((RequestBuilder)requestBuilder).addHeader(arg_0));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        HttpClient.setTimeout(requestBuilder, 10000);
        return this.sendRequest(requestBuilder.build());
    }

    public SimpleHttpResponse sendPostRequest(URI uri, @Nullable HttpEntity payload, @Nullable Map<String, String> headers) throws IOException {
        return this.sendPostRequest(uri, payload, headers, null);
    }

    public SimpleHttpResponse sendPostRequest(URI uri, @Nullable HttpEntity payload, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        RequestBuilder requestBuilder = RequestBuilder.post((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        if (payload != null) {
            requestBuilder.setEntity(payload);
        }
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((RequestBuilder)requestBuilder).addHeader(arg_0));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        HttpClient.setTimeout(requestBuilder, 600000);
        return this.sendRequest(requestBuilder.build());
    }

    public SimpleHttpResponse sendPutRequest(URI uri, @Nullable HttpEntity payload, @Nullable Map<String, String> headers) throws IOException {
        return this.sendPutRequest(uri, payload, headers, null);
    }

    public SimpleHttpResponse sendPutRequest(URI uri, @Nullable HttpEntity payload, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        RequestBuilder requestBuilder = RequestBuilder.put((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        if (payload != null) {
            requestBuilder.setEntity(payload);
        }
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((RequestBuilder)requestBuilder).addHeader(arg_0));
        if (MapUtils.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.addHeader(header.getKey(), header.getValue());
            }
        }
        HttpClient.setTimeout(requestBuilder, 10000);
        return this.sendRequest(requestBuilder.build());
    }

    public SimpleHttpResponse sendJsonPostRequest(URI uri, @Nullable String jsonRequestBody) throws IOException {
        return this.sendJsonPostRequest(uri, jsonRequestBody, null);
    }

    public SimpleHttpResponse sendJsonPostRequest(URI uri, @Nullable String jsonRequestBody, @Nullable Map<String, String> headers) throws IOException {
        return this.sendJsonPostRequest(uri, jsonRequestBody, headers, null);
    }

    public SimpleHttpResponse sendJsonPostRequest(URI uri, @Nullable String jsonRequestBody, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        HashMap<String, String> headersWrapper = MapUtils.isEmpty(headers) ? new HashMap<String, String>() : new HashMap<String, String>(headers);
        headersWrapper.put("Content-Type", JSON_CONTENT_TYPE);
        StringEntity entity = jsonRequestBody == null ? null : new StringEntity(jsonRequestBody, ContentType.APPLICATION_JSON);
        return this.sendPostRequest(uri, (HttpEntity)entity, headers, authProvider);
    }

    public SimpleHttpResponse sendJsonPutRequest(URI uri, @Nullable String jsonRequestBody) throws IOException {
        return this.sendJsonPutRequest(uri, jsonRequestBody, null);
    }

    public SimpleHttpResponse sendJsonPutRequest(URI uri, @Nullable String jsonRequestBody, @Nullable Map<String, String> headers) throws IOException {
        return this.sendJsonPutRequest(uri, jsonRequestBody, headers, null);
    }

    public SimpleHttpResponse sendJsonPutRequest(URI uri, @Nullable String jsonRequestBody, @Nullable Map<String, String> headers, @Nullable AuthProvider authProvider) throws IOException {
        HashMap<String, String> headersWrapper = MapUtils.isEmpty(headers) ? new HashMap<String, String>() : new HashMap<String, String>(headers);
        headersWrapper.put("Content-Type", JSON_CONTENT_TYPE);
        StringEntity entity = jsonRequestBody == null ? null : new StringEntity(jsonRequestBody, ContentType.APPLICATION_JSON);
        return this.sendPutRequest(uri, (HttpEntity)entity, headersWrapper, authProvider);
    }

    public SimpleHttpResponse sendRequest(HttpUriRequest request) throws IOException {
        try (CloseableHttpResponse response = this._httpClient.execute(request);){
            SimpleHttpResponse simpleHttpResponse;
            int statusCode;
            if (response.containsHeader("Pinot-Controller-Host")) {
                String controllerHost = response.getFirstHeader("Pinot-Controller-Host").getValue();
                String controllerVersion = response.getFirstHeader("Pinot-Controller-Version").getValue();
                LOGGER.info("Sending request: {} to controller: {}, version: {}", new Object[]{request.getURI(), controllerHost, controllerVersion});
            }
            if ((statusCode = response.getStatusLine().getStatusCode()) >= 300) {
                simpleHttpResponse = new SimpleHttpResponse(statusCode, HttpClient.getErrorMessage(request, response));
                return simpleHttpResponse;
            }
            simpleHttpResponse = new SimpleHttpResponse(statusCode, EntityUtils.toString((HttpEntity)response.getEntity()));
            return simpleHttpResponse;
        }
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
        return this._httpClient.execute(request);
    }

    public SimpleHttpResponse sendMultipartPostRequest(String url, String body) throws IOException {
        return this.sendMultipartPostRequest(url, body, null);
    }

    public SimpleHttpResponse sendMultipartPostRequest(String url, String body, @Nullable Map<String, String> headers) throws IOException {
        HttpPost post = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("body", body);
        post.setEntity(builder.build());
        if (MapUtils.isNotEmpty(headers)) {
            for (String key : headers.keySet()) {
                post.addHeader(key, headers.get(key));
            }
        }
        try (CloseableHttpResponse response = this._httpClient.execute((HttpUriRequest)post);){
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode >= 300) {
                SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, HttpClient.getErrorMessage((HttpUriRequest)post, response));
                return simpleHttpResponse;
            }
            SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, EntityUtils.toString((HttpEntity)response.getEntity()));
            return simpleHttpResponse;
        }
    }

    public SimpleHttpResponse sendMultipartPutRequest(String url, String body) throws IOException {
        return this.sendMultipartPutRequest(url, body, null);
    }

    public SimpleHttpResponse sendMultipartPutRequest(String url, String body, @Nullable Map<String, String> headers) throws IOException {
        HttpPut put = new HttpPut(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody("body", body);
        put.setEntity(builder.build());
        if (MapUtils.isNotEmpty(headers)) {
            for (String key : headers.keySet()) {
                put.addHeader(key, headers.get(key));
            }
        }
        try (CloseableHttpResponse response = this._httpClient.execute((HttpUriRequest)put);){
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode >= 300) {
                SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, HttpClient.getErrorMessage((HttpUriRequest)put, response));
                return simpleHttpResponse;
            }
            SimpleHttpResponse simpleHttpResponse = new SimpleHttpResponse(statusCode, EntityUtils.toString((HttpEntity)response.getEntity()));
            return simpleHttpResponse;
        }
    }

    public int downloadFile(URI uri, int socketTimeoutMs, File dest, AuthProvider authProvider, List<Header> httpHeaders) throws IOException, HttpErrorStatusException {
        HttpUriRequest request = HttpClient.getDownloadFileRequest(uri, socketTimeoutMs, authProvider, httpHeaders);
        try (CloseableHttpResponse response = this._httpClient.execute(request);){
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode >= 300) {
                throw new HttpErrorStatusException(HttpClient.getErrorMessage(request, response), statusCode);
            }
            HttpEntity entity = response.getEntity();
            try (InputStream inputStream = response.getEntity().getContent();
                 BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(dest));){
                IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            }
            long contentLength = entity.getContentLength();
            if (contentLength >= 0L) {
                long fileLength = dest.length();
                Preconditions.checkState((fileLength == contentLength ? 1 : 0) != 0, (Object)String.format("While downloading file with uri: %s, file length: %d does not match content length: %d", uri, fileLength, contentLength));
            }
            int n = statusCode;
            return n;
        }
    }

    public File downloadUntarFileStreamed(URI uri, int socketTimeoutMs, File dest, AuthProvider authProvider, List<Header> httpHeaders, long maxStreamRateInByte) throws IOException, HttpErrorStatusException {
        HttpUriRequest request = HttpClient.getDownloadFileRequest(uri, socketTimeoutMs, authProvider, httpHeaders);
        try (CloseableHttpResponse response = this._httpClient.execute(request);){
            File ret;
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode >= 300) {
                throw new HttpErrorStatusException(HttpClient.getErrorMessage(request, response), statusCode);
            }
            try (InputStream inputStream = response.getEntity().getContent();){
                ret = TarGzCompressionUtils.untarWithRateLimiter(inputStream, dest, maxStreamRateInByte).get(0);
            }
            LOGGER.info("Downloaded from: {} to: {} with rate limiter; Response status code: {}", new Object[]{uri, dest, statusCode});
            File file = ret;
            return file;
        }
    }

    public static SimpleHttpResponse wrapAndThrowHttpException(SimpleHttpResponse resp) throws HttpErrorStatusException {
        if (resp.getStatusCode() >= 300) {
            throw new HttpErrorStatusException(resp.getResponse(), resp.getStatusCode());
        }
        return resp;
    }

    public static void addHeadersAndParameters(RequestBuilder requestBuilder, @Nullable List<Header> headers, @Nullable List<NameValuePair> parameters) {
        if (headers != null) {
            for (Header header : headers) {
                requestBuilder.addHeader(header);
            }
        }
        if (parameters != null) {
            for (NameValuePair parameter : parameters) {
                requestBuilder.addParameter(parameter);
            }
        }
    }

    public static void setTimeout(RequestBuilder requestBuilder, int socketTimeoutMs) {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(socketTimeoutMs).build();
        requestBuilder.setConfig(requestConfig);
    }

    private static CloseableHttpClient buildCloseableHttpClient(HttpClientConfig httpClientConfig, SSLConnectionSocketFactory csf) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)csf);
        if (httpClientConfig.getMaxConnTotal() > 0) {
            httpClientBuilder.setMaxConnTotal(httpClientConfig.getMaxConnTotal());
        }
        if (httpClientConfig.getMaxConnPerRoute() > 0) {
            httpClientBuilder.setMaxConnPerRoute(httpClientConfig.getMaxConnPerRoute());
        }
        if (httpClientConfig.isDisableDefaultUserAgent()) {
            httpClientBuilder.disableDefaultUserAgent();
        }
        return httpClientBuilder.build();
    }

    private static String getErrorMessage(HttpUriRequest request, CloseableHttpResponse response) {
        String reason;
        String controllerHost = null;
        String controllerVersion = null;
        if (response.containsHeader("Pinot-Controller-Host")) {
            controllerHost = response.getFirstHeader("Pinot-Controller-Host").getValue();
            controllerVersion = response.getFirstHeader("Pinot-Controller-Version").getValue();
        }
        StatusLine statusLine = response.getStatusLine();
        try {
            String entityStr = EntityUtils.toString((HttpEntity)response.getEntity());
            try {
                reason = ((SimpleHttpErrorInfo)JsonUtils.stringToObject((String)entityStr, SimpleHttpErrorInfo.class)).getError();
            }
            catch (Exception e) {
                reason = entityStr;
            }
        }
        catch (Exception e) {
            reason = String.format("Failed to get a reason, exception: %s", e);
        }
        String errorMessage = String.format("Got error status code: %d (%s) with reason: \"%s\" while sending request: %s", statusLine.getStatusCode(), statusLine.getReasonPhrase(), reason, request.getURI());
        if (controllerHost != null) {
            errorMessage = String.format("%s to controller: %s, version: %s", errorMessage, controllerHost, controllerVersion);
        }
        return errorMessage;
    }

    private static HttpUriRequest getDownloadFileRequest(URI uri, int socketTimeoutMs, AuthProvider authProvider, List<Header> httpHeaders) {
        RequestBuilder requestBuilder = RequestBuilder.get((URI)uri).setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        AuthProviderUtils.toRequestHeaders(authProvider).forEach(arg_0 -> ((RequestBuilder)requestBuilder).addHeader(arg_0));
        HttpClient.setTimeout(requestBuilder, socketTimeoutMs);
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            String encoded = Base64.encodeBase64String((byte[])userInfo.getBytes(StandardCharsets.UTF_8));
            String authHeader = "Basic " + encoded;
            requestBuilder.addHeader(AUTH_HTTP_HEADER, authHeader);
        }
        if (httpHeaders != null && !httpHeaders.isEmpty()) {
            for (Header header : httpHeaders) {
                requestBuilder.addHeader(header);
            }
        }
        return requestBuilder.build();
    }

    @Override
    public void close() throws IOException {
        this._httpClient.close();
    }

    private static final class HttpClientHolder {
        static final HttpClient HTTP_CLIENT = new HttpClient(HttpClientConfig.DEFAULT_HTTP_CLIENT_CONFIG, TlsUtils.getSslContext());

        private HttpClientHolder() {
        }
    }
}

