/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.http;

import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.env.PinotConfiguration;

public class HttpClientConfig {
    public static final HttpClientConfig DEFAULT_HTTP_CLIENT_CONFIG = HttpClientConfig.newBuilder().build();
    protected static final String MAX_CONNS_CONFIG_NAME = "http.client.maxConnTotal";
    protected static final String MAX_CONNS_PER_ROUTE_CONFIG_NAME = "http.client.maxConnPerRoute";
    protected static final String DISABLE_DEFAULT_USER_AGENT_CONFIG_NAME = "http.client.disableDefaultUserAgent";
    private final int _maxConnTotal;
    private final int _maxConnPerRoute;
    private final boolean _disableDefaultUserAgent;

    private HttpClientConfig(int maxConnTotal, int maxConnPerRoute, boolean disableDefaultUserAgent) {
        this._maxConnTotal = maxConnTotal;
        this._maxConnPerRoute = maxConnPerRoute;
        this._disableDefaultUserAgent = disableDefaultUserAgent;
    }

    public int getMaxConnTotal() {
        return this._maxConnTotal;
    }

    public int getMaxConnPerRoute() {
        return this._maxConnPerRoute;
    }

    public boolean isDisableDefaultUserAgent() {
        return this._disableDefaultUserAgent;
    }

    public static Builder newBuilder(PinotConfiguration pinotConfiguration) {
        String maxConnsPerRoute;
        Builder builder = new Builder();
        String maxConns = pinotConfiguration.getProperty(MAX_CONNS_CONFIG_NAME);
        if (StringUtils.isNotEmpty((CharSequence)maxConns)) {
            builder.withMaxConns(Integer.parseInt(maxConns));
        }
        if (StringUtils.isNotEmpty((CharSequence)(maxConnsPerRoute = pinotConfiguration.getProperty(MAX_CONNS_PER_ROUTE_CONFIG_NAME)))) {
            builder.withMaxConnsPerRoute(Integer.parseInt(maxConnsPerRoute));
        }
        boolean disableDefaultUserAgent = pinotConfiguration.getProperty(DISABLE_DEFAULT_USER_AGENT_CONFIG_NAME, false);
        builder.withDisableDefaultUserAgent(disableDefaultUserAgent);
        return builder;
    }

    private static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private int _maxConns = -1;
        private int _maxConnsPerRoute = -1;
        private boolean _disableDefaultUserAgent = false;

        private Builder() {
        }

        public Builder withMaxConns(int maxConns) {
            this._maxConns = maxConns;
            return this;
        }

        public Builder withMaxConnsPerRoute(int maxConnsPerRoute) {
            this._maxConnsPerRoute = maxConnsPerRoute;
            return this;
        }

        public Builder withDisableDefaultUserAgent(boolean disableDefaultUserAgent) {
            this._disableDefaultUserAgent = disableDefaultUserAgent;
            return this;
        }

        public HttpClientConfig build() {
            return new HttpClientConfig(this._maxConns, this._maxConnsPerRoute, this._disableDefaultUserAgent);
        }
    }
}

