/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.version;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotVersion {
    private static final Logger LOGGER;
    public static final String VERSION;
    public static final String VERSION_METRIC_NAME;

    private PinotVersion() {
    }

    static {
        String version;
        LOGGER = LoggerFactory.getLogger(PinotVersion.class);
        ClassLoader loader = PinotVersion.class.getClassLoader();
        try (InputStream versionResource = loader.getResourceAsStream("pinot-version.properties");){
            Properties properties = new Properties();
            properties.load(versionResource);
            version = String.valueOf(properties.get("pinot.version"));
        }
        catch (IOException e) {
            LOGGER.error("Could not load version properties; setting version to UNKNOWN.", (Throwable)e);
            version = "UNKNOWN";
        }
        if (version.equals("${project.version}")) {
            VERSION = "UNKNOWN";
            LOGGER.warn("Using UNKNOWN version properties because project.version was not resolved during build.");
        } else {
            VERSION = version;
        }
        VERSION_METRIC_NAME = VERSION.replace('.', '_').replace('-', '_');
    }
}

