/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlSelectKeyword;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.fun.SqlBetweenOperator;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlLikeOperator;
import org.apache.calcite.sql.parser.SqlAbstractParserImpl;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.common.request.DataSource;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.Join;
import org.apache.pinot.common.request.JoinType;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.sql.FilterKind;
import org.apache.pinot.sql.parsers.ParserUtils;
import org.apache.pinot.sql.parsers.PinotSqlType;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.SqlNodeAndOptions;
import org.apache.pinot.sql.parsers.parser.SqlInsertFromFile;
import org.apache.pinot.sql.parsers.parser.SqlParserImpl;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalciteSqlParser {
    public static final String ASC = "asc";
    public static final String DESC = "desc";
    public static final String NULLS_LAST = "nullslast";
    public static final String NULLS_FIRST = "nullsfirst";
    public static final ImmutableSet<String> ORDER_BY_FUNCTIONS = ImmutableSet.of((Object)"asc", (Object)"desc", (Object)"nullslast", (Object)"nullsfirst");
    public static final List<QueryRewriter> QUERY_REWRITERS = new ArrayList<QueryRewriter>(QueryRewriterFactory.getQueryRewriters());
    private static final Logger LOGGER = LoggerFactory.getLogger(CalciteSqlParser.class);
    private static final Pattern OPTIONS_REGEX_PATTEN = Pattern.compile("\\s*option\\s*\\(([^)]+)\\)\\s*;?\\s*\\Z", 2);

    private CalciteSqlParser() {
    }

    public static SqlNodeAndOptions compileToSqlNodeAndOptions(String sql) throws SqlCompilationException {
        long parseStartTimeNs = System.nanoTime();
        List<String> options = CalciteSqlParser.extractOptionsFromSql(sql);
        if (!options.isEmpty()) {
            sql = CalciteSqlParser.removeOptionsFromSql(sql);
        }
        StringReader inStream = new StringReader(sql);
        try {
            SqlParserImpl sqlParser = CalciteSqlParser.newSqlParser(inStream);
            SqlNodeList sqlNodeList = sqlParser.parseSqlStmtList();
            SqlNodeAndOptions sqlNodeAndOptions = CalciteSqlParser.extractSqlNodeAndOptions(sqlNodeList);
            if (!options.isEmpty()) {
                sqlNodeAndOptions.setExtraOptions(CalciteSqlParser.extractOptionsMap(options));
            }
            sqlNodeAndOptions.setParseTimeNs(System.nanoTime() - parseStartTimeNs);
            SqlNodeAndOptions sqlNodeAndOptions2 = sqlNodeAndOptions;
            inStream.close();
            return sqlNodeAndOptions2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new SqlCompilationException("Caught exception while parsing query: " + sql, e);
            }
        }
    }

    private static SqlNodeAndOptions extractSqlNodeAndOptions(SqlNodeList sqlNodeList) {
        PinotSqlType sqlType = null;
        SqlNode statementNode = null;
        HashMap<String, String> options = new HashMap<String, String>();
        for (SqlNode sqlNode : sqlNodeList) {
            if (sqlNode instanceof SqlInsertFromFile) {
                if (sqlType == null) {
                    sqlType = PinotSqlType.DML;
                    statementNode = sqlNode;
                    continue;
                }
                throw new SqlCompilationException("SqlNode with executable statement already exist with type: " + sqlType);
            }
            if (sqlNode instanceof SqlSetOption) {
                List operandList = ((SqlSetOption)sqlNode).getOperandList();
                SqlIdentifier key = (SqlIdentifier)operandList.get(1);
                SqlLiteral value = (SqlLiteral)operandList.get(2);
                options.put(key.getSimple(), value.toValue());
                continue;
            }
            if (sqlType == null) {
                sqlType = PinotSqlType.DQL;
                statementNode = sqlNode;
                continue;
            }
            throw new SqlCompilationException("SqlNode with executable statement already exist with type: " + sqlType);
        }
        if (sqlType == null) {
            throw new SqlCompilationException("SqlNode with executable statement not found!");
        }
        return new SqlNodeAndOptions(statementNode, sqlType, QueryOptionsUtils.resolveCaseInsensitiveOptions(options));
    }

    public static PinotQuery compileToPinotQuery(String sql) throws SqlCompilationException {
        return CalciteSqlParser.compileToPinotQuery(CalciteSqlParser.compileToSqlNodeAndOptions(sql));
    }

    public static PinotQuery compileToPinotQuery(SqlNodeAndOptions sqlNodeAndOptions) {
        PinotQuery pinotQuery = CalciteSqlParser.compileSqlNodeToPinotQuery(sqlNodeAndOptions.getSqlNode());
        pinotQuery.setQueryOptions(sqlNodeAndOptions.getOptions());
        return pinotQuery;
    }

    static void validate(PinotQuery pinotQuery) throws SqlCompilationException {
        CalciteSqlParser.validateGroupByClause(pinotQuery);
        CalciteSqlParser.validateDistinctQuery(pinotQuery);
        if (pinotQuery.isSetFilterExpression()) {
            CalciteSqlParser.validateFilter(pinotQuery.getFilterExpression());
        }
    }

    private static void validateGroupByClause(PinotQuery pinotQuery) throws SqlCompilationException {
        boolean hasGroupByClause = pinotQuery.getGroupByList() != null;
        HashSet<Expression> groupByExprs = hasGroupByClause ? new HashSet<Expression>(pinotQuery.getGroupByList()) : null;
        int aggregateExprCount = 0;
        for (Expression selectExpression : pinotQuery.getSelectList()) {
            if (CalciteSqlParser.isAggregateExpression(selectExpression)) {
                ++aggregateExprCount;
                continue;
            }
            if (!hasGroupByClause || !CalciteSqlParser.expressionOutsideGroupByList(selectExpression, groupByExprs)) continue;
            throw new SqlCompilationException("'" + RequestUtils.prettyPrint(selectExpression) + "' should appear in GROUP BY clause.");
        }
        int nonAggregateExprCount = pinotQuery.getSelectListSize() - aggregateExprCount;
        if (!hasGroupByClause && aggregateExprCount > 0 && nonAggregateExprCount > 0) {
            throw new SqlCompilationException("Columns and Aggregate functions can't co-exist without GROUP BY clause");
        }
        if (hasGroupByClause) {
            for (Expression groupByExpression : pinotQuery.getGroupByList()) {
                if (!CalciteSqlParser.isAggregateExpression(groupByExpression)) continue;
                throw new SqlCompilationException("Aggregate expression '" + RequestUtils.prettyPrint(groupByExpression) + "' is not allowed in GROUP BY clause.");
            }
        }
    }

    private static void validateDistinctQuery(PinotQuery pinotQuery) throws SqlCompilationException {
        Function function;
        List<Expression> selectList = pinotQuery.getSelectList();
        if (selectList.size() == 1 && (function = selectList.get(0).getFunctionCall()) != null && function.getOperator().equals("distinct")) {
            if (CollectionUtils.isNotEmpty(pinotQuery.getGroupByList())) {
                throw new IllegalStateException("DISTINCT with GROUP BY is currently not supported");
            }
            if (pinotQuery.getLimit() <= 0) {
                throw new IllegalStateException("DISTINCT must have positive LIMIT");
            }
            List<Expression> orderByList = pinotQuery.getOrderByList();
            if (orderByList != null) {
                List<Expression> distinctExpressions = CalciteSqlParser.getAliasLeftExpressionsFromDistinctExpression(function);
                for (Expression orderByExpression : orderByList) {
                    if (distinctExpressions.contains(CalciteSqlParser.removeOrderByFunctions(orderByExpression))) continue;
                    throw new IllegalStateException("ORDER-BY columns should be included in the DISTINCT columns");
                }
            }
        }
    }

    private static void validateFilter(Expression filterExpression) {
        if (!filterExpression.isSetFunctionCall()) {
            return;
        }
        String operator = filterExpression.getFunctionCall().getOperator();
        if (operator.equals(FilterKind.AND.name()) || operator.equals(FilterKind.OR.name()) || operator.equals(FilterKind.NOT.name())) {
            for (Expression filter : filterExpression.getFunctionCall().getOperands()) {
                CalciteSqlParser.validateFilter(filter);
            }
        } else if (operator.equals(FilterKind.VECTOR_SIMILARITY.name())) {
            Expression topK;
            Expression vectorIdentifier = filterExpression.getFunctionCall().getOperands().get(0);
            if (!vectorIdentifier.isSetIdentifier()) {
                throw new IllegalStateException("The first argument of VECTOR_SIMILARITY must be an identifier of float array, the signature is VECTOR_SIMILARITY(float[], float[], int).");
            }
            Expression vectorLiteral = filterExpression.getFunctionCall().getOperands().get(1);
            if (vectorLiteral.isSetFunctionCall() && !vectorLiteral.getFunctionCall().getOperator().equalsIgnoreCase("arrayvalueconstructor") || vectorLiteral.isSetLiteral() && !vectorLiteral.getLiteral().isSetFloatArrayValue() && !vectorLiteral.getLiteral().isSetDoubleArrayValue()) {
                throw new IllegalStateException("The second argument of VECTOR_SIMILARITY must be a float/double array literal, the signature is VECTOR_SIMILARITY(float[], float[], int)");
            }
            if (filterExpression.getFunctionCall().getOperands().size() == 3 && !(topK = filterExpression.getFunctionCall().getOperands().get(2)).isSetLiteral()) {
                throw new IllegalStateException("The third argument of VECTOR_SIMILARITY must be an integer literal, the signature is VECTOR_SIMILARITY(float[], float[], int)");
            }
        } else {
            List<Expression> operands = filterExpression.getFunctionCall().getOperands();
            for (int i = 1; i < operands.size(); ++i) {
                if (!operands.get(i).getLiteral().isSetNullValue()) continue;
                throw new IllegalStateException(String.format("Using NULL in %s filter is not supported", operator));
            }
        }
    }

    private static List<Expression> getAliasLeftExpressionsFromDistinctExpression(Function function) {
        List<Expression> operands = function.getOperands();
        ArrayList<Expression> expressions = new ArrayList<Expression>(operands.size());
        for (Expression operand : operands) {
            if (CalciteSqlParser.isAsFunction(operand)) {
                expressions.add(operand.getFunctionCall().getOperands().get(0));
                continue;
            }
            expressions.add(operand);
        }
        return expressions;
    }

    private static boolean expressionOutsideGroupByList(Expression expr, Set<Expression> groupByExprs) {
        if (expr.getType() == ExpressionType.LITERAL || CalciteSqlParser.isAggregateExpression(expr) || groupByExprs.contains(expr)) {
            return false;
        }
        Function function = expr.getFunctionCall();
        if (function != null) {
            if (function.getOperator().equals("as")) {
                return CalciteSqlParser.expressionOutsideGroupByList(function.getOperands().get(0), groupByExprs);
            }
            return function.getOperands().stream().anyMatch(e -> CalciteSqlParser.expressionOutsideGroupByList(e, groupByExprs));
        }
        return true;
    }

    public static boolean isAggregateExpression(Expression expression) {
        Function functionCall = expression.getFunctionCall();
        if (functionCall != null) {
            String operator = functionCall.getOperator();
            if (AggregationFunctionType.isAggregationFunction((String)operator)) {
                return true;
            }
            if (functionCall.getOperandsSize() > 0) {
                for (Expression operand : functionCall.getOperands()) {
                    if (!CalciteSqlParser.isAggregateExpression(operand)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isAsFunction(Expression expression) {
        Function function = expression.getFunctionCall();
        return function != null && function.getOperator().equals("as");
    }

    public static Set<String> extractIdentifiers(List<Expression> expressions, boolean excludeAs) {
        HashSet<String> identifiers = new HashSet<String>();
        for (Expression expression : expressions) {
            Identifier identifier = expression.getIdentifier();
            if (identifier != null) {
                identifiers.add(identifier.getName());
                continue;
            }
            Function function = expression.getFunctionCall();
            if (function == null) continue;
            if (excludeAs && function.getOperator().equals("as")) {
                identifiers.addAll(CalciteSqlParser.extractIdentifiers(List.of(function.getOperands().get(0)), true));
                continue;
            }
            identifiers.addAll(CalciteSqlParser.extractIdentifiers(function.getOperands(), excludeAs));
        }
        return identifiers;
    }

    public static Expression compileToExpression(String expression) {
        SqlNode sqlNode;
        try (StringReader inStream = new StringReader(expression);){
            SqlParserImpl sqlParser = CalciteSqlParser.newSqlParser(inStream);
            sqlNode = sqlParser.parseSqlExpressionEof();
        }
        catch (Throwable e) {
            throw new SqlCompilationException("Caught exception while parsing expression: " + expression, e);
        }
        return CalciteSqlParser.toExpression(sqlNode);
    }

    @VisibleForTesting
    static SqlParserImpl newSqlParser(StringReader inStream) {
        SqlParserImpl sqlParser = new SqlParserImpl(inStream);
        sqlParser.switchTo(SqlAbstractParserImpl.LexicalState.DQID);
        sqlParser.setConformance((SqlConformance)SqlConformanceEnum.BABEL);
        sqlParser.setTabSize(1);
        sqlParser.setQuotedCasing(Casing.UNCHANGED);
        sqlParser.setUnquotedCasing(Casing.UNCHANGED);
        sqlParser.setIdentifierMaxLength(128);
        return sqlParser;
    }

    public static PinotQuery compileSqlNodeToPinotQuery(SqlNode sqlNode) {
        SqlNode offsetNode;
        SqlNode limitNode;
        SqlNodeList orderByNodeList;
        SqlNode havingNode;
        SqlNodeList groupByNodeList;
        SqlNode whereNode;
        SqlSelect selectNode;
        PinotQuery pinotQuery = new PinotQuery();
        if (sqlNode instanceof SqlExplain) {
            sqlNode = ((SqlExplain)sqlNode).getExplicandum();
            pinotQuery.setExplain(true);
        }
        if (sqlNode instanceof SqlOrderBy) {
            SqlOrderBy orderByNode = (SqlOrderBy)sqlNode;
            selectNode = (SqlSelect)orderByNode.query;
            selectNode.setOrderBy(orderByNode.orderList);
            selectNode.setFetch(orderByNode.fetch);
            selectNode.setOffset(orderByNode.offset);
        } else {
            selectNode = (SqlSelect)sqlNode;
        }
        if (selectNode.getModifierNode(SqlSelectKeyword.DISTINCT) != null) {
            if (selectNode.getGroup() != null) {
                throw new SqlCompilationException("DISTINCT with GROUP BY is not supported");
            }
            pinotQuery.setSelectList(CalciteSqlParser.convertDistinctSelectList(selectNode.getSelectList()));
        } else {
            pinotQuery.setSelectList(CalciteSqlParser.convertSelectList(selectNode.getSelectList()));
        }
        SqlNode fromNode = selectNode.getFrom();
        if (fromNode != null) {
            pinotQuery.setDataSource(CalciteSqlParser.compileToDataSource(fromNode));
        }
        if ((whereNode = selectNode.getWhere()) != null) {
            pinotQuery.setFilterExpression(CalciteSqlParser.toExpression(whereNode));
        }
        if ((groupByNodeList = selectNode.getGroup()) != null) {
            pinotQuery.setGroupByList(CalciteSqlParser.convertSelectList(groupByNodeList));
        }
        if ((havingNode = selectNode.getHaving()) != null) {
            pinotQuery.setHavingExpression(CalciteSqlParser.toExpression(havingNode));
        }
        if ((orderByNodeList = selectNode.getOrderList()) != null) {
            pinotQuery.setOrderByList(CalciteSqlParser.convertOrderByList(orderByNodeList));
        }
        if ((limitNode = selectNode.getFetch()) != null) {
            pinotQuery.setLimit(((SqlNumericLiteral)limitNode).intValue(false));
        }
        if ((offsetNode = selectNode.getOffset()) != null) {
            pinotQuery.setOffset(((SqlNumericLiteral)offsetNode).intValue(false));
        }
        CalciteSqlParser.queryRewrite(pinotQuery);
        return pinotQuery;
    }

    private static DataSource compileToDataSource(SqlNode sqlNode) {
        DataSource dataSource = new DataSource();
        switch (sqlNode.getKind()) {
            case IDENTIFIER: {
                dataSource.setTableName(sqlNode.toString());
                break;
            }
            case AS: {
                List operandList = ((SqlBasicCall)sqlNode).getOperandList();
                dataSource.setSubquery(CalciteSqlParser.compileSqlNodeToPinotQuery((SqlNode)operandList.get(0)));
                dataSource.setTableName(((SqlNode)operandList.get(1)).toString());
                break;
            }
            case SELECT: 
            case ORDER_BY: {
                dataSource.setSubquery(CalciteSqlParser.compileSqlNodeToPinotQuery(sqlNode));
                break;
            }
            case JOIN: {
                dataSource.setJoin(CalciteSqlParser.compileToJoin((SqlJoin)sqlNode));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported SQL node kind as DataSource: " + sqlNode.getKind());
            }
        }
        return dataSource;
    }

    private static Join compileToJoin(SqlJoin sqlJoin) {
        Join join = new Join();
        switch (sqlJoin.getJoinType()) {
            case COMMA: 
            case INNER: {
                join.setType(JoinType.INNER);
                break;
            }
            case LEFT: {
                join.setType(JoinType.LEFT);
                break;
            }
            case RIGHT: {
                join.setType(JoinType.RIGHT);
                break;
            }
            case FULL: {
                join.setType(JoinType.FULL);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported join type: " + sqlJoin.getJoinType());
            }
        }
        join.setLeft(CalciteSqlParser.compileToDataSource(sqlJoin.getLeft()));
        join.setRight(CalciteSqlParser.compileToDataSource(sqlJoin.getRight()));
        switch (sqlJoin.getConditionType()) {
            case ON: {
                join.setCondition(CalciteSqlParser.toExpression(sqlJoin.getCondition()));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported join condition type: " + sqlJoin.getConditionType());
            }
        }
        return join;
    }

    private static void queryRewrite(PinotQuery pinotQuery) {
        for (QueryRewriter queryRewriter : QUERY_REWRITERS) {
            pinotQuery = queryRewriter.rewrite(pinotQuery);
        }
        CalciteSqlParser.validate(pinotQuery);
    }

    @Deprecated
    private static List<String> extractOptionsFromSql(String sql) {
        ArrayList<String> results = new ArrayList<String>();
        Matcher matcher = OPTIONS_REGEX_PATTEN.matcher(sql);
        while (matcher.find()) {
            results.add(matcher.group(1));
        }
        return results;
    }

    @Deprecated
    private static String removeOptionsFromSql(String sql) {
        Matcher matcher = OPTIONS_REGEX_PATTEN.matcher(sql);
        return matcher.replaceAll("");
    }

    @Deprecated
    private static Map<String, String> extractOptionsMap(List<String> optionsStatements) {
        HashMap<String, String> options = new HashMap<String, String>();
        for (String optionsStatement : optionsStatements) {
            for (String option : optionsStatement.split(",")) {
                String[] splits = option.split("=");
                if (splits.length != 2) {
                    throw new SqlCompilationException("OPTION statement requires two parts separated by '='");
                }
                options.put(splits[0].trim(), splits[1].trim());
            }
        }
        return options;
    }

    private static List<Expression> convertDistinctSelectList(SqlNodeList selectList) {
        ArrayList<Expression> selectExpr = new ArrayList<Expression>(1);
        selectExpr.add(CalciteSqlParser.convertDistinctAndSelectListToFunctionExpression(selectList));
        return selectExpr;
    }

    private static List<Expression> convertSelectList(SqlNodeList selectList) {
        ArrayList<Expression> selectExpr = new ArrayList<Expression>(selectList.size());
        for (SqlNode sqlNode : selectList) {
            selectExpr.add(CalciteSqlParser.toExpression(sqlNode));
        }
        return selectExpr;
    }

    private static List<Expression> convertOrderByList(SqlNodeList orderList) {
        ArrayList<Expression> orderByExpr = new ArrayList<Expression>(orderList.size());
        for (SqlNode sqlNode : orderList) {
            orderByExpr.add(CalciteSqlParser.convertOrderBy(sqlNode, true));
        }
        return orderByExpr;
    }

    private static Expression convertOrderBy(SqlNode node, boolean createAscExpression) {
        Expression expression;
        if (node.getKind() == SqlKind.NULLS_LAST) {
            SqlBasicCall basicCall = (SqlBasicCall)node;
            expression = RequestUtils.getFunctionExpression(NULLS_LAST, CalciteSqlParser.convertOrderBy((SqlNode)basicCall.getOperandList().get(0), true));
        } else if (node.getKind() == SqlKind.NULLS_FIRST) {
            SqlBasicCall basicCall = (SqlBasicCall)node;
            expression = RequestUtils.getFunctionExpression(NULLS_FIRST, CalciteSqlParser.convertOrderBy((SqlNode)basicCall.getOperandList().get(0), true));
        } else if (node.getKind() == SqlKind.DESCENDING) {
            SqlBasicCall basicCall = (SqlBasicCall)node;
            expression = RequestUtils.getFunctionExpression(DESC, CalciteSqlParser.convertOrderBy((SqlNode)basicCall.getOperandList().get(0), false));
        } else if (createAscExpression) {
            expression = RequestUtils.getFunctionExpression(ASC, CalciteSqlParser.toExpression(node));
        } else {
            return CalciteSqlParser.toExpression(node);
        }
        return expression;
    }

    private static Expression convertDistinctAndSelectListToFunctionExpression(SqlNodeList selectList) {
        ArrayList<Expression> operands = new ArrayList<Expression>(selectList.size());
        for (SqlNode node : selectList) {
            Expression columnExpression = CalciteSqlParser.toExpression(node);
            if (columnExpression.getType() == ExpressionType.IDENTIFIER && columnExpression.getIdentifier().getName().equals("*")) {
                throw new SqlCompilationException("Syntax error: Pinot currently does not support DISTINCT with *. Please specify each column name after DISTINCT keyword");
            }
            if (columnExpression.getType() == ExpressionType.FUNCTION && AggregationFunctionType.isAggregationFunction((String)columnExpression.getFunctionCall().getOperator())) {
                throw new SqlCompilationException("Syntax error: Use of DISTINCT with aggregation functions is not supported");
            }
            operands.add(columnExpression);
        }
        return RequestUtils.getFunctionExpression("distinct", operands);
    }

    private static Expression toExpression(SqlNode node) {
        LOGGER.debug("Current processing SqlNode: {}, node.getKind(): {}", (Object)node, (Object)node.getKind());
        switch (node.getKind()) {
            case IDENTIFIER: {
                if (((SqlIdentifier)node).isStar()) {
                    return RequestUtils.getIdentifierExpression("*");
                }
                if (((SqlIdentifier)node).isSimple()) {
                    return RequestUtils.getIdentifierExpression(((SqlIdentifier)node).getSimple());
                }
                return RequestUtils.getIdentifierExpression(node.toString());
            }
            case INTERVAL_QUALIFIER: {
                return RequestUtils.getLiteralExpression(node.toString());
            }
            case LITERAL: {
                return RequestUtils.getLiteralExpression((SqlLiteral)node);
            }
            case AS: {
                String aliasName;
                SqlBasicCall asFuncSqlNode = (SqlBasicCall)node;
                List operands = asFuncSqlNode.getOperandList();
                Expression leftExpr = CalciteSqlParser.toExpression((SqlNode)operands.get(0));
                SqlNode aliasSqlNode = (SqlNode)operands.get(1);
                switch (aliasSqlNode.getKind()) {
                    case IDENTIFIER: {
                        aliasName = ((SqlIdentifier)aliasSqlNode).getSimple();
                        break;
                    }
                    case LITERAL: {
                        aliasName = ((SqlLiteral)aliasSqlNode).toValue();
                        break;
                    }
                    default: {
                        throw new SqlCompilationException("Unsupported Alias sql node - " + aliasSqlNode);
                    }
                }
                Expression rightExpr = RequestUtils.getIdentifierExpression(aliasName);
                if (leftExpr.isSetIdentifier() && rightExpr.isSetIdentifier() && leftExpr.getIdentifier().getName().equals(rightExpr.getIdentifier().getName())) {
                    return leftExpr;
                }
                return RequestUtils.getFunctionExpression("as", leftExpr, rightExpr);
            }
            case CASE: {
                SqlCase caseSqlNode = (SqlCase)node;
                SqlNodeList whenOperands = caseSqlNode.getWhenOperands();
                int numWhenOperands = whenOperands.size();
                SqlNodeList thenOperands = caseSqlNode.getThenOperands();
                Preconditions.checkState((numWhenOperands == thenOperands.size() ? 1 : 0) != 0);
                SqlNode elseOperand = caseSqlNode.getElseOperand();
                ArrayList<Expression> caseOperands = new ArrayList<Expression>(2 * numWhenOperands + 1);
                for (int i = 0; i < numWhenOperands; ++i) {
                    caseOperands.add(CalciteSqlParser.toExpression(whenOperands.get(i)));
                    caseOperands.add(CalciteSqlParser.toExpression(thenOperands.get(i)));
                }
                Expression elseExpression = CalciteSqlParser.toExpression(elseOperand);
                if (CalciteSqlParser.isAggregateExpression(elseExpression)) {
                    throw new SqlCompilationException("Aggregation functions inside ELSE Clause is not supported - " + elseExpression);
                }
                caseOperands.add(elseExpression);
                return RequestUtils.getFunctionExpression("case", caseOperands);
            }
        }
        if (node instanceof SqlDataTypeSpec) {
            return RequestUtils.getLiteralExpression(((SqlDataTypeSpec)node).getTypeName().getSimple());
        }
        return CalciteSqlParser.compileFunctionExpression((SqlBasicCall)node);
    }

    private static Expression compileFunctionExpression(SqlBasicCall functionNode) {
        String canonicalName;
        SqlKind functionKind = functionNode.getKind();
        boolean negated = false;
        switch (functionKind) {
            case AND: {
                return CalciteSqlParser.compileAndExpression(functionNode);
            }
            case OR: {
                return CalciteSqlParser.compileOrExpression(functionNode);
            }
            case BETWEEN: {
                negated = ((SqlBetweenOperator)functionNode.getOperator()).isNegated();
                canonicalName = SqlKind.BETWEEN.name();
                break;
            }
            case LIKE: {
                negated = ((SqlLikeOperator)functionNode.getOperator()).isNegated();
                canonicalName = SqlKind.LIKE.name();
                break;
            }
            case OTHER: 
            case OTHER_FUNCTION: 
            case DOT: {
                String functionName = functionNode.getOperator().getName();
                if (functionName.equals("ITEM") || functionName.equals("DOT")) {
                    StringBuilder pathBuilder = new StringBuilder();
                    CalciteSqlParser.compilePathExpression(functionNode, pathBuilder);
                    return RequestUtils.getIdentifierExpression(pathBuilder.toString());
                }
                canonicalName = RequestUtils.canonicalizeFunctionNamePreservingSpecialKey(functionName);
                if (functionNode.getFunctionQuantifier() == null || !"DISTINCT".equals(functionNode.getFunctionQuantifier().toString())) break;
                if (canonicalName.equals("count")) {
                    canonicalName = "distinctcount";
                    break;
                }
                if (canonicalName.equals("sum")) {
                    canonicalName = "distinctsum";
                    break;
                }
                if (canonicalName.equals("avg")) {
                    canonicalName = "distinctavg";
                    break;
                }
                if (!AggregationFunctionType.isAggregationFunction((String)canonicalName)) break;
                throw new SqlCompilationException("Function '" + functionName + "' on DISTINCT is not supported.");
            }
            default: {
                canonicalName = RequestUtils.canonicalizeFunctionNamePreservingSpecialKey(functionKind.name());
            }
        }
        List childNodes = functionNode.getOperandList();
        ArrayList<Expression> operands = new ArrayList<Expression>(childNodes.size());
        for (SqlNode childNode : childNodes) {
            if (childNode instanceof SqlNodeList) {
                for (SqlNode node : (SqlNodeList)childNode) {
                    operands.add(CalciteSqlParser.toExpression(node));
                }
                continue;
            }
            operands.add(CalciteSqlParser.toExpression(childNode));
        }
        ParserUtils.validateFunction(canonicalName, operands);
        Expression functionExpression = RequestUtils.getFunctionExpression(canonicalName, operands);
        if (negated) {
            return RequestUtils.getFunctionExpression(FilterKind.NOT.name(), functionExpression);
        }
        return functionExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void compilePathExpression(SqlBasicCall functionNode, StringBuilder pathBuilder) {
        List operands = functionNode.getOperandList();
        SqlNode operand0 = (SqlNode)operands.get(0);
        SqlKind kind0 = operand0.getKind();
        if (kind0 == SqlKind.IDENTIFIER) {
            pathBuilder.append(operand0);
        } else {
            if (kind0 != SqlKind.DOT && kind0 != SqlKind.OTHER_FUNCTION) throw new SqlCompilationException("SELECT list item has bad path expression.");
            SqlBasicCall function0 = (SqlBasicCall)operand0;
            String name0 = function0.getOperator().getName();
            if (!name0.equals("ITEM") && !name0.equals("DOT")) throw new SqlCompilationException("SELECT list item has bad path expression.");
            CalciteSqlParser.compilePathExpression(function0, pathBuilder);
        }
        SqlNode operand1 = (SqlNode)operands.get(1);
        SqlKind kind1 = operand1.getKind();
        if (kind1 == SqlKind.IDENTIFIER) {
            pathBuilder.append('.').append(((SqlIdentifier)operand1).getSimple());
            return;
        } else {
            if (kind1 != SqlKind.LITERAL) throw new SqlCompilationException("SELECT list item has bad path expression.");
            pathBuilder.append('[').append(((SqlLiteral)operand1).toValue()).append(']');
        }
    }

    private static Expression compileAndExpression(SqlBasicCall andNode) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        for (SqlNode childNode : andNode.getOperandList()) {
            if (childNode.getKind() == SqlKind.AND) {
                Expression childAndExpression = CalciteSqlParser.compileAndExpression((SqlBasicCall)childNode);
                operands.addAll(childAndExpression.getFunctionCall().getOperands());
                continue;
            }
            operands.add(CalciteSqlParser.toExpression(childNode));
        }
        return RequestUtils.getFunctionExpression(FilterKind.AND.name(), operands);
    }

    private static Expression compileOrExpression(SqlBasicCall orNode) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        for (SqlNode childNode : orNode.getOperandList()) {
            if (childNode.getKind() == SqlKind.OR) {
                Expression childAndExpression = CalciteSqlParser.compileOrExpression((SqlBasicCall)childNode);
                operands.addAll(childAndExpression.getFunctionCall().getOperands());
                continue;
            }
            operands.add(CalciteSqlParser.toExpression(childNode));
        }
        return RequestUtils.getFunctionExpression(FilterKind.OR.name(), operands);
    }

    public static boolean isLiteralOnlyExpression(Expression e) {
        if (e.getType() == ExpressionType.LITERAL) {
            return true;
        }
        if (e.getType() == ExpressionType.FUNCTION) {
            Function function = e.getFunctionCall();
            if (function.getOperator().equals("as")) {
                return CalciteSqlParser.isLiteralOnlyExpression(function.getOperands().get(0));
            }
            return false;
        }
        return false;
    }

    public static Expression removeOrderByFunctions(Expression expression) {
        while (expression.isSetFunctionCall() && ORDER_BY_FUNCTIONS.contains((Object)expression.getFunctionCall().getOperator())) {
            expression = expression.getFunctionCall().getOperands().get(0);
        }
        return expression;
    }

    @Nullable
    public static Boolean isNullsLast(Expression expression) {
        String operator = expression.getFunctionCall().getOperator();
        if (operator.equals(NULLS_LAST)) {
            return true;
        }
        if (operator.equals(NULLS_FIRST)) {
            return false;
        }
        return null;
    }

    public static boolean isAsc(Expression expression, Boolean isNullsLast) {
        if (isNullsLast != null) {
            expression = expression.getFunctionCall().getOperands().get(0);
        }
        return expression.getFunctionCall().getOperator().equals(ASC);
    }
}

