/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Identifier;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class AliasApplier
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        Map<String, Expression> aliasMap = AliasApplier.extractAlias(pinotQuery.getSelectList());
        AliasApplier.applyAlias(aliasMap, pinotQuery);
        return pinotQuery;
    }

    private static Map<String, Expression> extractAlias(List<Expression> selectExpressions) {
        HashMap<String, Expression> aliasMap = new HashMap<String, Expression>();
        for (Expression expression : selectExpressions) {
            String alias;
            Function function = expression.getFunctionCall();
            if (function == null || !function.getOperator().equals("as") || aliasMap.put(alias = function.getOperands().get(1).getIdentifier().getName(), function.getOperands().get(0)) == null) continue;
            throw new SqlCompilationException("Find duplicate alias: " + alias);
        }
        return aliasMap;
    }

    private static void applyAlias(Map<String, Expression> aliasMap, PinotQuery pinotQuery) {
        List<Expression> orderByList;
        Expression havingExpression;
        List<Expression> groupByList = pinotQuery.getGroupByList();
        if (groupByList != null) {
            for (Expression expression : groupByList) {
                AliasApplier.applyAlias(aliasMap, expression);
            }
        }
        if ((havingExpression = pinotQuery.getHavingExpression()) != null) {
            AliasApplier.applyAlias(aliasMap, havingExpression);
        }
        if ((orderByList = pinotQuery.getOrderByList()) != null) {
            for (Expression expression : orderByList) {
                AliasApplier.applyAlias(aliasMap, expression);
            }
        }
    }

    private static void applyAlias(Map<String, Expression> aliasMap, Expression expression) {
        Identifier identifier = expression.getIdentifier();
        if (identifier != null) {
            Expression aliasExpression = aliasMap.get(identifier.getName());
            if (aliasExpression != null) {
                expression.setType(aliasExpression.getType());
                expression.setIdentifier(aliasExpression.getIdentifier());
                expression.setFunctionCall(aliasExpression.getFunctionCall());
                expression.setLiteral(aliasExpression.getLiteral());
            }
            return;
        }
        Function function = expression.getFunctionCall();
        if (function != null) {
            for (Expression operand : function.getOperands()) {
                AliasApplier.applyAlias(aliasMap, operand);
            }
        }
    }
}

