/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import com.yscope.clp.compressorfrontend.AbstractClpEncodedSubquery;
import com.yscope.clp.compressorfrontend.ByteSegment;
import com.yscope.clp.compressorfrontend.EightByteClpEncodedSubquery;
import com.yscope.clp.compressorfrontend.EightByteClpWildcardQueryEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlKind;
import org.apache.pinot.common.function.TransformFunctionType;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.Literal;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class ClpRewriter
implements QueryRewriter {
    public static final String LOGTYPE_COLUMN_SUFFIX = "_logtype";
    public static final String DICTIONARY_VARS_COLUMN_SUFFIX = "_dictionaryVars";
    public static final String ENCODED_VARS_COLUMN_SUFFIX = "_encodedVars";
    private static final String _CLPDECODE_LOWERCASE_TRANSFORM_NAME = TransformFunctionType.CLP_DECODE.getName().toLowerCase();
    private static final String _REGEXP_LIKE_LOWERCASE_FUNCTION_NAME = Predicate.Type.REGEXP_LIKE.name();
    private static final char[] _NON_WILDCARD_REGEX_META_CHARACTERS = new char[]{'^', '$', '.', '{', '}', '[', ']', '(', ')', '+', '|', '<', '>', '-', '/', '=', '!'};
    private static final String _CLPMATCH_LOWERCASE_FUNCTION_NAME = "clpmatch";

    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        List<Expression> list;
        List<Expression> groupByExpressions;
        List<Expression> selectExpressions = pinotQuery.getSelectList();
        if (null != selectExpressions) {
            for (Expression expression : selectExpressions) {
                this.tryRewritingExpression(expression, false);
            }
        }
        if (null != (groupByExpressions = pinotQuery.getGroupByList())) {
            for (Expression e : groupByExpressions) {
                this.tryRewritingExpression(e, false);
            }
        }
        if (null != (list = pinotQuery.getOrderByList())) {
            for (Expression e : list) {
                this.tryRewritingExpression(e, false);
            }
        }
        this.tryRewritingExpression(pinotQuery.getFilterExpression(), true);
        this.tryRewritingExpression(pinotQuery.getHavingExpression(), true);
        return pinotQuery;
    }

    private void tryRewritingExpression(Expression expression, boolean isFilterExpression) {
        if (null == expression) {
            return;
        }
        Function function = expression.getFunctionCall();
        if (null == function) {
            return;
        }
        String functionName = function.getOperator();
        if (functionName.equals(_CLPDECODE_LOWERCASE_TRANSFORM_NAME)) {
            this.rewriteCLPDecodeFunction(expression);
            return;
        }
        if (functionName.equals(_CLPMATCH_LOWERCASE_FUNCTION_NAME)) {
            if (!isFilterExpression) {
                throw new SqlCompilationException("clpmatch cannot be used outside filter expressions.");
            }
            this.rewriteClpMatchFunction(expression);
            return;
        }
        if (this.isClpMatchEqualsFunctionCall(function)) {
            this.replaceClpMatchEquals(expression, function);
            return;
        }
        if (this.isInvertedClpMatchEqualsFunctionCall(function)) {
            List<Expression> operands = function.getOperands();
            Expression op0 = operands.get(0);
            Function f = op0.getFunctionCall();
            this.replaceClpMatchEquals(op0, f);
            return;
        }
        if (functionName.equals(SqlKind.FILTER.lowerName)) {
            isFilterExpression = true;
        }
        for (Expression op : function.getOperands()) {
            this.tryRewritingExpression(op, isFilterExpression);
        }
    }

    private boolean isInvertedClpMatchEqualsFunctionCall(Function function) {
        if (!function.getOperator().equals(SqlKind.NOT.name())) {
            return false;
        }
        List<Expression> operands = function.getOperands();
        Expression op0 = operands.get(0);
        if (!op0.getType().equals((Object)ExpressionType.FUNCTION)) {
            return false;
        }
        return this.isClpMatchEqualsFunctionCall(op0.getFunctionCall());
    }

    private boolean isClpMatchEqualsFunctionCall(Function function) {
        if (!function.getOperator().equals(SqlKind.EQUALS.name())) {
            return false;
        }
        List<Expression> operands = function.getOperands();
        Expression op0 = operands.get(0);
        Expression op1 = operands.get(1);
        if (!op0.getType().equals((Object)ExpressionType.FUNCTION) || !op1.getType().equals((Object)ExpressionType.LITERAL)) {
            return false;
        }
        Function f = op0.getFunctionCall();
        Literal l = op1.getLiteral();
        return f.getOperator().equals(_CLPMATCH_LOWERCASE_FUNCTION_NAME) && l.isSetBoolValue() && l.getBoolValue();
    }

    private void replaceClpMatchEquals(Expression expression, Function function) {
        List<Expression> operands = function.getOperands();
        Expression op0 = operands.get(0);
        this.rewriteClpMatchFunction(op0);
        expression.setFunctionCall(op0.getFunctionCall());
    }

    private void rewriteClpMatchFunction(Expression expression) {
        Function currentFunction = expression.getFunctionCall();
        List<Expression> operands = currentFunction.getOperands();
        if (operands.size() == 2) {
            Expression op0 = operands.get(0);
            if (ExpressionType.IDENTIFIER != op0.getType()) {
                throw new SqlCompilationException("clpMatch: 1st operand must be an identifier.");
            }
            String columnGroupName = op0.getIdentifier().getName();
            Expression op1 = operands.get(1);
            if (ExpressionType.LITERAL != op1.getType()) {
                throw new SqlCompilationException("clpMatch: 2nd operand must be a literal.");
            }
            String wildcardQuery = op1.getLiteral().getStringValue();
            this.rewriteClpMatchFunction(expression, columnGroupName + LOGTYPE_COLUMN_SUFFIX, columnGroupName + DICTIONARY_VARS_COLUMN_SUFFIX, columnGroupName + ENCODED_VARS_COLUMN_SUFFIX, wildcardQuery);
        } else if (operands.size() == 4) {
            int i;
            for (i = 0; i < 3; ++i) {
                Expression op = operands.get(i);
                if (ExpressionType.IDENTIFIER == op.getType()) continue;
                throw new SqlCompilationException("clpMatch: First three operands must be an identifiers.");
            }
            i = 0;
            String logtypeColumnName = operands.get(i++).getIdentifier().getName();
            String dictVarsColumnName = operands.get(i++).getIdentifier().getName();
            String encodedVarsColumnName = operands.get(i++).getIdentifier().getName();
            Expression op3 = operands.get(i);
            if (ExpressionType.LITERAL != op3.getType()) {
                throw new SqlCompilationException("clpMatch: 4th operand must be a literal.");
            }
            String wildcardQuery = op3.getLiteral().getStringValue();
            this.rewriteClpMatchFunction(expression, logtypeColumnName, dictVarsColumnName, encodedVarsColumnName, wildcardQuery);
        } else {
            throw new SqlCompilationException("clpMatch: Too few/many operands - only 2 or 4 operands are expected.");
        }
    }

    private void rewriteClpMatchFunction(Expression expression, String logtypeColumnName, String dictionaryVarsColumnName, String encodedVarsColumnName, String wildcardQuery) {
        Function newFunc;
        Function subqueriesFunc;
        if (wildcardQuery.isEmpty()) {
            Function f = new Function(SqlKind.EQUALS.name());
            f.addToOperands(RequestUtils.getIdentifierExpression(logtypeColumnName));
            f.addToOperands(RequestUtils.getLiteralExpression(""));
            expression.setFunctionCall(f);
            return;
        }
        EightByteClpWildcardQueryEncoder queryEncoder = new EightByteClpWildcardQueryEncoder("com.yscope.clp.VariablesSchemaV2", "com.yscope.clp.VariableEncodingMethodsV1");
        EightByteClpEncodedSubquery[] subqueries = queryEncoder.encode(wildcardQuery);
        boolean requireDecompAndMatch = false;
        if (1 == subqueries.length) {
            ClpSqlSubqueryGenerationResult result = this.convertSubqueryToSql(logtypeColumnName, dictionaryVarsColumnName, encodedVarsColumnName, wildcardQuery, 0, subqueries);
            requireDecompAndMatch = result.requiresDecompAndMatch();
            subqueriesFunc = result.getSqlFunc();
        } else {
            subqueriesFunc = new Function(SqlKind.OR.name());
            for (int i = 0; i < subqueries.length; ++i) {
                ClpSqlSubqueryGenerationResult result = this.convertSubqueryToSql(logtypeColumnName, dictionaryVarsColumnName, encodedVarsColumnName, wildcardQuery, i, subqueries);
                if (result.requiresDecompAndMatch()) {
                    requireDecompAndMatch = true;
                }
                Function f = result.getSqlFunc();
                Expression e = new Expression(ExpressionType.FUNCTION);
                e.setFunctionCall(f);
                subqueriesFunc.addToOperands(e);
            }
        }
        if (!requireDecompAndMatch) {
            newFunc = subqueriesFunc;
        } else {
            newFunc = new Function(SqlKind.AND.name());
            Expression e = new Expression(ExpressionType.FUNCTION);
            e.setFunctionCall(subqueriesFunc);
            newFunc.addToOperands(e);
            Function clpDecodeCall = new Function(_CLPDECODE_LOWERCASE_TRANSFORM_NAME);
            this.addCLPDecodeOperands(logtypeColumnName, dictionaryVarsColumnName, encodedVarsColumnName, Literal.stringValue(""), clpDecodeCall);
            Function clpDecodeLike = new Function(_REGEXP_LIKE_LOWERCASE_FUNCTION_NAME);
            e = new Expression(ExpressionType.FUNCTION);
            e.setFunctionCall(clpDecodeCall);
            clpDecodeLike.addToOperands(e);
            e = new Expression(ExpressionType.LITERAL);
            e.setLiteral(Literal.stringValue(ClpRewriter.wildcardQueryToRegex(wildcardQuery)));
            clpDecodeLike.addToOperands(e);
            e = new Expression(ExpressionType.FUNCTION);
            e.setFunctionCall(clpDecodeLike);
            newFunc.addToOperands(e);
        }
        expression.setFunctionCall(newFunc);
    }

    private void rewriteCLPDecodeFunction(Expression expression) {
        Function function = expression.getFunctionCall();
        List<Expression> arguments = function.getOperands();
        int numArgs = arguments.size();
        if (numArgs < 1 || numArgs > 2) {
            return;
        }
        Expression arg0 = arguments.get(0);
        if (ExpressionType.IDENTIFIER != arg0.getType()) {
            throw new SqlCompilationException("clpDecode: 1st argument must be a column group name (identifier).");
        }
        String columnGroupName = arg0.getIdentifier().getName();
        Literal defaultValueLiteral = null;
        if (numArgs > 1) {
            Expression arg1 = arguments.get(1);
            if (ExpressionType.LITERAL != arg1.getType()) {
                throw new SqlCompilationException("clpDecode: 2nd argument must be a default value (literal).");
            }
            defaultValueLiteral = arg1.getLiteral();
        }
        arguments.clear();
        this.addCLPDecodeOperands(columnGroupName, defaultValueLiteral, function);
    }

    private ClpSqlSubqueryGenerationResult convertSubqueryToSql(String logtypeColumnName, String dictionaryVarsColumnName, String encodedVarsColumnName, String wildcardQuery, int subqueryIdx, EightByteClpEncodedSubquery[] subqueries) {
        EightByteClpEncodedSubquery subquery = subqueries[subqueryIdx];
        Function logtypeMatchFunction = this.createLogtypeMatchFunction(logtypeColumnName, subquery.getLogtypeQueryAsString(), subquery.logtypeQueryContainsWildcards());
        if (!subquery.containsVariables()) {
            return new ClpSqlSubqueryGenerationResult(false, logtypeMatchFunction);
        }
        ArrayList<Expression> subqueryFunctionOperands = new ArrayList<Expression>();
        subqueryFunctionOperands.add(RequestUtils.getFunctionExpression(logtypeMatchFunction));
        int numDictVars = 0;
        for (Object dictVar : subquery.getDictVars()) {
            subqueryFunctionOperands.add(RequestUtils.getFunctionExpression(this.createStringColumnMatchFunction(SqlKind.EQUALS.name(), dictionaryVarsColumnName, dictVar.toString())));
            ++numDictVars;
        }
        int numEncodedVars = 0;
        for (ByteSegment encodedVar : (Object)subquery.getEncodedVars()) {
            Expression literal = encodedVar <= Integer.MAX_VALUE && encodedVar >= Integer.MIN_VALUE ? RequestUtils.getLiteralExpression((int)encodedVar) : RequestUtils.getLiteralExpression((long)encodedVar);
            subqueryFunctionOperands.add(RequestUtils.getFunctionExpression(SqlKind.EQUALS.name(), RequestUtils.getIdentifierExpression(encodedVarsColumnName), literal));
            ++numEncodedVars;
        }
        for (AbstractClpEncodedSubquery.VariableWildcardQuery varWildcardQuery : subquery.getDictVarWildcardQueries()) {
            subqueryFunctionOperands.add(RequestUtils.getFunctionExpression(this.createStringColumnMatchFunction(_REGEXP_LIKE_LOWERCASE_FUNCTION_NAME, dictionaryVarsColumnName, ClpRewriter.wildcardQueryToRegex(varWildcardQuery.getQuery().toString()))));
            ++numDictVars;
        }
        int numEncodedVarWildcardQueries = subquery.getNumEncodedVarWildcardQueries();
        numEncodedVars += numEncodedVarWildcardQueries;
        if (numEncodedVarWildcardQueries > 0) {
            Expression clpEncodedVarsExp = RequestUtils.getFunctionExpression(RequestUtils.canonicalizeFunctionNamePreservingSpecialKey(TransformFunctionType.CLP_ENCODED_VARS_MATCH.getName()), RequestUtils.getIdentifierExpression(logtypeColumnName), RequestUtils.getIdentifierExpression(encodedVarsColumnName), RequestUtils.getLiteralExpression(wildcardQuery), RequestUtils.getLiteralExpression(subqueryIdx));
            subqueryFunctionOperands.add(RequestUtils.getFunctionExpression(SqlKind.EQUALS.name(), clpEncodedVarsExp, RequestUtils.getLiteralExpression(true)));
        }
        boolean requiresDecompAndMatch = numDictVars >= 2 || numEncodedVars >= 2 || subquery.logtypeQueryContainsWildcards();
        return new ClpSqlSubqueryGenerationResult(requiresDecompAndMatch, RequestUtils.getFunction(SqlKind.AND.name(), subqueryFunctionOperands));
    }

    private Function createLogtypeMatchFunction(String columnName, String query, boolean containsWildcards) {
        String funcQuery;
        String funcName;
        if (containsWildcards) {
            funcName = _REGEXP_LIKE_LOWERCASE_FUNCTION_NAME;
            funcQuery = ClpRewriter.wildcardQueryToRegex(query);
        } else {
            funcName = SqlKind.EQUALS.name();
            funcQuery = query;
        }
        return this.createStringColumnMatchFunction(funcName, columnName, funcQuery);
    }

    private Function createStringColumnMatchFunction(String canonicalName, String columnName, String query) {
        return RequestUtils.getFunction(canonicalName, RequestUtils.getIdentifierExpression(columnName), RequestUtils.getLiteralExpression(query));
    }

    private void addCLPDecodeOperands(String columnGroupName, @Nullable Literal defaultValueLiteral, Function clpDecode) {
        this.addCLPDecodeOperands(columnGroupName + LOGTYPE_COLUMN_SUFFIX, columnGroupName + DICTIONARY_VARS_COLUMN_SUFFIX, columnGroupName + ENCODED_VARS_COLUMN_SUFFIX, defaultValueLiteral, clpDecode);
    }

    private void addCLPDecodeOperands(String logtypeColumnName, String dictionaryVarsColumnName, String encodedVarsColumnName, @Nullable Literal defaultValueLiteral, Function clpDecode) {
        clpDecode.addToOperands(RequestUtils.getIdentifierExpression(logtypeColumnName));
        clpDecode.addToOperands(RequestUtils.getIdentifierExpression(dictionaryVarsColumnName));
        clpDecode.addToOperands(RequestUtils.getIdentifierExpression(encodedVarsColumnName));
        if (null != defaultValueLiteral) {
            Expression e = new Expression(ExpressionType.LITERAL);
            e.setLiteral(defaultValueLiteral);
            clpDecode.addToOperands(e);
        }
    }

    private static String wildcardQueryToRegex(String wildcardQuery) {
        boolean isEscaped = false;
        StringBuilder queryWithSqlWildcards = new StringBuilder();
        if (!wildcardQuery.isEmpty() && '*' != wildcardQuery.charAt(0)) {
            queryWithSqlWildcards.append('^');
        }
        int uncopiedIdx = 0;
        block0: for (int queryIdx = 0; queryIdx < wildcardQuery.length(); ++queryIdx) {
            char queryChar = wildcardQuery.charAt(queryIdx);
            if (isEscaped) {
                isEscaped = false;
                continue;
            }
            if ('\\' == queryChar) {
                isEscaped = true;
                continue;
            }
            if (ClpRewriter.isWildcard(queryChar)) {
                queryWithSqlWildcards.append(wildcardQuery, uncopiedIdx, queryIdx);
                queryWithSqlWildcards.append('.');
                uncopiedIdx = queryIdx;
                continue;
            }
            for (char metaChar : _NON_WILDCARD_REGEX_META_CHARACTERS) {
                if (metaChar != queryChar) continue;
                queryWithSqlWildcards.append(wildcardQuery, uncopiedIdx, queryIdx);
                queryWithSqlWildcards.append('\\');
                uncopiedIdx = queryIdx;
                continue block0;
            }
        }
        if (uncopiedIdx < wildcardQuery.length()) {
            queryWithSqlWildcards.append(wildcardQuery, uncopiedIdx, wildcardQuery.length());
        }
        if (!wildcardQuery.isEmpty() && '*' != wildcardQuery.charAt(wildcardQuery.length() - 1)) {
            queryWithSqlWildcards.append('$');
        }
        return queryWithSqlWildcards.toString();
    }

    private static boolean isWildcard(char c) {
        return '*' == c || '?' == c;
    }

    private static class ClpSqlSubqueryGenerationResult {
        private final boolean _requiresDecompAndMatch;
        private final Function _sqlFunc;

        ClpSqlSubqueryGenerationResult(boolean requiresDecompAndMatch, Function sqlFunc) {
            this._requiresDecompAndMatch = requiresDecompAndMatch;
            this._sqlFunc = sqlFunc;
        }

        public boolean requiresDecompAndMatch() {
            return this._requiresDecompAndMatch;
        }

        public Function getSqlFunc() {
            return this._sqlFunc;
        }
    }
}

