/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.request.PinotQuery;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.apache.pinot.sql.parsers.SqlCompilationException;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;

public class NonAggregationGroupByToDistinctQueryRewriter
implements QueryRewriter {
    @Override
    public PinotQuery rewrite(PinotQuery pinotQuery) {
        if (pinotQuery.getGroupByListSize() == 0) {
            return pinotQuery;
        }
        for (Expression expression : pinotQuery.getSelectList()) {
            if (!CalciteSqlParser.isAggregateExpression(expression)) continue;
            return pinotQuery;
        }
        if (pinotQuery.getOrderByList() != null) {
            for (Expression expression : pinotQuery.getOrderByList()) {
                if (!CalciteSqlParser.isAggregateExpression(expression)) continue;
                return pinotQuery;
            }
        }
        HashSet<Expression> selectExpressions = new HashSet<Expression>();
        for (Expression select : pinotQuery.getSelectList()) {
            Function function = select.getFunctionCall();
            if (function != null && function.getOperator().equals("as")) {
                selectExpressions.add(function.getOperands().get(0));
                continue;
            }
            selectExpressions.add(select);
        }
        HashSet<Expression> hashSet = new HashSet<Expression>(pinotQuery.getGroupByList());
        if (selectExpressions.equals(hashSet)) {
            Expression distinct = RequestUtils.getFunctionExpression("distinct", pinotQuery.getSelectList());
            ArrayList<Expression> newSelectList = new ArrayList<Expression>(1);
            newSelectList.add(distinct);
            pinotQuery.setSelectList(newSelectList);
            pinotQuery.setGroupByList(null);
            return pinotQuery;
        }
        throw new SqlCompilationException(String.format("For non-aggregation group-by query, select expression set and group-by expression set should be the same. Found select: %s, group-by: %s", selectExpressions, hashSet));
    }
}

