/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v3.snappy;

import io.airlift.compress.v3.MalformedInputException;
import io.airlift.compress.v3.snappy.SnappyDecompressor;
import io.airlift.compress.v3.snappy.SnappyRawDecompressor;
import io.airlift.compress.v3.snappy.UnsafeUtil;
import java.lang.foreign.MemorySegment;
import java.lang.ref.Reference;
import java.util.Objects;
import sun.misc.Unsafe;

public final class SnappyJavaDecompressor
implements SnappyDecompressor {
    @Override
    public int getUncompressedLength(byte[] compressed, int compressedOffset) {
        long compressedAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressedOffset;
        long compressedLimit = Unsafe.ARRAY_BYTE_BASE_OFFSET + compressed.length;
        return SnappyRawDecompressor.getUncompressedLength(compressed, compressedAddress, compressedLimit);
    }

    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        SnappyJavaDecompressor.verifyRange(input, inputOffset, inputLength);
        SnappyJavaDecompressor.verifyRange(output, outputOffset, maxOutputLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return SnappyRawDecompressor.decompress(input, inputAddress, inputLimit, output, outputAddress, outputLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decompress(MemorySegment input, MemorySegment output) throws MalformedInputException {
        try {
            byte[] inputBase = UnsafeUtil.getBase(input);
            long inputAddress = UnsafeUtil.getAddress(input);
            long inputLimit = Math.addExact(inputAddress, input.byteSize());
            byte[] outputBase = UnsafeUtil.getBase(output);
            long outputAddress = UnsafeUtil.getAddress(output);
            long outputLimit = Math.addExact(outputAddress, output.byteSize());
            int n = SnappyRawDecompressor.decompress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit);
            return n;
        }
        finally {
            Reference.reachabilityFence(input);
            Reference.reachabilityFence(output);
        }
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

