/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.jsonpath.tree;

import io.trino.sql.jsonpath.tree.Accessor;
import io.trino.sql.jsonpath.tree.JsonPathTreeVisitor;
import io.trino.sql.jsonpath.tree.PathNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ArrayAccessor
extends Accessor {
    private final List<Subscript> subscripts;

    public ArrayAccessor(PathNode base, List<Subscript> subscripts) {
        super(base);
        this.subscripts = Objects.requireNonNull(subscripts, "subscripts is null");
    }

    @Override
    public <R, C> R accept(JsonPathTreeVisitor<R, C> visitor, C context) {
        return visitor.visitArrayAccessor(this, context);
    }

    public List<Subscript> getSubscripts() {
        return this.subscripts;
    }

    public static class Subscript {
        private final PathNode from;
        private final Optional<PathNode> to;

        public Subscript(PathNode from) {
            this.from = Objects.requireNonNull(from, "from is null");
            this.to = Optional.empty();
        }

        public Subscript(PathNode from, PathNode to) {
            this.from = Objects.requireNonNull(from, "from is null");
            this.to = Optional.of(Objects.requireNonNull(to, "to is null"));
        }

        public PathNode getFrom() {
            return this.from;
        }

        public Optional<PathNode> getTo() {
            return this.to;
        }
    }
}

