/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.TransactionMode;
import java.util.List;
import java.util.Objects;

public final class Isolation
extends TransactionMode {
    private final Level level;

    public Isolation(NodeLocation location, Level level) {
        super(location);
        this.level = Objects.requireNonNull(level, "level is null");
    }

    public Level getLevel() {
        return this.level;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIsolationLevel(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.level});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Isolation other = (Isolation)obj;
        return this.level == other.level;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("level", (Object)this.level).toString();
    }

    public static enum Level {
        SERIALIZABLE("SERIALIZABLE"),
        REPEATABLE_READ("REPEATABLE READ"),
        READ_COMMITTED("READ COMMITTED"),
        READ_UNCOMMITTED("READ UNCOMMITTED");

        private final String text;

        private Level(String text) {
            this.text = Objects.requireNonNull(text, "text is null");
        }

        public String getText() {
            return this.text;
        }
    }
}

