/*
 * Decompiled with CFR 0.152.
 */
package io.trino.hdfs;

import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public final class CallStats {
    private final TimeStat time = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat totalCalls = new CounterStat();
    private final CounterStat totalFailures = new CounterStat();
    private final CounterStat ioExceptions = new CounterStat();
    private final CounterStat fileNotFoundExceptions = new CounterStat();

    public TimeStat.BlockTimer time() {
        return this.time.time();
    }

    public void recordException(Exception exception) {
        if (exception instanceof FileNotFoundException) {
            this.fileNotFoundExceptions.update(1L);
        } else if (exception instanceof IOException) {
            this.ioExceptions.update(1L);
        }
        this.totalFailures.update(1L);
    }

    @Managed
    @Nested
    public CounterStat getTotalCalls() {
        return this.totalCalls;
    }

    @Managed
    @Nested
    public CounterStat getTotalFailures() {
        return this.totalFailures;
    }

    @Managed
    @Nested
    public CounterStat getIoExceptions() {
        return this.ioExceptions;
    }

    @Managed
    @Nested
    public CounterStat getFileNotFoundExceptions() {
        return this.fileNotFoundExceptions;
    }

    @Managed
    @Nested
    public TimeStat getTime() {
        return this.time;
    }

    public void newCall() {
        this.totalCalls.update(1L);
    }
}

