/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import io.trino.plugin.base.authentication.CachingKerberosAuthentication;
import io.trino.plugin.kudu.ForwardingKuduClient;
import java.util.Objects;
import javax.security.auth.Subject;
import org.apache.kudu.client.KuduClient;

public class KerberizedKuduClient
extends ForwardingKuduClient {
    private final KuduClient kuduClient;
    private final CachingKerberosAuthentication cachingKerberosAuthentication;

    KerberizedKuduClient(KuduClient.KuduClientBuilder kuduClientBuilder, CachingKerberosAuthentication cachingKerberosAuthentication) {
        Objects.requireNonNull(kuduClientBuilder, "kuduClientBuilder is null");
        this.cachingKerberosAuthentication = Objects.requireNonNull(cachingKerberosAuthentication, "cachingKerberosAuthentication is null");
        this.kuduClient = Subject.callAs(cachingKerberosAuthentication.getSubject(), () -> ((KuduClient.KuduClientBuilder)kuduClientBuilder).build());
    }

    @Override
    protected KuduClient delegate() {
        this.cachingKerberosAuthentication.reauthenticateIfSoonWillBeExpired();
        return this.kuduClient;
    }
}

