/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduColumnHandle;
import io.trino.plugin.kudu.KuduInsertTableHandle;
import io.trino.plugin.kudu.KuduMergeTableHandle;
import io.trino.plugin.kudu.KuduOutputTableHandle;
import io.trino.plugin.kudu.KuduTableHandle;
import io.trino.plugin.kudu.TypeHelper;
import io.trino.plugin.kudu.properties.KuduColumnProperties;
import io.trino.plugin.kudu.properties.KuduTableProperties;
import io.trino.plugin.kudu.properties.PartitionDesign;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnPosition;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.NotFoundException;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartitionSchema;

public class KuduMetadata
implements ConnectorMetadata {
    private final KuduClientSession clientSession;

    @Inject
    public KuduMetadata(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return this.clientSession.listSchemaNames();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        return this.clientSession.listTables(schemaName);
    }

    public Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        SchemaTablePrefix prefix = schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new);
        List<Object> tables = prefix.getTable().isEmpty() ? this.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)prefix.toSchemaTableName());
        HashMap<SchemaTableName, RelationColumnsMetadata> relationColumns = new HashMap<SchemaTableName, RelationColumnsMetadata>();
        Iterator iterator = tables.iterator();
        while (iterator.hasNext()) {
            SchemaTableName tableName = (SchemaTableName)iterator.next();
            ConnectorTableHandle tableHandle = this.getTableHandle(session, tableName, Optional.empty(), Optional.empty());
            if (tableHandle == null) continue;
            KuduTable table = tableHandle.getTable(this.clientSession);
            relationColumns.put(tableName, RelationColumnsMetadata.forTable((SchemaTableName)tableName, this.getColumnsMetadata(table.getSchema())));
        }
        return ((Set)relationFilter.apply(relationColumns.keySet())).stream().map(relationColumns::get).iterator();
    }

    private ColumnMetadata getColumnMetadata(ColumnSchema column) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        StringBuilder extra = new StringBuilder();
        if (column.isKey()) {
            properties.put("primary_key", true);
            extra.append("primary_key, ");
        }
        if (column.isNullable()) {
            properties.put("nullable", true);
            extra.append("nullable, ");
        }
        String encoding = KuduColumnProperties.lookupEncodingString(column.getEncoding());
        if (column.getEncoding() != ColumnSchema.Encoding.AUTO_ENCODING) {
            properties.put("encoding", encoding);
        }
        extra.append("encoding=").append(encoding).append(", ");
        String compression = KuduColumnProperties.lookupCompressionString(column.getCompressionAlgorithm());
        if (column.getCompressionAlgorithm() != ColumnSchema.CompressionAlgorithm.DEFAULT_COMPRESSION) {
            properties.put("compression", compression);
        }
        extra.append("compression=").append(compression);
        Type prestoType = TypeHelper.fromKuduColumn(column);
        return ColumnMetadata.builder().setName(column.getName()).setType(prestoType).setExtraInfo(Optional.of(extra.toString())).setProperties(properties).setComment(Optional.ofNullable(column.getComment())).build();
    }

    private ConnectorTableMetadata getTableMetadata(KuduTableHandle tableHandle) {
        KuduTable table = tableHandle.getTable(this.clientSession);
        Schema schema = table.getSchema();
        Optional<String> tableComment = Optional.ofNullable(Strings.emptyToNull((String)table.getComment()));
        List<ColumnMetadata> columns = this.getColumnsMetadata(schema);
        Map<String, Object> properties = this.clientSession.getTableProperties(tableHandle);
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), columns, properties, tableComment);
    }

    private List<ColumnMetadata> getColumnsMetadata(Schema schema) {
        return (List)schema.getColumns().stream().filter(column -> !column.isKey() || !column.getName().equals("row_uuid")).map(this::getColumnMetadata).collect(ImmutableList.toImmutableList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle connectorTableHandle) {
        KuduTableHandle tableHandle = (KuduTableHandle)connectorTableHandle;
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        Schema schema = this.clientSession.getTableSchema(tableHandle);
        this.forAllColumnHandles(schema, column -> columnHandles.put((Object)column.name(), column));
        return columnHandles.buildOrThrow();
    }

    private void forAllColumnHandles(Schema schema, Consumer<KuduColumnHandle> handleEater) {
        for (int ordinal = 0; ordinal < schema.getColumnCount(); ++ordinal) {
            ColumnSchema col = schema.getColumnByIndex(ordinal);
            String name = col.getName();
            Type type = TypeHelper.fromKuduColumn(col);
            KuduColumnHandle columnHandle = new KuduColumnHandle(name, ordinal, type);
            handleEater.accept(columnHandle);
        }
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        KuduColumnHandle kuduColumnHandle = (KuduColumnHandle)columnHandle;
        if (kuduColumnHandle.isVirtualRowId()) {
            return ColumnMetadata.builder().setName("row_uuid").setType((Type)VarbinaryType.VARBINARY).setHidden(true).build();
        }
        return kuduColumnHandle.columnMetadata();
    }

    public KuduTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        try {
            KuduTable table = this.clientSession.openTable(schemaTableName);
            OptionalInt bucketCount = OptionalInt.empty();
            List bucketSchemas = table.getPartitionSchema().getHashBucketSchemas();
            if (!bucketSchemas.isEmpty()) {
                bucketCount = OptionalInt.of(bucketSchemas.stream().mapToInt(PartitionSchema.HashBucketSchema::getNumBuckets).reduce(1, Math::multiplyExact));
            }
            return new KuduTableHandle(schemaTableName, table, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.empty(), false, bucketCount, OptionalLong.empty());
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        return this.getTableMetadata(kuduTableHandle);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        this.clientSession.createSchema(schemaName);
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        this.clientSession.dropSchema(schemaName, cascade);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        if (saveMode == SaveMode.REPLACE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        if (tableMetadata.getColumns().stream().anyMatch(column -> column.getComment() != null)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with column comment");
        }
        this.clientSession.createTable(tableMetadata, saveMode == SaveMode.IGNORE);
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        this.clientSession.dropTable(kuduTableHandle.getSchemaTableName());
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        this.clientSession.renameTable(kuduTableHandle.getSchemaTableName(), newTableName);
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata column, ColumnPosition position) {
        ColumnPosition columnPosition = position;
        Objects.requireNonNull(columnPosition);
        ColumnPosition columnPosition2 = columnPosition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ColumnPosition.First.class, ColumnPosition.After.class, ColumnPosition.Last.class}, (ColumnPosition)columnPosition2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with FIRST clause");
            }
            case 1: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with AFTER clause");
            }
            case 2: 
        }
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        this.clientSession.addColumn(kuduTableHandle.getSchemaTableName(), column);
    }

    public void dropColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        KuduColumnHandle kuduColumnHandle = (KuduColumnHandle)column;
        this.clientSession.dropColumn(kuduTableHandle.getSchemaTableName(), kuduColumnHandle.name());
    }

    public void renameColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle source, String target) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        KuduColumnHandle kuduColumnHandle = (KuduColumnHandle)source;
        this.clientSession.renameColumn(kuduTableHandle.getSchemaTableName(), kuduColumnHandle.name(), target);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle connectorTableHandle, List<ColumnHandle> insertedColumns, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        KuduTableHandle tableHandle = (KuduTableHandle)connectorTableHandle;
        KuduTable table = tableHandle.getTable(this.clientSession);
        Schema schema = table.getSchema();
        List columns = schema.getColumns();
        List columnTypes = (List)columns.stream().map(TypeHelper::fromKuduColumn).collect(ImmutableList.toImmutableList());
        return new KuduInsertTableHandle(tableHandle.getSchemaTableName(), columnTypes, columns.stream().anyMatch(column -> column.getName().equals("row_uuid")), table);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        if (replace) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        PartitionDesign design = KuduTableProperties.getPartitionDesign(tableMetadata.getProperties());
        boolean generateUUID = !design.hasPartitions();
        ConnectorTableMetadata finalTableMetadata = tableMetadata;
        if (generateUUID) {
            String rowId = "row_uuid";
            ArrayList<ColumnMetadata> copy = new ArrayList<ColumnMetadata>(tableMetadata.getColumns());
            HashMap<String, Boolean> columnProperties = new HashMap<String, Boolean>();
            columnProperties.put("primary_key", true);
            copy.add(0, ColumnMetadata.builder().setName(rowId).setType((Type)VarcharType.VARCHAR).setComment(Optional.of("key=true")).setHidden(true).setProperties(columnProperties).build());
            ImmutableList finalColumns = ImmutableList.copyOf(copy);
            HashMap<String, Object> propsCopy = new HashMap<String, Object>(tableMetadata.getProperties());
            propsCopy.put("partition_by_hash_columns", ImmutableList.of((Object)rowId));
            propsCopy.put("partition_by_hash_buckets", 2);
            ImmutableMap finalProperties = ImmutableMap.copyOf(propsCopy);
            finalTableMetadata = new ConnectorTableMetadata(tableMetadata.getTable(), (List)finalColumns, (Map)finalProperties, tableMetadata.getComment());
        }
        KuduTable table = this.clientSession.createTable(finalTableMetadata, false);
        Schema schema = table.getSchema();
        List columns = schema.getColumns();
        List columnTypes = (List)columns.stream().map(TypeHelper::fromKuduColumn).collect(ImmutableList.toImmutableList());
        List columnOriginalTypes = (List)finalTableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        return new KuduOutputTableHandle(finalTableMetadata.getTable(), columnOriginalTypes, columnTypes, generateUUID, table);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public RowChangeParadigm getRowChangeParadigm(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return RowChangeParadigm.CHANGE_ONLY_UPDATED_COLUMNS;
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return KuduColumnHandle.ROW_ID_HANDLE;
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, Map<Integer, Collection<ColumnHandle>> updateCaseColumns, RetryMode retryMode) {
        KuduTableHandle kuduTableHandle = (KuduTableHandle)tableHandle;
        KuduTable table = kuduTableHandle.getTable(this.clientSession);
        Schema schema = table.getSchema();
        List columns = schema.getColumns();
        List columnTypes = (List)columns.stream().map(TypeHelper::fromKuduColumn).collect(ImmutableList.toImmutableList());
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(kuduTableHandle);
        List columnOriginalTypes = (List)tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
        PartitionDesign design = KuduTableProperties.getPartitionDesign(tableMetadata.getProperties());
        boolean generateUUID = !design.hasPartitions();
        return new KuduMergeTableHandle(kuduTableHandle.withRequiresRowId(true), new KuduOutputTableHandle(tableMetadata.getTable(), columnOriginalTypes, columnTypes, generateUUID, table));
    }

    public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle mergeTableHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        KuduTableHandle handle = (KuduTableHandle)table;
        return new ConnectorTableProperties(handle.getConstraint(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain newDomain;
        KuduTableHandle handle = (KuduTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        if (oldDomain.equals((Object)(newDomain = oldDomain.intersect(constraint.getSummary())))) {
            return Optional.empty();
        }
        handle = new KuduTableHandle(handle.getSchemaTableName(), handle.getTable(this.clientSession), (TupleDomain<ColumnHandle>)newDomain, handle.getDesiredColumns(), handle.isRequiresRowId(), handle.getBucketCount(), handle.getLimit());
        return Optional.of(new ConstraintApplicationResult((Object)handle, constraint.getSummary(), constraint.getExpression(), false));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        KuduTableHandle handle = (KuduTableHandle)table;
        if (handle.getDesiredColumns().isPresent()) {
            return Optional.empty();
        }
        ImmutableList.Builder desiredColumns = ImmutableList.builder();
        ImmutableList.Builder assignmentList = ImmutableList.builder();
        assignments.forEach((name, column) -> {
            desiredColumns.add(column);
            assignmentList.add((Object)new Assignment(name, column, ((KuduColumnHandle)column).type()));
        });
        handle = new KuduTableHandle(handle.getSchemaTableName(), handle.getTable(this.clientSession), handle.getConstraint(), Optional.of(desiredColumns.build()), handle.isRequiresRowId(), handle.getBucketCount(), handle.getLimit());
        return Optional.of(new ProjectionApplicationResult((Object)handle, projections, (List)assignmentList.build(), false));
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        KuduTableHandle handle = (KuduTableHandle)table;
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        handle = new KuduTableHandle(handle.getSchemaTableName(), handle.getTable(this.clientSession), handle.getConstraint(), handle.getDesiredColumns(), handle.isRequiresRowId(), handle.getBucketCount(), OptionalLong.of(limit));
        return Optional.of(new LimitApplicationResult((Object)handle, false, false));
    }
}

