/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduInsertTableHandle;
import io.trino.plugin.kudu.KuduMergeTableHandle;
import io.trino.plugin.kudu.KuduOutputTableHandle;
import io.trino.plugin.kudu.KuduTableMapping;
import io.trino.plugin.kudu.RowHelper;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KeyEncoderAccessor;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduOperationApplier;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Upsert;
import org.apache.kudu.util.DateUtil;

public class KuduPageSink
implements ConnectorPageSink,
ConnectorMergeSink {
    private final ConnectorSession connectorSession;
    private final KuduClientSession session;
    private final KuduTable table;
    private final List<Type> columnTypes;
    private final List<Type> originalColumnTypes;
    private final boolean generateUUID;
    private final String uuid;
    private int nextSubId;

    public KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduInsertTableHandle tableHandle) {
        this(connectorSession, clientSession, tableHandle.getTable(clientSession), tableHandle);
    }

    public KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduOutputTableHandle tableHandle) {
        this(connectorSession, clientSession, tableHandle.getTable(clientSession), tableHandle);
    }

    public KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduMergeTableHandle tableHandle) {
        this(connectorSession, clientSession, tableHandle.getOutputTableHandle().getTable(clientSession), tableHandle);
    }

    private KuduPageSink(ConnectorSession connectorSession, KuduClientSession clientSession, KuduTable table, KuduTableMapping mapping) {
        Objects.requireNonNull(clientSession, "clientSession is null");
        this.connectorSession = connectorSession;
        this.columnTypes = mapping.getColumnTypes();
        this.originalColumnTypes = mapping.getOriginalColumnTypes();
        this.generateUUID = mapping.isGenerateUUID();
        this.table = table;
        this.session = clientSession;
        this.uuid = UUID.randomUUID().toString();
    }

    public CompletableFuture<?> appendPage(Page page) {
        CompletableFuture completableFuture;
        block11: {
            KuduOperationApplier operationApplier = KuduOperationApplier.fromKuduClientSession(this.session);
            try {
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    Upsert upsert = this.table.newUpsert();
                    PartialRow row = upsert.getRow();
                    int start = 0;
                    if (this.generateUUID) {
                        String id = String.format("%s-%08x", this.uuid, this.nextSubId++);
                        row.addString(0, id);
                        start = 1;
                    }
                    for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                        this.appendColumn(row, page, position, channel, channel + start);
                    }
                    operationApplier.applyOperationAsync((Operation)upsert);
                }
                completableFuture = NOT_BLOCKED;
                if (operationApplier == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (operationApplier != null) {
                        try {
                            operationApplier.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException | KuduException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e);
                }
            }
            operationApplier.close();
        }
        return completableFuture;
    }

    private void appendColumn(PartialRow row, Page page, int position, int channel, int destChannel) {
        Block block = page.getBlock(channel);
        Type type = this.columnTypes.get(destChannel);
        if (block.isNull(position)) {
            row.setNull(destChannel);
        } else if (DateType.DATE.equals((Object)type)) {
            row.addDate(destChannel, DateUtil.epochDaysToSqlDate((int)IntegerType.INTEGER.getInt(block, position)));
        } else if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
            row.addLong(destChannel, Timestamps.truncateEpochMicrosToMillis((long)TimestampType.TIMESTAMP_MILLIS.getLong(block, position)));
        } else if (RealType.REAL.equals((Object)type)) {
            row.addFloat(destChannel, RealType.REAL.getFloat(block, position));
        } else if (BigintType.BIGINT.equals((Object)type)) {
            row.addLong(destChannel, BigintType.BIGINT.getLong(block, position));
        } else if (IntegerType.INTEGER.equals((Object)type)) {
            row.addInt(destChannel, IntegerType.INTEGER.getInt(block, position));
        } else if (SmallintType.SMALLINT.equals((Object)type)) {
            row.addShort(destChannel, SmallintType.SMALLINT.getShort(block, position));
        } else if (TinyintType.TINYINT.equals((Object)type)) {
            row.addByte(destChannel, TinyintType.TINYINT.getByte(block, position));
        } else if (BooleanType.BOOLEAN.equals((Object)type)) {
            row.addBoolean(destChannel, BooleanType.BOOLEAN.getBoolean(block, position));
        } else if (DoubleType.DOUBLE.equals((Object)type)) {
            row.addDouble(destChannel, DoubleType.DOUBLE.getDouble(block, position));
        } else if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Type originalType = this.originalColumnTypes.get(destChannel);
            if (DateType.DATE.equals((Object)originalType)) {
                SqlDate date = (SqlDate)originalType.getObjectValue(this.connectorSession, block, position);
                LocalDateTime ldt = LocalDateTime.ofEpochSecond(TimeUnit.DAYS.toSeconds(date.getDays()), 0, ZoneOffset.UTC);
                byte[] bytes = ldt.format(DateTimeFormatter.ISO_LOCAL_DATE).getBytes(StandardCharsets.UTF_8);
                row.addStringUtf8(destChannel, bytes);
            } else {
                row.addString(destChannel, varcharType.getSlice(block, position).toStringUtf8());
            }
        } else if (VarbinaryType.VARBINARY.equals((Object)type)) {
            row.addBinary(destChannel, VarbinaryType.VARBINARY.getSlice(block, position).toByteBuffer());
        } else if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            SqlDecimal sqlDecimal = (SqlDecimal)decimalType.getObjectValue(this.connectorSession, block, position);
            row.addDecimal(destChannel, sqlDecimal.toBigDecimal());
        } else {
            throw new UnsupportedOperationException("Type is not supported: " + String.valueOf(type));
        }
    }

    public void storeMergedRows(Page page) {
        int columnCount = this.originalColumnTypes.size();
        Preconditions.checkArgument((page.getChannelCount() == 3 + columnCount ? 1 : 0) != 0, (String)"The page size should be 3 + columnCount (%s), but is %s", (int)columnCount, (int)page.getChannelCount());
        Block operationBlock = page.getBlock(columnCount);
        Block rowIds = page.getBlock(columnCount + 2);
        Schema schema = this.table.getSchema();
        try (KuduOperationApplier operationApplier = KuduOperationApplier.fromKuduClientSession(this.session);){
            for (int position = 0; position < page.getPositionCount(); ++position) {
                byte operation = TinyintType.TINYINT.getByte(operationBlock, position);
                Preconditions.checkState((operation == 3 || operation == 1 || operation == 2 ? 1 : 0) != 0, (String)"Invalid operation value, supported are %s INSERT_OPERATION_NUMBER, %s DELETE_OPERATION_NUMBER and %s UPDATE_OPERATION_NUMBER", (Object)1, (Object)2, (Object)3);
                if (operation == 2 || operation == 3) {
                    Delete delete = this.table.newDelete();
                    Slice deleteRowId = VarbinaryType.VARBINARY.getSlice(rowIds, position);
                    RowHelper.copyPrimaryKey(schema, KeyEncoderAccessor.decodePrimaryKey(schema, deleteRowId.getBytes()), delete.getRow());
                    try {
                        operationApplier.applyOperationAsync((Operation)delete);
                    }
                    catch (RuntimeException | KuduException e) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e);
                    }
                }
                if (operation != 1 && operation != 3) continue;
                Insert insert = this.table.newInsert();
                PartialRow insertRow = insert.getRow();
                int insertStart = 0;
                if (this.generateUUID) {
                    String id = String.format("%s-%08x", this.uuid, this.nextSubId++);
                    insertRow.addString(0, id);
                    insertStart = 1;
                }
                for (int channel = 0; channel < columnCount; ++channel) {
                    this.appendColumn(insertRow, page, position, channel, channel + insertStart);
                }
                try {
                    operationApplier.applyOperationAsync((Operation)insert);
                    continue;
                }
                catch (RuntimeException | KuduException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e);
                }
            }
        }
        catch (RuntimeException | KuduException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, e);
        }
    }

    public CompletableFuture<Collection<Slice>> finish() {
        return CompletableFuture.completedFuture(ImmutableList.of());
    }

    public void abort() {
    }
}

