/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduColumnHandle;
import io.trino.plugin.kudu.KuduRecordCursor;
import io.trino.plugin.kudu.KuduSplit;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import org.apache.kudu.Schema;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;

public class KuduRecordSet
implements RecordSet {
    private final KuduClientSession clientSession;
    private final KuduSplit kuduSplit;
    private final List<? extends ColumnHandle> columns;
    private KuduTable kuduTable;

    public KuduRecordSet(KuduClientSession clientSession, KuduSplit kuduSplit, List<? extends ColumnHandle> columns) {
        this.clientSession = clientSession;
        this.kuduSplit = kuduSplit;
        this.columns = columns;
    }

    public List<Type> getColumnTypes() {
        return (List)this.columns.stream().map(column -> ((KuduColumnHandle)column).type()).collect(ImmutableList.toImmutableList());
    }

    public RecordCursor cursor() {
        KuduScanner scanner = this.clientSession.createScanner(this.kuduSplit);
        Schema projectedSchema = scanner.getProjectionSchema();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < this.columns.size(); ++i) {
            KuduColumnHandle handle = (KuduColumnHandle)this.columns.get(i);
            if (handle.isVirtualRowId()) {
                builder.put((Object)i, (Object)-1);
                continue;
            }
            builder.put((Object)i, (Object)projectedSchema.getColumnIndex(handle.name()));
        }
        return new KuduRecordCursor(scanner, this.getTable(), this.getColumnTypes(), (Map<Integer, Integer>)builder.buildOrThrow());
    }

    KuduTable getTable() {
        if (this.kuduTable == null) {
            this.kuduTable = this.clientSession.openTable(this.kuduSplit.getSchemaTableName());
        }
        return this.kuduTable;
    }

    KuduClientSession getClientSession() {
        return this.clientSession;
    }
}

