/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.SchemaTableName;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class KuduSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(KuduSplit.class);
    private final SchemaTableName schemaTableName;
    private final int primaryKeyColumnCount;
    private final byte[] serializedScanToken;
    private final int bucketNumber;
    private final List<HostAddress> addresses;

    @JsonCreator
    public KuduSplit(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="primaryKeyColumnCount") int primaryKeyColumnCount, @JsonProperty(value="serializedScanToken") byte[] serializedScanToken, @JsonProperty(value="bucketNumber") int bucketNumber, @JsonProperty(value="addresses") List<HostAddress> addresses) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.primaryKeyColumnCount = primaryKeyColumnCount;
        this.serializedScanToken = Objects.requireNonNull(serializedScanToken, "serializedScanToken is null");
        Preconditions.checkArgument((bucketNumber >= 0 ? 1 : 0) != 0, (Object)"bucketNumber is negative");
        this.bucketNumber = bucketNumber;
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public byte[] getSerializedScanToken() {
        return this.serializedScanToken;
    }

    @JsonProperty
    public int getPrimaryKeyColumnCount() {
        return this.primaryKeyColumnCount;
    }

    @JsonProperty
    public int getBucketNumber() {
        return this.bucketNumber;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    public Map<String, String> getSplitInfo() {
        return ImmutableMap.of((Object)"bucketNumber", (Object)String.valueOf(this.bucketNumber), (Object)"addresses", (Object)this.addresses.stream().map(HostAddress::toString).collect(Collectors.joining(",")));
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.schemaTableName.getRetainedSizeInBytes() + SizeOf.sizeOf((byte[])this.serializedScanToken);
    }
}

