/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.KuduSessionProperties;
import io.trino.plugin.kudu.KuduSplit;
import io.trino.plugin.kudu.KuduTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class KuduSplitManager
implements ConnectorSplitManager {
    private static final ConnectorSplitSource.ConnectorSplitBatch EMPTY_BATCH = new ConnectorSplitSource.ConnectorSplitBatch((List)ImmutableList.of(), false);
    private final KuduClientSession clientSession;

    @Inject
    public KuduSplitManager(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        return new KuduDynamicFilteringSplitSource(session, this.clientSession, dynamicFilter, table);
    }

    private static class KuduDynamicFilteringSplitSource
    implements ConnectorSplitSource {
        private final KuduClientSession clientSession;
        private final DynamicFilter dynamicFilter;
        private final ConnectorTableHandle tableHandle;
        private final long dynamicFilteringTimeoutNanos;
        private ConnectorSplitSource delegateSplitSource;
        private final long startNanos;

        private KuduDynamicFilteringSplitSource(ConnectorSession connectorSession, KuduClientSession clientSession, DynamicFilter dynamicFilter, ConnectorTableHandle tableHandle) {
            this.clientSession = Objects.requireNonNull(clientSession, "clientSession is null");
            this.dynamicFilter = Objects.requireNonNull(dynamicFilter, "dynamicFilterFuture is null");
            this.tableHandle = Objects.requireNonNull(tableHandle, "splitSourceFuture is null");
            this.dynamicFilteringTimeoutNanos = (long)KuduSessionProperties.getDynamicFilteringWaitTimeout(connectorSession).getValue(TimeUnit.NANOSECONDS);
            this.startNanos = System.nanoTime();
        }

        public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
            CompletableFuture blocked = this.dynamicFilter.isBlocked();
            long remainingTimeoutNanos = this.getRemainingTimeoutNanos();
            if (remainingTimeoutNanos > 0L && this.dynamicFilter.isAwaitable()) {
                return ((CompletableFuture)blocked.thenApply(object -> EMPTY_BATCH)).completeOnTimeout(EMPTY_BATCH, remainingTimeoutNanos, TimeUnit.NANOSECONDS);
            }
            if (this.delegateSplitSource == null) {
                KuduTableHandle handle = (KuduTableHandle)this.tableHandle;
                List<KuduSplit> splits = this.clientSession.buildKuduSplits(handle, this.dynamicFilter);
                this.delegateSplitSource = new FixedSplitSource(splits);
            }
            return this.delegateSplitSource.getNextBatch(maxSize);
        }

        public void close() {
            if (this.delegateSplitSource != null) {
                this.delegateSplitSource.close();
            }
        }

        public boolean isFinished() {
            if (this.getRemainingTimeoutNanos() > 0L && this.dynamicFilter.isAwaitable()) {
                return false;
            }
            if (this.delegateSplitSource != null) {
                return this.delegateSplitSource.isFinished();
            }
            return false;
        }

        private long getRemainingTimeoutNanos() {
            return this.dynamicFilteringTimeoutNanos - (System.nanoTime() - this.startNanos);
        }
    }
}

