/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.apache.kudu.client.KuduTable;

public class KuduTableHandle
implements ConnectorTableHandle {
    private final SchemaTableName schemaTableName;
    private transient KuduTable table;
    private final TupleDomain<ColumnHandle> constraint;
    private final Optional<List<ColumnHandle>> desiredColumns;
    private final boolean requiresRowId;
    private final OptionalInt bucketCount;
    private final OptionalLong limit;

    @JsonCreator
    public KuduTableHandle(@JsonProperty(value="schemaTableName") SchemaTableName schemaTableName, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="desiredColumns") Optional<List<ColumnHandle>> desiredColumns, @JsonProperty(value="requiresRowId") boolean requiresRowId, @JsonProperty(value="bucketCount") OptionalInt bucketCount, @JsonProperty(value="limit") OptionalLong limit) {
        this(schemaTableName, null, constraint, desiredColumns, requiresRowId, bucketCount, limit);
    }

    public KuduTableHandle(SchemaTableName schemaTableName, KuduTable table, TupleDomain<ColumnHandle> constraint, Optional<List<ColumnHandle>> desiredColumns, boolean requiresRowId, @JsonProperty(value="bucketCount") OptionalInt bucketCount, @JsonProperty(value="limit") OptionalLong limit) {
        this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        this.table = table;
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.desiredColumns = Objects.requireNonNull(desiredColumns, "desiredColumns is null");
        this.requiresRowId = requiresRowId;
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is empty");
        this.limit = Objects.requireNonNull(limit, "limit is null");
    }

    public KuduTableHandle withRequiresRowId(boolean requiresRowId) {
        return new KuduTableHandle(this.schemaTableName, this.table, this.constraint, this.desiredColumns, requiresRowId, this.bucketCount, this.limit);
    }

    public KuduTable getTable(KuduClientSession session) {
        if (this.table == null) {
            this.table = session.openTable(this.schemaTableName);
        }
        return this.table;
    }

    @JsonProperty
    public SchemaTableName getSchemaTableName() {
        return this.schemaTableName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public Optional<List<ColumnHandle>> getDesiredColumns() {
        return this.desiredColumns;
    }

    @JsonProperty
    public boolean isRequiresRowId() {
        return this.requiresRowId;
    }

    @JsonProperty
    public OptionalInt getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    public int hashCode() {
        return Objects.hash(this.schemaTableName, this.constraint, this.desiredColumns, this.requiresRowId, this.bucketCount, this.limit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KuduTableHandle other = (KuduTableHandle)obj;
        return Objects.equals(this.schemaTableName, other.schemaTableName) && Objects.equals(this.constraint, other.constraint) && Objects.equals(this.desiredColumns, other.desiredColumns) && this.requiresRowId == other.requiresRowId && Objects.equals(this.bucketCount, other.bucketCount) && Objects.equals(this.limit, other.limit);
    }

    public String toString() {
        return this.schemaTableName.toString();
    }
}

