/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu;

import java.nio.charset.StandardCharsets;
import org.apache.kudu.Schema;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;

public final class RowHelper {
    private RowHelper() {
    }

    public static void copyPrimaryKey(Schema schema, RowResult from, PartialRow to) {
        block12: for (int i = 0; i < schema.getPrimaryKeyColumnCount(); ++i) {
            switch (schema.getColumnByIndex(i).getType()) {
                case STRING: {
                    to.addStringUtf8(i, from.getString(i).getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
                case INT64: 
                case UNIXTIME_MICROS: {
                    to.addLong(i, from.getLong(i));
                    continue block12;
                }
                case INT32: {
                    to.addInt(i, from.getInt(i));
                    continue block12;
                }
                case INT16: {
                    to.addShort(i, from.getShort(i));
                    continue block12;
                }
                case INT8: {
                    to.addByte(i, from.getByte(i));
                    continue block12;
                }
                case DOUBLE: {
                    to.addDouble(i, from.getDouble(i));
                    continue block12;
                }
                case FLOAT: {
                    to.addFloat(i, from.getFloat(i));
                    continue block12;
                }
                case DECIMAL: {
                    to.addDecimal(i, from.getDecimal(i));
                    continue block12;
                }
                case BOOL: {
                    to.addBoolean(i, from.getBoolean(i));
                    continue block12;
                }
                case BINARY: {
                    to.addBinary(i, from.getBinary(i));
                    continue block12;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + String.valueOf(schema.getColumnByIndex(i).getType()) + " for column " + schema.getColumnByIndex(i).getName());
                }
            }
        }
    }

    public static void copyPrimaryKey(Schema schema, PartialRow from, PartialRow to) {
        block12: for (int i = 0; i < schema.getPrimaryKeyColumnCount(); ++i) {
            switch (schema.getColumnByIndex(i).getType()) {
                case STRING: {
                    to.addStringUtf8(i, from.getString(i).getBytes(StandardCharsets.UTF_8));
                    continue block12;
                }
                case INT64: 
                case UNIXTIME_MICROS: {
                    to.addLong(i, from.getLong(i));
                    continue block12;
                }
                case INT32: {
                    to.addInt(i, from.getInt(i));
                    continue block12;
                }
                case INT16: {
                    to.addShort(i, from.getShort(i));
                    continue block12;
                }
                case INT8: {
                    to.addByte(i, from.getByte(i));
                    continue block12;
                }
                case DOUBLE: {
                    to.addDouble(i, from.getDouble(i));
                    continue block12;
                }
                case FLOAT: {
                    to.addFloat(i, from.getFloat(i));
                    continue block12;
                }
                case DECIMAL: {
                    to.addDecimal(i, from.getDecimal(i));
                    continue block12;
                }
                case BOOL: {
                    to.addBoolean(i, from.getBoolean(i));
                    continue block12;
                }
                case BINARY: {
                    to.addBinary(i, from.getBinary(i));
                    continue block12;
                }
                default: {
                    throw new IllegalStateException("Unknown type " + String.valueOf(schema.getColumnByIndex(i).getType()) + " for column " + schema.getColumnByIndex(i).getName());
                }
            }
        }
    }
}

