/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu.procedures;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.kudu.KuduClientSession;
import io.trino.plugin.kudu.properties.KuduTableProperties;
import io.trino.plugin.kudu.properties.RangePartition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;

public class RangePartitionProcedures {
    private static final MethodHandle ADD;
    private static final MethodHandle DROP;
    private final KuduClientSession clientSession;

    @Inject
    public RangePartitionProcedures(KuduClientSession clientSession) {
        this.clientSession = Objects.requireNonNull(clientSession);
    }

    public Procedure getAddPartitionProcedure() {
        return new Procedure("system", "add_range_partition", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("RANGE_BOUNDS", (Type)VarcharType.VARCHAR)), ADD.bindTo(this));
    }

    public Procedure getDropPartitionProcedure() {
        return new Procedure("system", "drop_range_partition", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("RANGE_BOUNDS", (Type)VarcharType.VARCHAR)), DROP.bindTo(this));
    }

    public void addRangePartition(String schema, String table, String rangeBounds) {
        SchemaTableName schemaTableName = new SchemaTableName(schema, table);
        RangePartition rangePartition = KuduTableProperties.parseRangePartition(rangeBounds);
        this.clientSession.addRangePartition(schemaTableName, rangePartition);
    }

    public void dropRangePartition(String schema, String table, String rangeBounds) {
        SchemaTableName schemaTableName = new SchemaTableName(schema, table);
        RangePartition rangePartition = KuduTableProperties.parseRangePartition(rangeBounds);
        this.clientSession.dropRangePartition(schemaTableName, rangePartition);
    }

    static {
        try {
            ADD = MethodHandles.lookup().unreflect(RangePartitionProcedures.class.getMethod("addRangePartition", String.class, String.class, String.class));
            DROP = MethodHandles.lookup().unreflect(RangePartitionProcedures.class.getMethod("dropRangePartition", String.class, String.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

