/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu.properties;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.kudu.properties.ColumnDesign;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.kudu.ColumnSchema;

public final class KuduColumnProperties {
    public static final String PRIMARY_KEY = "primary_key";
    public static final String NULLABLE = "nullable";
    public static final String ENCODING = "encoding";
    public static final String COMPRESSION = "compression";
    private final List<PropertyMetadata<?>> columnProperties = ImmutableList.builder().add((Object)PropertyMetadata.booleanProperty((String)"primary_key", (String)"If column belongs to primary key", (Boolean)false, (boolean)false)).add((Object)PropertyMetadata.booleanProperty((String)"nullable", (String)"If column can be set to null", (Boolean)false, (boolean)false)).add((Object)PropertyMetadata.stringProperty((String)"encoding", (String)"Optional specification of the column encoding. Otherwise default encoding is applied.", null, (boolean)false)).add((Object)PropertyMetadata.stringProperty((String)"compression", (String)"Optional specification of the column compression. Otherwise default compression is applied.", null, (boolean)false)).build();

    @Inject
    public KuduColumnProperties() {
    }

    public List<PropertyMetadata<?>> getColumnProperties() {
        return this.columnProperties;
    }

    public static ColumnDesign getColumnDesign(Map<String, Object> columnProperties) {
        String compression;
        String encoding;
        Boolean nullable;
        Objects.requireNonNull(columnProperties);
        if (columnProperties.isEmpty()) {
            return ColumnDesign.DEFAULT;
        }
        ColumnDesign design = new ColumnDesign();
        Boolean key = (Boolean)columnProperties.get(PRIMARY_KEY);
        if (key != null) {
            design.setPrimaryKey(key);
        }
        if ((nullable = (Boolean)columnProperties.get(NULLABLE)) != null) {
            design.setNullable(nullable);
        }
        if ((encoding = (String)columnProperties.get(ENCODING)) != null) {
            design.setEncoding(encoding);
        }
        if ((compression = (String)columnProperties.get(COMPRESSION)) != null) {
            design.setCompression(compression);
        }
        return design;
    }

    public static ColumnSchema.CompressionAlgorithm lookupCompression(String compression) {
        return switch (compression.toLowerCase(Locale.ENGLISH)) {
            case "default", "default_compression" -> ColumnSchema.CompressionAlgorithm.DEFAULT_COMPRESSION;
            case "no", "no_compression" -> ColumnSchema.CompressionAlgorithm.NO_COMPRESSION;
            case "lz4" -> ColumnSchema.CompressionAlgorithm.LZ4;
            case "snappy" -> ColumnSchema.CompressionAlgorithm.SNAPPY;
            case "zlib" -> ColumnSchema.CompressionAlgorithm.ZLIB;
            default -> throw new IllegalArgumentException();
        };
    }

    public static String lookupCompressionString(ColumnSchema.CompressionAlgorithm algorithm) {
        return switch (algorithm) {
            case ColumnSchema.CompressionAlgorithm.DEFAULT_COMPRESSION -> "default";
            case ColumnSchema.CompressionAlgorithm.NO_COMPRESSION -> "no";
            case ColumnSchema.CompressionAlgorithm.LZ4 -> "lz4";
            case ColumnSchema.CompressionAlgorithm.SNAPPY -> "snappy";
            case ColumnSchema.CompressionAlgorithm.ZLIB -> "zlib";
            default -> "unknown";
        };
    }

    public static ColumnSchema.Encoding lookupEncoding(String encoding) {
        return switch (encoding.toLowerCase(Locale.ENGLISH)) {
            case "auto", "auto_encoding" -> ColumnSchema.Encoding.AUTO_ENCODING;
            case "bitshuffle", "bit_shuffle" -> ColumnSchema.Encoding.BIT_SHUFFLE;
            case "dictionary", "dict_encoding" -> ColumnSchema.Encoding.DICT_ENCODING;
            case "plain", "plain_encoding" -> ColumnSchema.Encoding.PLAIN_ENCODING;
            case "prefix", "prefix_encoding" -> ColumnSchema.Encoding.PREFIX_ENCODING;
            case "runlength", "run_length", "run length", "rle" -> ColumnSchema.Encoding.RLE;
            case "group_varint" -> ColumnSchema.Encoding.GROUP_VARINT;
            default -> throw new IllegalArgumentException();
        };
    }

    public static String lookupEncodingString(ColumnSchema.Encoding encoding) {
        return switch (encoding) {
            case ColumnSchema.Encoding.AUTO_ENCODING -> "auto";
            case ColumnSchema.Encoding.BIT_SHUFFLE -> "bitshuffle";
            case ColumnSchema.Encoding.DICT_ENCODING -> "dictionary";
            case ColumnSchema.Encoding.PLAIN_ENCODING -> "plain";
            case ColumnSchema.Encoding.PREFIX_ENCODING -> "prefix";
            case ColumnSchema.Encoding.RLE -> "runlength";
            case ColumnSchema.Encoding.GROUP_VARINT -> "group_varint";
            default -> "unknown";
        };
    }
}

