/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu.properties;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.plugin.kudu.properties.HashPartitionDefinition;
import io.trino.plugin.kudu.properties.PartitionDesign;
import io.trino.plugin.kudu.properties.RangeBoundValue;
import io.trino.plugin.kudu.properties.RangePartition;
import io.trino.plugin.kudu.properties.RangePartitionDefinition;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.KeyEncoderAccessor;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionSchema;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public final class KuduTableProperties {
    public static final String PARTITION_BY_HASH_COLUMNS = "partition_by_hash_columns";
    public static final String PARTITION_BY_HASH_BUCKETS = "partition_by_hash_buckets";
    public static final String PARTITION_BY_HASH_COLUMNS_2 = "partition_by_second_hash_columns";
    public static final String PARTITION_BY_HASH_BUCKETS_2 = "partition_by_second_hash_buckets";
    public static final String PARTITION_BY_RANGE_COLUMNS = "partition_by_range_columns";
    public static final String RANGE_PARTITIONS = "range_partitions";
    public static final String NUM_REPLICAS = "number_of_replicas";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final long DEFAULT_TIMEOUT = 20000L;
    private final List<PropertyMetadata<?>> tableProperties = ImmutableList.of((Object)new PropertyMetadata("partition_by_hash_columns", "Columns for optional first hash partition level", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.integerProperty((String)"partition_by_hash_buckets", (String)"Number of buckets for optional first hash partition level.", null, (boolean)false), (Object)new PropertyMetadata("partition_by_second_hash_columns", "Columns for optional second hash partition level", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.integerProperty((String)"partition_by_second_hash_buckets", (String)"Number of buckets for optional second hash partition level.", null, (boolean)false), (Object)new PropertyMetadata("partition_by_range_columns", "Columns for optional range partition level", (io.trino.spi.type.Type)new ArrayType((io.trino.spi.type.Type)VarcharType.VARCHAR), List.class, (Object)ImmutableList.of(), false, value -> (List)((List)value).stream().map(name -> ((String)name).toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList()), value -> value), (Object)PropertyMetadata.integerProperty((String)"number_of_replicas", (String)"Number of tablet replicas. Uses default value from Kudu master if not specified.", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"range_partitions", (String)"Initial range partitions as JSON", null, (boolean)false));

    @Inject
    public KuduTableProperties() {
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static PartitionDesign getPartitionDesign(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        List hashColumns = (List)tableProperties.getOrDefault(PARTITION_BY_HASH_COLUMNS, ImmutableList.of());
        List hashColumns2 = (List)tableProperties.getOrDefault(PARTITION_BY_HASH_COLUMNS_2, ImmutableList.of());
        PartitionDesign design = new PartitionDesign();
        if (!hashColumns.isEmpty()) {
            ArrayList<HashPartitionDefinition> hashPartitions = new ArrayList<HashPartitionDefinition>();
            HashPartitionDefinition hash1 = KuduTableProperties.getHashPartitionDefinition(tableProperties, hashColumns, PARTITION_BY_HASH_BUCKETS);
            hashPartitions.add(hash1);
            if (!hashColumns2.isEmpty()) {
                HashPartitionDefinition hash2 = KuduTableProperties.getHashPartitionDefinition(tableProperties, hashColumns2, PARTITION_BY_HASH_BUCKETS_2);
                hashPartitions.add(hash2);
            }
            design.setHash(hashPartitions);
        } else if (!hashColumns2.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Table property partition_by_second_hash_columns is only allowed if there is also partition_by_hash_columns");
        }
        List rangeColumns = (List)tableProperties.getOrDefault(PARTITION_BY_RANGE_COLUMNS, ImmutableList.of());
        if (!rangeColumns.isEmpty()) {
            design.setRange(new RangePartitionDefinition(rangeColumns));
        }
        if (!design.hasPartitions()) {
            design.setRange(RangePartitionDefinition.EMPTY_RANGE_PARTITION);
        }
        return design;
    }

    private static HashPartitionDefinition getHashPartitionDefinition(Map<String, Object> tableProperties, List<String> columns, String bucketPropertyName) {
        Integer hashBuckets = (Integer)tableProperties.get(bucketPropertyName);
        if (hashBuckets == null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Missing table property " + bucketPropertyName);
        }
        return new HashPartitionDefinition(columns, hashBuckets);
    }

    public static List<RangePartition> getRangePartitions(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String json = (String)tableProperties.get(RANGE_PARTITIONS);
        if (json == null) {
            return ImmutableList.of();
        }
        Object[] partitions = (RangePartition[])JsonUtils.parseJson((ObjectMapper)mapper, (String)json, RangePartition[].class);
        if (partitions == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Object[])partitions);
    }

    public static RangePartition parseRangePartition(String json) {
        if (json == null) {
            return null;
        }
        return (RangePartition)JsonUtils.parseJson((ObjectMapper)mapper, (String)json, RangePartition.class);
    }

    public static Optional<Integer> getNumReplicas(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Integer numReplicas = (Integer)tableProperties.get(NUM_REPLICAS);
        return Optional.ofNullable(numReplicas);
    }

    public static Map<String, Object> toMap(KuduTable table) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        PartitionDesign partitionDesign = KuduTableProperties.getPartitionDesign(table);
        List<RangePartition> rangePartitionList = KuduTableProperties.getRangePartitionList(table, 20000L);
        try {
            if (partitionDesign.getHash() != null) {
                List<HashPartitionDefinition> list = partitionDesign.getHash();
                if (!list.isEmpty()) {
                    properties.put(PARTITION_BY_HASH_COLUMNS, list.get(0).columns());
                    properties.put(PARTITION_BY_HASH_BUCKETS, list.get(0).buckets());
                }
                if (list.size() >= 2) {
                    properties.put(PARTITION_BY_HASH_COLUMNS_2, list.get(1).columns());
                    properties.put(PARTITION_BY_HASH_BUCKETS_2, list.get(1).buckets());
                }
            }
            if (partitionDesign.getRange() != null) {
                properties.put(PARTITION_BY_RANGE_COLUMNS, partitionDesign.getRange().columns());
            }
            String partitionRangesValue = mapper.writeValueAsString(rangePartitionList);
            properties.put(RANGE_PARTITIONS, partitionRangesValue);
            properties.put(NUM_REPLICAS, table.getNumReplicas());
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<RangePartition> getRangePartitionList(KuduTable table, long timeout) {
        ArrayList<RangePartition> rangePartitions = new ArrayList<RangePartition>();
        if (!table.getPartitionSchema().getRangeSchema().getColumnIds().isEmpty()) {
            try {
                for (Partition partition : table.getRangePartitions(timeout)) {
                    RangePartition rangePartition = KuduTableProperties.buildRangePartition(table, partition);
                    rangePartitions.add(rangePartition);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return rangePartitions;
    }

    private static RangePartition buildRangePartition(KuduTable table, Partition partition) {
        RangeBoundValue lower = KuduTableProperties.buildRangePartitionBound(table, partition.getRangeKeyStart());
        RangeBoundValue upper = KuduTableProperties.buildRangePartitionBound(table, partition.getRangeKeyEnd());
        return new RangePartition(lower, upper);
    }

    private static RangeBoundValue buildRangePartitionBound(KuduTable table, byte[] rangeKey) {
        if (rangeKey.length == 0) {
            return null;
        }
        Schema schema = table.getSchema();
        PartitionSchema partitionSchema = table.getPartitionSchema();
        PartitionSchema.RangeSchema rangeSchema = partitionSchema.getRangeSchema();
        List rangeColumns = rangeSchema.getColumnIds();
        int numColumns = rangeColumns.size();
        PartialRow bound = KeyEncoderAccessor.decodeRangePartitionKey(schema, partitionSchema, rangeKey);
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < numColumns; ++i) {
            Object obj = KuduTableProperties.toValue(schema, bound, (Integer)rangeColumns.get(i));
            list.add(obj);
        }
        return new RangeBoundValue(list);
    }

    private static Object toValue(Schema schema, PartialRow bound, Integer idx) {
        Type type = schema.getColumnByIndex(idx.intValue()).getType();
        switch (type) {
            case UNIXTIME_MICROS: {
                long millis = bound.getLong(idx.intValue()) / 1000L;
                return ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC).print(millis);
            }
            case STRING: {
                return bound.getString(idx.intValue());
            }
            case INT64: {
                return bound.getLong(idx.intValue());
            }
            case INT32: {
                return bound.getInt(idx.intValue());
            }
            case INT16: {
                return bound.getShort(idx.intValue());
            }
            case INT8: {
                return (short)bound.getByte(idx.intValue());
            }
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                break;
            }
            case BOOL: {
                return bound.getBoolean(idx.intValue());
            }
            case BINARY: {
                return bound.getBinaryCopy(idx.intValue());
            }
        }
        throw new IllegalStateException("Unhandled type " + String.valueOf(type) + " for range partition");
    }

    public static PartitionDesign getPartitionDesign(KuduTable table) {
        Schema schema = table.getSchema();
        PartitionDesign partitionDesign = new PartitionDesign();
        PartitionSchema partitionSchema = table.getPartitionSchema();
        List hashPartitions = (List)partitionSchema.getHashBucketSchemas().stream().map(hashBucketSchema -> {
            List cols = (List)hashBucketSchema.getColumnIds().stream().map(idx -> schema.getColumnByIndex(idx.intValue()).getName()).collect(ImmutableList.toImmutableList());
            return new HashPartitionDefinition(cols, hashBucketSchema.getNumBuckets());
        }).collect(ImmutableList.toImmutableList());
        partitionDesign.setHash(hashPartitions);
        List rangeColumns = partitionSchema.getRangeSchema().getColumnIds();
        if (!rangeColumns.isEmpty()) {
            partitionDesign.setRange(new RangePartitionDefinition((List)rangeColumns.stream().map(i -> ((ColumnSchema)schema.getColumns().get((int)i)).getName()).collect(ImmutableList.toImmutableList())));
        }
        return partitionDesign;
    }

    public static PartialRow toRangeBoundToPartialRow(Schema schema, RangePartitionDefinition definition, RangeBoundValue boundValue) {
        PartialRow partialRow = new PartialRow(schema);
        if (boundValue != null) {
            List rangeColumns = (List)definition.columns().stream().map(arg_0 -> ((Schema)schema).getColumnIndex(arg_0)).collect(ImmutableList.toImmutableList());
            if (rangeColumns.size() != boundValue.getValues().size()) {
                throw new IllegalStateException("Expected " + rangeColumns.size() + " range columns, but got " + boundValue.getValues().size());
            }
            for (int i = 0; i < rangeColumns.size(); ++i) {
                Object obj = boundValue.getValues().get(i);
                int idx = (Integer)rangeColumns.get(i);
                ColumnSchema columnSchema = schema.getColumnByIndex(idx);
                KuduTableProperties.setColumnValue(partialRow, idx, obj, columnSchema.getType(), columnSchema.getName());
            }
        }
        return partialRow;
    }

    private static void setColumnValue(PartialRow partialRow, int idx, Object obj, Type type, String name) {
        switch (type) {
            case STRING: {
                if (obj instanceof String) {
                    partialRow.addString(idx, (String)obj);
                    break;
                }
                KuduTableProperties.handleInvalidValue(name, type, obj);
                break;
            }
            case INT64: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addLong(idx, n.longValue());
                break;
            }
            case INT32: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addInt(idx, n.intValue());
                break;
            }
            case INT16: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addShort(idx, n.shortValue());
                break;
            }
            case INT8: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addByte(idx, n.byteValue());
                break;
            }
            case DOUBLE: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addDouble(idx, n.doubleValue());
                break;
            }
            case FLOAT: {
                Number n = KuduTableProperties.toNumber(obj, type, name);
                partialRow.addFloat(idx, n.floatValue());
                break;
            }
            case UNIXTIME_MICROS: {
                long l = KuduTableProperties.toUnixTimeMicros(obj, type, name);
                partialRow.addLong(idx, l);
                break;
            }
            case BOOL: {
                boolean b = KuduTableProperties.toBoolean(obj, type, name);
                partialRow.addBoolean(idx, b);
                break;
            }
            case BINARY: {
                byte[] bytes = KuduTableProperties.toByteArray(obj, type, name);
                partialRow.addBinary(idx, bytes);
                break;
            }
            default: {
                KuduTableProperties.handleInvalidValue(name, type, obj);
            }
        }
    }

    private static byte[] toByteArray(Object obj, Type type, String name) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return Base64.getDecoder().decode((String)obj);
        }
        KuduTableProperties.handleInvalidValue(name, type, obj);
        return null;
    }

    private static boolean toBoolean(Object obj, Type type, String name) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        KuduTableProperties.handleInvalidValue(name, type, obj);
        return false;
    }

    private static long toUnixTimeMicros(Object obj, Type type, String name) {
        if (Number.class.isAssignableFrom(obj.getClass())) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            String s = (String)obj;
            s = s.trim().replace(' ', 'T');
            long millis = ISODateTimeFormat.dateOptionalTimeParser().withZone(DateTimeZone.UTC).parseMillis(s);
            return millis * 1000L;
        }
        KuduTableProperties.handleInvalidValue(name, type, obj);
        return 0L;
    }

    private static Number toNumber(Object obj, Type type, String name) {
        if (Number.class.isAssignableFrom(obj.getClass())) {
            return (Number)obj;
        }
        if (obj instanceof String) {
            return new BigDecimal((String)obj);
        }
        KuduTableProperties.handleInvalidValue(name, type, obj);
        return 0;
    }

    private static void handleInvalidValue(String name, Type type, Object obj) {
        throw new IllegalStateException("Invalid value " + String.valueOf(obj) + " for column " + name + " of type " + String.valueOf(type));
    }
}

