/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.kudu.schema;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.kudu.KuduClientWrapper;
import io.trino.plugin.kudu.schema.SchemaEmulation;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import java.util.List;

public class NoSchemaEmulation
implements SchemaEmulation {
    @Override
    public void createSchema(KuduClientWrapper client, String schemaName) {
        if ("default".equals(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_ALREADY_EXISTS, String.format("Schema already exists: '%s'", schemaName));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Creating schema in Kudu connector not allowed if schema emulation is disabled.");
    }

    @Override
    public void dropSchema(KuduClientWrapper client, String schemaName, boolean cascade) {
        if ("default".equals(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Deleting default schema not allowed.");
        }
        throw new SchemaNotFoundException(schemaName);
    }

    @Override
    public boolean existsSchema(KuduClientWrapper client, String schemaName) {
        return "default".equals(schemaName);
    }

    @Override
    public List<String> listSchemaNames(KuduClientWrapper client) {
        return ImmutableList.of((Object)"default");
    }

    @Override
    public String toRawName(SchemaTableName schemaTableName) {
        if ("default".equals(schemaTableName.getSchemaName())) {
            return schemaTableName.getTableName();
        }
        throw new SchemaNotFoundException(schemaTableName.getSchemaName());
    }

    @Override
    public SchemaTableName fromRawName(String rawName) {
        return new SchemaTableName("default", rawName);
    }

    @Override
    public String getPrefixForTablesOfSchema(String schemaName) {
        return "";
    }

    @Override
    public List<String> filterTablesForDefaultSchema(List<String> rawTables) {
        return rawTables;
    }
}

