/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.plugin.pinot.decoders.Decoder;
import io.trino.plugin.pinot.decoders.DecoderFactory;
import io.trino.plugin.pinot.query.PinotQueryInfo;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class PinotBrokerPageSource
implements ConnectorPageSource {
    private final PinotQueryInfo query;
    private final List<Decoder> decoders;
    private final BlockBuilder[] columnBuilders;
    private final long readTimeNanos;
    private final Iterator<PinotClient.BrokerResultRow> resultIterator;
    private boolean finished;
    private long completedBytes;
    private final AtomicLong currentRowCount = new AtomicLong();
    private final int limitForBrokerQueries;

    public PinotBrokerPageSource(ConnectorSession session, PinotQueryInfo query, List<PinotColumnHandle> columnHandles, PinotClient pinotClient, int limitForBrokerQueries) {
        this.query = Objects.requireNonNull(query, "query is null");
        this.decoders = PinotBrokerPageSource.createDecoders(columnHandles);
        this.limitForBrokerQueries = limitForBrokerQueries;
        this.columnBuilders = (BlockBuilder[])columnHandles.stream().map(PinotColumnHandle::getDataType).map(type -> type.createBlockBuilder(null, 1)).toArray(BlockBuilder[]::new);
        long start = System.nanoTime();
        this.resultIterator = pinotClient.createResultIterator(session, query, columnHandles);
        this.readTimeNanos = System.nanoTime() - start;
    }

    private static List<Decoder> createDecoders(List<PinotColumnHandle> columnHandles) {
        Objects.requireNonNull(columnHandles, "columnHandles is null");
        return (List)columnHandles.stream().map(PinotColumnHandle::getDataType).map(DecoderFactory::createDecoder).collect(ImmutableList.toImmutableList());
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Page getNextPage() {
        int i;
        if (this.finished) {
            return null;
        }
        if (!this.resultIterator.hasNext()) {
            this.finished = true;
            return null;
        }
        long size = 0L;
        int rowCount = 0;
        while (size < 0x100000L && this.resultIterator.hasNext()) {
            ++rowCount;
            if (this.currentRowCount.incrementAndGet() > (long)this.limitForBrokerQueries) {
                throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.of(this.query.query()), String.format("Broker query returned '%s' rows, maximum allowed is '%s' rows.", this.currentRowCount.get(), this.limitForBrokerQueries));
            }
            PinotClient.BrokerResultRow row = this.resultIterator.next();
            for (i = 0; i < this.decoders.size(); ++i) {
                int fieldIndex = i;
                this.decoders.get(i).decode(() -> row.getField(fieldIndex), this.columnBuilders[i]);
            }
            size = Arrays.stream(this.columnBuilders).mapToLong(BlockBuilder::getSizeInBytes).sum();
        }
        this.completedBytes += size;
        Block[] blocks = new Block[this.columnBuilders.length];
        for (i = 0; i < this.columnBuilders.length; ++i) {
            blocks[i] = this.columnBuilders[i].build();
            this.columnBuilders[i] = this.columnBuilders[i].newBlockBuilderLike(null);
        }
        if (this.decoders.isEmpty()) {
            return new Page(rowCount);
        }
        return new Page(blocks);
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public void close() {
    }
}

